/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project;

import gatchan.phpparser.project.InvalidProjectPropertiesException;
import gatchan.phpparser.project.PHPProjectChangedMessage;
import gatchan.phpparser.project.Project;
import gatchan.phpparser.project.ProjectList;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class ProjectManager {
    private Project project;
    private static ProjectManager instance;
    public static final String settingsDirectory;
    public static final String projectDirectory;
    public static final String projectVersion;
    private static final String PROJECT_NAME_PROPERTY = "gatchan.phpparser.project.file";
    private ProjectList projectList;

    private ProjectManager() {
        this.init();
        String string = jEdit.getProperty((String)PROJECT_NAME_PROPERTY);
        if (string != null) {
            Log.log((int)1, (Object)this, (Object)("Opening project " + string));
            File file = new File(projectDirectory + File.separator + string + ".project.props");
            this.openProject(file);
        }
    }

    public ProjectList getProjectList() {
        return this.projectList;
    }

    public Project getProject() {
        return this.project;
    }

    public static ProjectManager getInstance() {
        if (instance == null) {
            instance = new ProjectManager();
        }
        return instance;
    }

    private void init() {
        if (settingsDirectory != null) {
            File file = new File(projectDirectory);
            if (file.exists()) {
                String[] stringArray = file.list(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".project.props");
                    }
                });
                ArrayList<Project> arrayList = new ArrayList<Project>();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(projectDirectory, stringArray[i]);
                    if (!file2.isFile()) continue;
                    try {
                        arrayList.add(new Project(file2));
                        continue;
                    }
                    catch (InvalidProjectPropertiesException invalidProjectPropertiesException) {
                        Log.log((int)7, (Object)this, (Object)("Warning the file " + file2.getAbsolutePath() + " is not a valid project"));
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.log((int)9, (Object)this, (Object)"This error should never happens !!!!");
                        Log.log((int)9, (Object)this, (Object)fileNotFoundException);
                    }
                }
                this.projectList = new ProjectList(arrayList);
            } else {
                file.mkdirs();
                this.projectList = new ProjectList(new ArrayList());
            }
        }
    }

    public void dispose() {
        instance = null;
        if (this.project != null) {
            jEdit.setProperty((String)PROJECT_NAME_PROPERTY, (String)this.project.getName());
        }
        this.closeProject();
    }

    public void createProject() {
        String string = JOptionPane.showInputDialog("Project name : ");
        if (string == null) {
            Log.log((int)1, (Object)this, (Object)"Project creation cancelled");
        } else if (string.length() == 0) {
            JOptionPane.showMessageDialog((Component)jEdit.getActiveView(), "The project name cannot be empty");
        } else {
            Project project = new Project(string, projectVersion);
            project.save();
            EditBus.send((EBMessage)new PHPProjectChangedMessage(this, project, PHPProjectChangedMessage.SELECTED));
            this.project = project;
        }
    }

    public void deleteProject(Project project) {
        project.delete();
        if (project == this.project) {
            jEdit.setProperty((String)PROJECT_NAME_PROPERTY, null);
            this.project = null;
            EditBus.send((EBMessage)new PHPProjectChangedMessage(this, project, PHPProjectChangedMessage.DELETED));
        }
    }

    public void closeProject() {
        if (this.project != null) {
            if (this.project.needSave()) {
                this.project.save();
            }
            this.project.unload();
        }
        this.project = null;
        EditBus.send((EBMessage)new PHPProjectChangedMessage(this, null, PHPProjectChangedMessage.SELECTED));
    }

    public void openProject(File file) {
        if (this.project != null) {
            this.closeProject();
        }
        try {
            Project project = this.projectList.getProject(file);
            this.openProject(project);
        }
        catch (InvalidProjectPropertiesException invalidProjectPropertiesException) {
            Log.log((int)9, (Object)this, (Object)invalidProjectPropertiesException.getMessage());
            this.project = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log((int)9, (Object)this, (Object)fileNotFoundException.getMessage());
            this.project = null;
            jEdit.setProperty((String)PROJECT_NAME_PROPERTY, null);
        }
    }

    public void openProject(Project project) {
        ProjectLoadingTask projectLoadingTask = new ProjectLoadingTask(project);
        ThreadUtilities.runInBackground((Task)projectLoadingTask);
    }

    static {
        settingsDirectory = jEdit.getSettingsDirectory();
        projectDirectory = settingsDirectory + File.separator + "PHPParserPlugin" + File.separator + "projects";
        projectVersion = jEdit.getProperty((String)"plugin.gatchan.phpparser.projects.formatversion");
    }

    private class ProjectLoadingTask
    extends Task {
        private final Project project;

        private ProjectLoadingTask(Project project) {
            this.project = project;
            this.setLabel("PHP Project loading");
        }

        public void _run() {
            if (ProjectManager.this.project != null) {
                ProjectManager.this.closeProject();
            }
            this.project.load((ProgressObserver)this);
            ProjectManager.this.project = this.project;
            EditBus.send((EBMessage)new PHPProjectChangedMessage((Object)this, ProjectManager.this.project, PHPProjectChangedMessage.SELECTED));
        }
    }
}

