/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project.dockablepanel;

import gatchan.phpparser.project.PHPProjectChangedMessage;
import gatchan.phpparser.project.Project;
import gatchan.phpparser.project.ProjectList;
import gatchan.phpparser.project.ProjectManager;
import gatchan.phpparser.project.dockablepanel.ProjectTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public final class PHPProjectPanel
extends JPanel
implements EBComponent {
    private final ProjectTabbedPane tabs = new ProjectTabbedPane();
    private final ProjectManager projectManager;
    private final JButton buttonDel = new JButton(GUIUtilities.loadIcon((String)"Delete.png"));
    private final JButton closeProject = new JButton(GUIUtilities.loadIcon((String)"Cancel.png"));
    private final JComboBox listProjects;
    private final ProjectList projectList;
    private final JButton browseToRoot = new JButton(GUIUtilities.loadIcon((String)"Home.png"));

    public PHPProjectPanel() {
        super(new BorderLayout());
        this.buttonDel.setEnabled(false);
        this.projectManager = ProjectManager.getInstance();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(GUIUtilities.loadIcon((String)"New.png"));
        JButton jButton2 = new JButton(GUIUtilities.loadIcon((String)"Open.png"));
        jButton.setToolTipText("Create a new project");
        this.projectList = this.projectManager.getProjectList();
        this.listProjects = new JComboBox(this.projectList);
        this.listProjects.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Project project = (Project)itemEvent.getItem();
                    if (PHPProjectPanel.this.projectManager.getProject() != project) {
                        PHPProjectPanel.this.projectManager.openProject(project);
                    }
                }
            }
        });
        MyActionListener myActionListener = new MyActionListener(jButton, jButton2, this.closeProject, this.buttonDel, this.browseToRoot);
        jButton.addActionListener(myActionListener);
        jToolBar.add(jButton);
        jButton2.setToolTipText("Open a project");
        jButton2.addActionListener(myActionListener);
        this.closeProject.addActionListener(myActionListener);
        this.browseToRoot.addActionListener(myActionListener);
        this.browseToRoot.setPreferredSize(new Dimension(32, 32));
        this.browseToRoot.setToolTipText("Browse to the root of your project");
        jToolBar.add(this.closeProject);
        this.add((Component)jToolBar, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.buttonDel.setToolTipText("Delete the current project");
        this.buttonDel.addActionListener(myActionListener);
        jToolBar.add(this.buttonDel);
        this.closeProject.setToolTipText("Close the current project");
        JLabel jLabel = new JLabel("Project : ");
        this.setProject(this.projectManager.getProject());
        jPanel2.add(jLabel);
        jPanel2.add(new JScrollPane(this.listProjects));
        jPanel2.add(this.browseToRoot);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.tabs, "Center");
        this.add((Component)jPanel, "Center");
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
        this.setProject(this.projectManager.getProject());
    }

    public void removeNotify() {
        EditBus.removeFromBus((EBComponent)this);
        super.removeNotify();
        this.setProject(null);
    }

    private void setProject(Project project) {
        if (project == null) {
            this.tabs.setProject(null);
            this.buttonDel.setEnabled(false);
            this.closeProject.setEnabled(false);
            this.listProjects.setSelectedItem(null);
            this.browseToRoot.setEnabled(false);
        } else {
            this.projectList.addElement(project);
            this.buttonDel.setEnabled(true);
            this.closeProject.setEnabled(true);
            this.listProjects.getModel().setSelectedItem(project);
            this.browseToRoot.setEnabled(true);
            this.tabs.setProject(project);
            this.validate();
        }
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PHPProjectChangedMessage) {
            PHPProjectChangedMessage pHPProjectChangedMessage = (PHPProjectChangedMessage)eBMessage;
            Project project = pHPProjectChangedMessage.getSelectedProject();
            if (pHPProjectChangedMessage.getWhat() == PHPProjectChangedMessage.SELECTED || pHPProjectChangedMessage.getWhat() == PHPProjectChangedMessage.UPDATED) {
                this.setProject(project);
            } else if (pHPProjectChangedMessage.getWhat() == PHPProjectChangedMessage.DELETED) {
                this.setProject(null);
                this.projectList.removeElement(project);
            }
        }
    }

    private static final class MyActionListener
    implements ActionListener {
        private final JButton newProject;
        private final JButton openProject;
        private final JButton closeProject;
        private final JButton buttonDel;
        private final JButton browseToRoot;

        MyActionListener(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4, JButton jButton5) {
            this.newProject = jButton;
            this.openProject = jButton2;
            this.closeProject = jButton3;
            this.buttonDel = jButton4;
            this.browseToRoot = jButton5;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Object object = actionEvent.getSource();
            if (object == this.newProject) {
                projectManager.createProject();
            } else if (object == this.openProject) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(ProjectManager.projectDirectory));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setApproveButtonText("Open");
                jFileChooser.setDialogTitle("Open project ...");
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.isFile() && file.getName().endsWith(".project.props");
                    }

                    public String getDescription() {
                        return "Directories and projects";
                    }
                });
                int n = jFileChooser.showOpenDialog((Component)jEdit.getActiveView());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    projectManager.openProject(file);
                }
            } else if (object == this.closeProject) {
                projectManager.closeProject();
            } else if (object == this.buttonDel) {
                Project project = projectManager.getProject();
                int n = JOptionPane.showConfirmDialog(this.closeProject, "Do you really want to remove the project " + project.getName());
                if (n == 0) {
                    Log.log((int)1, (Object)this, (Object)"Removing project requested by user");
                    projectManager.deleteProject(project);
                }
            } else if (object == this.browseToRoot) {
                Project project = projectManager.getProject();
                String string = project.getRoot();
                View view = jEdit.getActiveView();
                if (view != null && string != null) {
                    VFSBrowser.browseDirectory((View)view, (String)string);
                }
            }
        }
    }
}

