/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project.dockablepanel;

import gatchan.phpparser.project.Project;
import gatchan.phpparser.project.dockablepanel.ProjectStatsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.GUIUtilities;

public class ProjectOptionsPanel
extends JPanel {
    private Project project;
    private final JTextField rootField = new JTextField();
    private final JButton browse = new JButton("...");
    private final JButton excludedBrowse = new JButton("...");
    private final JButton save = new JButton(GUIUtilities.loadIcon((String)"Save.png"));
    private final JButton reparse = new JButton(GUIUtilities.loadIcon((String)"Parse.png"));
    private final ProjectStatsPanel projectStatsPanel = new ProjectStatsPanel();
    private final DefaultListModel excludedListModel;
    private JPopupMenu menu;

    public ProjectOptionsPanel() {
        super(new GridBagLayout());
        int n;
        this.rootField.setEditable(false);
        JLabel jLabel = new JLabel("root : ");
        JLabel jLabel2 = new JLabel("excluded : ");
        MyActionListener myActionListener = new MyActionListener();
        this.rootField.addKeyListener(new MyKeyAdapter());
        this.rootField.setEditable(false);
        this.browse.addActionListener(myActionListener);
        this.browse.setToolTipText("Browse to find the root of your project");
        this.excludedListModel = new DefaultListModel();
        final JList jList = new JList(this.excludedListModel);
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (GUIUtilities.isRightButton((int)mouseEvent.getModifiers())) {
                    if (ProjectOptionsPanel.this.menu == null) {
                        ProjectOptionsPanel.this.menu = new JPopupMenu();
                        JMenuItem jMenuItem = new JMenuItem("remove");
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Object[] objectArray = jList.getSelectedValues();
                                if (objectArray != null) {
                                    for (int i = 0; i < objectArray.length; ++i) {
                                        ProjectOptionsPanel.this.project.removeExcludedFolder((String)objectArray[i]);
                                        ProjectOptionsPanel.this.excludedListModel.removeElement(objectArray[i]);
                                    }
                                }
                            }
                        });
                        ProjectOptionsPanel.this.menu.add(jMenuItem);
                    }
                    GUIUtilities.showPopupMenu((JPopupMenu)ProjectOptionsPanel.this.menu, (Component)jList, (int)mouseEvent.getX(), (int)mouseEvent.getY());
                }
            }
        });
        this.excludedBrowse.addActionListener(myActionListener);
        this.excludedBrowse.setToolTipText("Browse to find the root of your project");
        this.save.setEnabled(false);
        this.save.addActionListener(myActionListener);
        this.save.setToolTipText("Save the project");
        this.reparse.setToolTipText("reparse project");
        this.reparse.addActionListener(myActionListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rootField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.browse, gridBagConstraints);
        gridBagConstraints.gridheight = n = 3;
        gridBagConstraints.weighty = 1.0;
        int n2 = 0;
        gridBagConstraints.gridy = ++n2;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JScrollPane(jList), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.excludedBrowse, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        n2 += n;
        gridBagConstraints.gridy = n2++;
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.save);
        jToolBar.add(this.reparse);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.gridy = n2++;
        this.add(Box.createVerticalStrut(3), gridBagConstraints);
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.projectStatsPanel, gridBagConstraints);
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createGlue(), gridBagConstraints);
    }

    public void setProject(Project project) {
        this.project = project;
        this.excludedListModel.removeAllElements();
        if (project == null) {
            this.rootField.setText(null);
            this.setEnabled(false);
        } else {
            this.rootField.setText(project.getRoot());
            Object[] objectArray = project.getExcludedFolders();
            for (int i = 0; i < objectArray.length; ++i) {
                this.excludedListModel.addElement(objectArray[i]);
            }
            this.setEnabled(true);
        }
        this.projectStatsPanel.updateProject(project);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.browse.setEnabled(bl);
        this.excludedBrowse.setEnabled(bl);
        this.rootField.setEditable(bl);
        this.save.setEnabled(bl);
        this.reparse.setEnabled(bl);
    }

    private class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            ProjectOptionsPanel.this.save.setEnabled(true);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ProjectOptionsPanel.this.rootField.getText();
            if (actionEvent.getSource() == ProjectOptionsPanel.this.reparse) {
                ProjectOptionsPanel.this.project.rebuildProject();
            } else if (actionEvent.getSource() == ProjectOptionsPanel.this.browse) {
                String[] stringArray = GUIUtilities.showVFSFileDialog(null, (String)string, (int)3, (boolean)false);
                if (stringArray != null) {
                    ProjectOptionsPanel.this.rootField.setText(stringArray[0]);
                    ProjectOptionsPanel.this.project.setRoot(stringArray[0]);
                    ProjectOptionsPanel.this.save.setEnabled(true);
                }
            } else if (actionEvent.getSource() == ProjectOptionsPanel.this.excludedBrowse) {
                String[] stringArray = GUIUtilities.showVFSFileDialog(null, (String)string, (int)3, (boolean)true);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2 = stringArray[i];
                        if (!ProjectOptionsPanel.this.project.addExcludedFolder(string2)) continue;
                        ProjectOptionsPanel.this.excludedListModel.addElement(string2);
                    }
                    ProjectOptionsPanel.this.save.setEnabled(true);
                }
            } else if (actionEvent.getSource() == ProjectOptionsPanel.this.save) {
                ProjectOptionsPanel.this.project.setRoot(string);
                ProjectOptionsPanel.this.project.save();
                ProjectOptionsPanel.this.save.setEnabled(false);
            }
        }
    }
}

