/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project.itemfinder;

import gatchan.phpparser.project.itemfinder.PHPItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public final class PHPItemCellRenderer
implements ListCellRenderer {
    private final PHPItemCellPanel comp = new PHPItemCellPanel();
    private String searchString;

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof PHPItem) {
            this.comp.setItem((PHPItem)object, this.searchString);
        } else if (object instanceof String) {
            this.comp.setString((String)object, this.searchString);
        } else {
            this.comp.setString(object.toString(), this.searchString);
        }
        if (bl) {
            this.comp.setBackground(jList.getSelectionBackground());
        } else {
            this.comp.setBackground(jList.getBackground());
        }
        return this.comp;
    }

    public void setSearchString(String string) {
        this.searchString = string;
    }

    private static final class PHPItemCellPanel
    extends JPanel {
        private final JLabel label1 = new JLabel();
        private final JLabel label2 = new JLabel();

        private PHPItemCellPanel() {
            super(new FlowLayout(0));
            this.label2.setForeground(Color.gray);
            this.add(this.label1);
            this.add(this.label2);
        }

        private void setItem(PHPItem pHPItem, String string) {
            String string2 = pHPItem.getName();
            String string3 = PHPItemCellPanel.getHtmlText(string, string2);
            this.label1.setIcon(pHPItem.getIcon());
            this.label1.setText(string3);
            this.label2.setText(pHPItem.getPath());
        }

        private static String getHtmlText(String string, String string2) {
            String string3;
            if (string == null) {
                string3 = string2;
            } else {
                int n = string2.toLowerCase().indexOf(string);
                int n2 = string.length();
                if (n == 0) {
                    string3 = "<html><font color='blue'><b>" + string2.substring(0, n2) + "</b></font>" + string2.substring(n2) + "</html>";
                } else if (n == -1) {
                    string3 = string2;
                } else {
                    String string4 = string2.substring(0, n);
                    String string5 = string2.substring(n, n + n2);
                    String string6 = string2.substring(n + n2);
                    string3 = "<html>" + string4 + "<font color='blue'><b>" + string5 + "</b></font>" + string6 + "</html>";
                }
            }
            return string3;
        }

        private void setString(String string, String string2) {
            String string3 = PHPItemCellPanel.getHtmlText(string2, string);
            this.label1.setIcon(null);
            this.label1.setText(string3);
            this.label2.setText(null);
        }
    }
}

