/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project.itemfinder;

import common.gui.itemfinder.ItemFinder;
import gatchan.phpparser.project.Project;
import gatchan.phpparser.project.ProjectManager;
import gatchan.phpparser.project.itemfinder.PHPItem;
import gatchan.phpparser.project.itemfinder.PHPItemCellRenderer;
import gatchan.phpparser.project.itemfinder.QuickAccessItemFinder;
import gatchan.phpparser.project.itemfinder.SimpleListModel;
import java.util.ArrayList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ClassDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ClassHeader;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.PHPDocument;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPItemFinder
implements ItemFinder<PHPItem> {
    public static final int CLASS_MODE = 1;
    public static final int METHOD_MODE = 2;
    public static final int INTERFACE_MODE = 8;
    public static final int FIELD_MODE = 4;
    public static final int ALL_MODE = 15;
    public static final int PROJECT_SCOPE = 0;
    public static final int FILE_SCOPE = 1;
    private final PHPItemCellRenderer listCellRenderer = new PHPItemCellRenderer();
    private final ProjectManager projectManager = ProjectManager.getInstance();
    private final SimpleListModel listModel = new SimpleListModel();
    private int scope;
    private View view;
    private String label;
    private String lastSearch;

    public void init(View view, int n, int n2) {
        this.view = view;
        this.scope = n2;
        this.lastSearch = null;
        this.listModel.clear();
        this.listModel.setMode(n);
        this.label = n == 1 ? jEdit.getProperty((String)"gatchan-phpparser.itemfinder.searchLabel.class") : (n == 8 ? jEdit.getProperty((String)"gatchan-phpparser.itemfinder.searchLabel.interface") : (n == 4 ? jEdit.getProperty((String)"gatchan-phpparser.itemfinder.searchLabel.field") : (n == 2 ? jEdit.getProperty((String)"gatchan-phpparser.itemfinder.searchLabel.method") : jEdit.getProperty((String)"gatchan-phpparser.itemfinder.searchLabel.default"))));
    }

    public String getLabel() {
        return "PHP Item Finder";
    }

    public int getWidth() {
        return 400;
    }

    public ListModel getModel() {
        return this.listModel;
    }

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public void updateList(String string) {
        long l = System.currentTimeMillis();
        Project project = this.projectManager.getProject();
        if (project != null) {
            QuickAccessItemFinder quickAccessItemFinder = project.getQuickAccess();
            String string2 = string.toLowerCase();
            this.listCellRenderer.setSearchString(string2);
            int n = string2.length();
            if (n != 0 && (this.scope == 0 && QuickAccessItemFinder.getIndexLength() > n || this.lastSearch == null || this.lastSearch.length() == 0 || n < this.lastSearch.length() || !string2.startsWith(this.lastSearch))) {
                ArrayList<AstNode> arrayList;
                if (this.scope == 0) {
                    long l2 = System.currentTimeMillis();
                    arrayList = new ArrayList<AstNode>(quickAccessItemFinder.getItemContaining(string2));
                    Log.log((int)1, QuickAccessItemFinder.class, (Object)(System.currentTimeMillis() - l2 + " ms"));
                } else {
                    Buffer buffer = jEdit.getActiveView().getBuffer();
                    PHPDocument pHPDocument = (PHPDocument)buffer.getProperty((Object)"PHPDocument");
                    arrayList = new ArrayList();
                    if (pHPDocument != null) {
                        for (int i = 0; i < pHPDocument.size(); ++i) {
                            Statement statement;
                            Outlineable outlineable = pHPDocument.get(i);
                            if (outlineable instanceof ClassDeclaration) {
                                statement = (ClassDeclaration)outlineable;
                                ClassHeader classHeader = ((ClassDeclaration)statement).getClassHeader();
                                arrayList.addAll(classHeader.getMethodsHeaders());
                                arrayList.add(classHeader);
                                continue;
                            }
                            if (!(outlineable instanceof MethodDeclaration)) continue;
                            statement = (MethodDeclaration)outlineable;
                            arrayList.add(((MethodDeclaration)statement).getMethodHeader());
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    this.listModel.clear();
                } else {
                    this.listModel.setList(arrayList, string2);
                }
            } else {
                this.listModel.filter(string2);
            }
            this.lastSearch = string2;
        }
        long l3 = System.currentTimeMillis();
        Log.log((int)1, (Object)this, (Object)(l3 - l + "ms"));
    }

    public void selectionMade(final PHPItem pHPItem) {
        if (pHPItem != null) {
            String string = pHPItem.getPath();
            final Buffer buffer = jEdit.openFile((View)this.view, (String)string);
            VFSManager.runInAWTThread((Runnable)new Runnable(){

                public void run() {
                    JEditTextArea jEditTextArea = jEdit.getActiveView().getTextArea();
                    int n = buffer.getLineStartOffset(pHPItem.getBeginLine() - 1) + pHPItem.getBeginColumn() - 1;
                    jEditTextArea.moveCaretPosition(n);
                    Log.log((int)3, (Object)this, (Object)("Moving to line " + (pHPItem.getBeginLine() - 1) + ' ' + n));
                }
            });
        }
    }
}

