/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.sidekick;

import errorlist.DefaultErrorSource;
import gatchan.phpparser.PHPErrorSource;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.ParseException;
import gatchan.phpparser.parser.ParsingAbortedError;
import gatchan.phpparser.project.PHPProjectChangedMessage;
import gatchan.phpparser.project.Project;
import gatchan.phpparser.project.ProjectManager;
import gatchan.phpparser.project.itemfinder.PHPItem;
import gatchan.phpparser.sidekick.PHPSideKickCompletion;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ClassDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ClassHeader;
import net.sourceforge.phpdt.internal.compiler.ast.ConstantIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.InterfaceDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.InterfaceIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.MethodHeader;
import net.sourceforge.phpdt.internal.compiler.ast.PHPDocument;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;
import sidekick.IAsset;
import sidekick.SideKickCompletion;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;

public class PHPSideKickParser
extends SideKickParser {
    private PHPParser parser;
    private final ProjectManager projectManager;
    private final PHPErrorSource phpErrorSource = new PHPErrorSource();
    public static final String PHPDOCUMENT_PROPERTY = "PHPDocument";

    public PHPSideKickParser(String string) {
        super(string);
        this.projectManager = ProjectManager.getInstance();
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource defaultErrorSource) {
        this.phpErrorSource.setErrorSource(defaultErrorSource);
        String string = buffer.getPath();
        Project project = this.projectManager.getProject();
        if (project != null) {
            project.clearSourceFile(string);
        }
        if (this.parser != null && !this.parser.isStopped()) {
            Log.log((int)9, PHPSideKickParser.class, (Object)"The parser had not been stopped before asking a new parse !");
            this.stop();
        }
        this.parser = new PHPParser();
        this.parser.setPath(string);
        try {
            defaultErrorSource.removeFileErrors(string);
            this.parser.addParserListener(this.phpErrorSource);
            try {
                this.parser.parse(buffer.getText(0, buffer.getLength()));
            }
            catch (ParsingAbortedError parsingAbortedError) {
                Log.log((int)3, PHPSideKickParser.class, (Object)"The parser was aborted");
                return null;
            }
            PHPDocument pHPDocument = this.parser.getPHPDocument();
            this.updateProject(pHPDocument, string);
            buffer.setProperty(PHPDOCUMENT_PROPERTY, (Object)pHPDocument);
            this.parser = null;
            SideKickParsedData sideKickParsedData = new SideKickParsedData(buffer.getName());
            this.buildChildNodes(sideKickParsedData.root, pHPDocument, buffer);
            EditBus.sendAsync((EBMessage)new PHPProjectChangedMessage((Object)this, this.projectManager.getProject(), PHPProjectChangedMessage.UPDATED));
            return sideKickParsedData;
        }
        catch (ParseException parseException) {
            this.parser = null;
            Log.log((int)9, (Object)((Object)this), (Object)parseException);
            defaultErrorSource.addError(0, string, parseException.currentToken.beginLine - 1, parseException.currentToken.beginColumn, parseException.currentToken.endColumn, "Unhandled error please report the bug (with the trace in the activity log");
        }
        catch (Throwable throwable) {
            this.parser = null;
            Log.log((int)9, (Object)((Object)this), (Object)throwable);
        }
        return null;
    }

    public void parse(String string, Reader reader) {
        PHPParser pHPParser = new PHPParser();
        pHPParser.setPath(string);
        try {
            pHPParser.parse(reader);
        }
        catch (ParsingAbortedError parsingAbortedError) {
            Log.log((int)3, PHPSideKickParser.class, (Object)"The parser was aborted");
        }
        catch (ParseException parseException) {
            Log.log((int)3, PHPSideKickParser.class, (Object)parseException.getMessage());
        }
        PHPDocument pHPDocument = pHPParser.getPHPDocument();
        this.updateProject(pHPDocument, string);
    }

    public void stop() {
        if (this.parser != null) {
            Log.log((int)3, PHPSideKickParser.class, (Object)"Stopping parser");
            this.parser.stop();
        }
    }

    private void buildChildNodes(DefaultMutableTreeNode defaultMutableTreeNode, Outlineable outlineable, Buffer buffer) {
        for (int i = 0; i < outlineable.size(); ++i) {
            Outlineable outlineable2 = outlineable.get(i);
            this.buildNode(defaultMutableTreeNode, outlineable2, buffer);
        }
    }

    private void buildNode(DefaultMutableTreeNode defaultMutableTreeNode, Outlineable outlineable, Buffer buffer) {
        AstNode astNode = (AstNode)((Object)outlineable);
        Position position = buffer.createPosition(buffer.getLineStartOffset(astNode.getBeginLine() - 1) + astNode.getBeginColumn());
        System.out.println("ASTNODE=" + astNode + ' ' + astNode.getEndLine());
        Position position2 = buffer.createPosition(buffer.getLineStartOffset(astNode.getEndLine() - 1) + astNode.getEndColumn());
        IAsset iAsset = (IAsset)astNode;
        iAsset.setStart(position);
        iAsset.setEnd(position2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(outlineable, true);
        this.buildChildNodes(defaultMutableTreeNode2, outlineable, buffer);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public boolean supportsCompletion() {
        return true;
    }

    public SideKickCompletion complete(EditPane editPane, int n) {
        Buffer buffer = editPane.getBuffer();
        PHPDocument pHPDocument = (PHPDocument)buffer.getProperty((Object)PHPDOCUMENT_PROPERTY);
        return super.complete(editPane, n);
    }

    public SideKickCompletion complete0(EditPane editPane, int n) {
        Object object;
        Object object2;
        int n2;
        AstNode astNode;
        PHPSideKickCompletion pHPSideKickCompletion;
        Log.log((int)1, (Object)((Object)this), (Object)"Requesting sidekick complete");
        Buffer buffer = editPane.getBuffer();
        PHPDocument pHPDocument = (PHPDocument)buffer.getProperty((Object)PHPDOCUMENT_PROPERTY);
        if (pHPDocument == null) {
            Log.log((int)1, (Object)((Object)this), (Object)"No php document for this buffer");
            return null;
        }
        JEditTextArea jEditTextArea = editPane.getTextArea();
        int n3 = jEditTextArea.getCaretLine();
        int n4 = n - buffer.getLineStartOffset(n3);
        if (n4 == 0) {
            return null;
        }
        String string = buffer.getLineText(n3);
        int n5 = TextUtilities.findWordStart((String)string, (int)(n4 - 1), (String)"");
        String string2 = string.substring(n5, n4);
        Project project = this.projectManager.getProject();
        if (project != null && (pHPSideKickCompletion = PHPSideKickParser.completeStaticClassAccess(string2, string, n5, project)) != null) {
            return pHPSideKickCompletion;
        }
        ClassDeclaration classDeclaration = PHPSideKickParser.classDeclarationAtOffset(editPane.getView(), n);
        String string3 = PHPSideKickParser.getPreviousWord(n, (JEditBuffer)buffer);
        AstNode astNode2 = pHPDocument.getNodeAt(n3 + 1, n4);
        if (astNode2 != null) {
            Log.log((int)1, (Object)((Object)this), (Object)("Statement at caret " + astNode2));
            astNode = astNode2.subNodeAt(n3 + 1, n4);
            if (astNode != null) {
                Log.log((int)1, (Object)((Object)this), (Object)("Expression at caret " + astNode));
            }
        }
        if (classDeclaration == null) {
            astNode = pHPDocument.methodAtOffset(n3, n4);
        } else {
            astNode = classDeclaration.insideWichMethodIsThisOffset(n3, n4);
            if (astNode == null && (string3.endsWith(";") || string3.endsWith("{") || string3.endsWith("}"))) {
                pHPSideKickCompletion = new PHPSideKickCompletion(string2, string3);
                pHPSideKickCompletion.addItem("var", string2);
                pHPSideKickCompletion.addItem("function", string2);
                return pHPSideKickCompletion;
            }
        }
        String string4 = null;
        if (n5 != 0) {
            n2 = TextUtilities.findWordStart((String)string, (int)(n5 - 1), (String)"$_->");
            string4 = string.substring(n2, n5);
        }
        if ("::".equals(string2) || "::".equals(string4)) {
            String string5 = string3.substring(0, string3.indexOf("::"));
            if ("self".equals(string5)) {
                if (classDeclaration == null) {
                    return null;
                }
                object2 = classDeclaration.getClassHeader();
            } else {
                object2 = this.getClassHeader(string5, pHPDocument);
            }
            object = "::".equals(string2) ? "" : string2;
            pHPSideKickCompletion = PHPSideKickParser.completeClassMembers((ClassHeader)object2, (String)object, string4 + "::");
            if (pHPSideKickCompletion != null) {
                return pHPSideKickCompletion;
            }
        }
        if (string4 != null && string4.charAt(0) == '$' && ("->".equals(string2) || string4.endsWith("->")) && astNode != null) {
            ClassHeader classHeader;
            String string6;
            n2 = string4.indexOf("->");
            object2 = n2 == -1 ? string4.substring(1) : string4.substring(1, n2);
            object = ((MethodDeclaration)astNode).getAssignedVariableInCode((String)object2, n3, n4);
            String string7 = string6 = object == null ? null : ((VariableUsage)object).getType().getClassName();
            if (string6 != null && (classHeader = this.getClassHeader(string6, pHPDocument)) != null) {
                String string8 = "->".equals(string2) ? "" : string2;
                pHPSideKickCompletion = PHPSideKickParser.completeClassMembers(classHeader, string8, string4);
                return pHPSideKickCompletion;
            }
        } else if ("$this->".equals(string4) || "->".equals(string2) && "$this".equals(string4)) {
            Log.log((int)1, (Object)((Object)this), (Object)"Completing $this->");
            pHPSideKickCompletion = "->".equals(string2) ? PHPSideKickParser.completeClassMembers(classDeclaration.getClassHeader(), "", "$this->") : PHPSideKickParser.completeClassMembers(classDeclaration.getClassHeader(), string2, "$this->");
            return pHPSideKickCompletion;
        }
        if ("new".equals(string3) || "extends".equals(string3)) {
            Log.log((int)1, (Object)((Object)this), (Object)"Completing class name");
            return this.buildClassNameList(string2.trim(), string3, pHPDocument);
        }
        return null;
    }

    private static ClassDeclaration classDeclarationAtOffset(View view, int n) {
        IAsset iAsset;
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData((View)view);
        if (sideKickParsedData == null) {
            return null;
        }
        int n2 = n;
        IAsset iAsset2 = null;
        do {
            if ((iAsset = sideKickParsedData.getAssetAtOffset(n2)) == null) {
                return null;
            }
            while (iAsset2 == iAsset) {
                if ((iAsset = sideKickParsedData.getAssetAtOffset(n2--)) != null) continue;
                return null;
            }
            iAsset2 = iAsset;
            n2 = iAsset.getStart().getOffset() - 1;
        } while (!(iAsset instanceof ClassDeclaration));
        ClassDeclaration classDeclaration = (ClassDeclaration)iAsset;
        return classDeclaration;
    }

    private ClassHeader getClassHeader(String string, Outlineable outlineable) {
        Project project = this.projectManager.getProject();
        ClassHeader classHeader = null;
        if (project != null) {
            classHeader = project.getClass(string);
        }
        if (classHeader == null) {
            for (int i = 0; i < outlineable.size(); ++i) {
                Outlineable outlineable2 = outlineable.get(i);
                if (!(outlineable2 instanceof ClassDeclaration) || !outlineable2.getName().equals(string)) continue;
                classHeader = ((ClassDeclaration)outlineable2).getClassHeader();
            }
        }
        return classHeader;
    }

    private static PHPSideKickCompletion completeStaticClassAccess(String string, String string2, int n, Project project) {
        PHPSideKickCompletion pHPSideKickCompletion = null;
        if ("::".equals(string)) {
            int n2 = TextUtilities.findWordStart((String)string2, (int)(n - 1), (String)"_");
            String string3 = string2.substring(n2, n);
            ClassHeader classHeader = project.getClass(string3);
            pHPSideKickCompletion = PHPSideKickParser.completeClassMembers(classHeader, "", string3 + "::");
        } else if (n > 2 && (string2.charAt(n - 1) == ':' || string2.charAt(n - 2) == ':')) {
            int n3 = TextUtilities.findWordStart((String)string2, (int)(n - 3), (String)"_");
            String string4 = string2.substring(n3, n - 2);
            ClassHeader classHeader = project.getClass(string4);
            pHPSideKickCompletion = PHPSideKickParser.completeClassMembers(classHeader, string, string4 + "::");
        }
        return pHPSideKickCompletion;
    }

    private static String getPreviousWord(int n, JEditBuffer jEditBuffer) {
        char c;
        int n2;
        int n3;
        for (n3 = n - 1; n3 > 0 && Character.isWhitespace((char)(n2 = (int)jEditBuffer.getText(n3, 1).charAt(0))); --n3) {
        }
        for (n2 = n3 - 1; n2 > 0 && !Character.isWhitespace(c = jEditBuffer.getText(n2, 1).charAt(0)); --n2) {
        }
        return jEditBuffer.getText(n2 + '\u0001', n3 - n2);
    }

    private SideKickCompletion buildClassNameList(String string, String string2, Outlineable outlineable) {
        Object object;
        PHPSideKickCompletion pHPSideKickCompletion = new PHPSideKickCompletion(string, string2);
        Project project = this.projectManager.getProject();
        if (project != null) {
            Map<String, Object> map = project.getClasses();
            object = map.values();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (object2 instanceof PHPItem) {
                    pHPSideKickCompletion.addItem(object2, string);
                    continue;
                }
                Iterable iterable = (Iterable)object2;
                for (PHPItem pHPItem : iterable) {
                    pHPSideKickCompletion.addItem(pHPItem, string);
                }
            }
        }
        for (int i = 0; i < outlineable.size(); ++i) {
            object = outlineable.get(i);
            if (!(object instanceof ClassDeclaration)) continue;
            pHPSideKickCompletion.addItem(object, string);
        }
        Log.log((int)1, (Object)((Object)this), (Object)("Items in list : " + pHPSideKickCompletion.getItemsCount()));
        return pHPSideKickCompletion;
    }

    private void updateProject(Outlineable outlineable, String string) {
        Project project = this.projectManager.getProject();
        if (project != null && project.acceptFile(string)) {
            for (int i = 0; i < outlineable.size(); ++i) {
                Statement statement;
                Outlineable outlineable2 = outlineable.get(i);
                if (outlineable2.getItemType() == 1) {
                    statement = (ClassDeclaration)outlineable2;
                    project.addClass(((ClassDeclaration)statement).getClassHeader());
                    continue;
                }
                if (outlineable2.getItemType() == 2) {
                    statement = (MethodDeclaration)outlineable2;
                    project.addMethod(((MethodDeclaration)statement).getMethodHeader());
                    continue;
                }
                if (outlineable2.getItemType() != 8) continue;
                project.addInterface((InterfaceDeclaration)outlineable2);
            }
        }
    }

    private static PHPSideKickCompletion completeClassMembers(ClassHeader classHeader, String string, String string2) {
        if (classHeader == null) {
            return null;
        }
        PHPSideKickCompletion pHPSideKickCompletion = new PHPSideKickCompletion(string, string2);
        PHPSideKickParser.completeClassMembers(classHeader, pHPSideKickCompletion, string);
        Log.log((int)1, PHPSideKickParser.class, (Object)("Items in list : " + pHPSideKickCompletion.getItemsCount()));
        return pHPSideKickCompletion;
    }

    private static void completeClassMembers(ClassHeader classHeader, PHPSideKickCompletion pHPSideKickCompletion, String string) {
        List<MethodHeader> list = classHeader.getMethodsHeaders();
        List<FieldDeclaration> list2 = classHeader.getFields();
        pHPSideKickCompletion.addOutlineableList(list, string);
        pHPSideKickCompletion.addOutlineableList(list2, string);
        String string2 = classHeader.getSuperClassName();
        Project project = ProjectManager.getInstance().getProject();
        if (project != null) {
            Object object;
            if (string2 != null) {
                object = project.getClass(string2);
                if (object == null) {
                    Log.log((int)1, PHPSideKickParser.class, (Object)("Unknown superclass " + object));
                } else {
                    PHPSideKickParser.completeClassMembers((ClassHeader)object, pHPSideKickCompletion, string);
                }
            }
            if ((object = classHeader.getInterfaceNames()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    InterfaceIdentifier interfaceIdentifier = (InterfaceIdentifier)iterator.next();
                    InterfaceDeclaration interfaceDeclaration = project.getInterface(interfaceIdentifier.toString());
                    if (interfaceDeclaration == null) {
                        Log.log((int)1, PHPSideKickParser.class, (Object)("Unknown interface " + interfaceDeclaration));
                        continue;
                    }
                    PHPSideKickParser.completeInterfaceMembers(interfaceDeclaration, pHPSideKickCompletion, string);
                }
            }
        }
    }

    private static void completeInterfaceMembers(InterfaceDeclaration interfaceDeclaration, PHPSideKickCompletion pHPSideKickCompletion, String string) {
        List<ConstantIdentifier> list;
        List<MethodHeader> list2 = interfaceDeclaration.getMethodsHeaders();
        pHPSideKickCompletion.addOutlineableList(list2, string);
        Project project = ProjectManager.getInstance().getProject();
        if (project != null && (list = interfaceDeclaration.getSuperInterfaces()) != null) {
            for (ConstantIdentifier constantIdentifier : list) {
                InterfaceDeclaration interfaceDeclaration2 = project.getInterface(constantIdentifier.toString());
                if (interfaceDeclaration2 == null) {
                    Log.log((int)1, PHPSideKickParser.class, (Object)("Unknown interface " + interfaceDeclaration2));
                    continue;
                }
                PHPSideKickParser.completeInterfaceMembers(interfaceDeclaration2, pHPSideKickCompletion, string);
            }
        }
    }
}

