/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentList
extends AstNode {
    private final Expression[] args;

    public ArgumentList(Expression[] expressionArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.args = expressionArray;
    }

    Expression[] getArgs() {
        return this.args;
    }

    @Override
    public String toString(int n) {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.args == null) {
            return "()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(expression.toStringExpression());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        if (this.args != null) {
            for (Expression expression : this.args) {
                expression.getModifiedVariable(list);
            }
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        if (this.args != null) {
            for (Expression expression : this.args) {
                expression.getUsedVariable(list);
            }
        }
    }

    public Expression expressionAt(int n, int n2) {
        if (this.args == null) {
            return null;
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (!expression.isAt(n, n2)) continue;
            return expression;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
    }
}

