/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Statement {
    private final Statement[] statements;

    public Block(Statement[] statementArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.statements = statementArray;
    }

    @Override
    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    @Override
    public String toString(int n) {
        String string = AstNode.tabString(n);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("{\n");
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                stringBuilder.append(statement.toString(n + 1)).append(";\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        for (Statement statement : this.statements) {
            statement.getOutsideVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        for (Statement statement : this.statements) {
            statement.getModifiedVariable(list);
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        for (Statement statement : this.statements) {
            statement.getUsedVariable(list);
        }
    }

    public Statement[] getStatements() {
        return this.statements;
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        for (Statement statement : this.statements) {
            if (!statement.isAt(n, n2)) continue;
            return statement.subNodeAt(n, n2);
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        for (Statement statement : this.statements) {
            statement.analyzeCode(pHPParser);
        }
    }
}

