/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ConstantIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastExpression
extends Expression {
    private final ConstantIdentifier castTarget;
    private final Expression expression;

    public CastExpression(ConstantIdentifier constantIdentifier, Expression expression, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Type.UNKNOWN, n, n2, n3, n4, n5, n6);
        this.castTarget = constantIdentifier;
        this.expression = expression;
        this.initType();
    }

    private void initType() {
        String string = this.castTarget.toStringExpression();
        if ("int".equals(string) || "integer".equals(string)) {
            this.setType(Type.INTEGER);
        } else if ("bool".equals(string) || "boolean".equals(string)) {
            this.setType(Type.BOOLEAN);
        } else if ("float".equals(string) || "double".equals(string) || "real".equals(string)) {
            this.setType(Type.FLOAT);
        } else if ("string".equals(string)) {
            this.setType(Type.STRING);
        } else if ("array".equals(string)) {
            this.setType(Type.ARRAY);
        } else if ("object".equals(string)) {
            this.setType(Type.OBJECT);
        } else if ("unset".equals(string)) {
            this.setType(Type.NULL);
        }
    }

    @Override
    public String toStringExpression() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.castTarget.toStringExpression());
        stringBuilder.append(") ");
        stringBuilder.append(this.expression.toStringExpression());
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.expression.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.expression.getUsedVariable(list);
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        return this.expression.isAt(n, n2) ? this.expression : null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.expression.analyzeCode(pHPParser);
    }
}

