/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParseErrorEvent;
import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.WarningMessageClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.Position;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ClassConstant;
import net.sourceforge.phpdt.internal.compiler.ast.ClassHeader;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.NodeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.Variable;
import net.sourceforge.phpdt.internal.compiler.ast.VariableDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import org.gjt.sp.jedit.GUIUtilities;
import sidekick.IAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends Statement
implements Outlineable,
IAsset {
    private final ClassHeader classHeader;
    private int bodyLineStart;
    private int bodyColumnStart;
    private int bodyLineEnd;
    private int bodyColumnEnd;
    private MethodDeclaration constructor;
    private final Collection<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
    private final transient Outlineable parent;
    private final List<Outlineable> children = new ArrayList<Outlineable>();
    private transient Position start;
    private transient Position end;
    private static Icon icon;

    public ClassDeclaration(Outlineable outlineable, ClassHeader classHeader, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.parent = outlineable;
        this.classHeader = classHeader;
    }

    public void addMethod(MethodDeclaration methodDeclaration) {
        String string = this.classHeader.getName();
        final Type type = new Type(6, string);
        methodDeclaration.visitSubNodes(new NodeVisitor(){

            public void visit(AstNode astNode) {
                Variable variable;
                if (astNode instanceof Variable && "this".equals((variable = (Variable)astNode).getName())) {
                    variable.setType(type);
                }
                if (astNode != null) {
                    astNode.visitSubNodes(this);
                }
            }
        });
        this.classHeader.addMethod(methodDeclaration.getMethodHeader());
        this.methods.add(methodDeclaration);
        this.add(methodDeclaration);
        if (methodDeclaration.getName().equals(this.classHeader.getName())) {
            this.constructor = methodDeclaration;
        }
    }

    public void addField(FieldDeclaration fieldDeclaration) {
        VariableDeclaration variableDeclaration = fieldDeclaration.getVariable();
        this.children.add(variableDeclaration);
        this.classHeader.addField(fieldDeclaration);
    }

    public void addConstant(ClassConstant classConstant) {
        this.children.add(classConstant);
        this.classHeader.addConstant(classConstant);
    }

    @Override
    public boolean add(Outlineable outlineable) {
        return this.children.add(outlineable);
    }

    public boolean hasConstructor() {
        return this.constructor != null;
    }

    @Override
    public String toString(int n) {
        return this.classHeader.toString(n) + this.toStringBody(n);
    }

    @Override
    public String toString() {
        return this.classHeader.toString();
    }

    private String toStringBody(int n) {
        StringBuilder stringBuilder = new StringBuilder(" {");
        List<FieldDeclaration> list = this.classHeader.getFields();
        if (list != null) {
            for (FieldDeclaration statement : list) {
                stringBuilder.append('\n');
                stringBuilder.append(statement.toString(n + 1));
                stringBuilder.append(';');
            }
        }
        for (MethodDeclaration methodDeclaration : this.methods) {
            stringBuilder.append('\n');
            stringBuilder.append(methodDeclaration.toString(n + 1));
        }
        stringBuilder.append('\n').append(ClassDeclaration.tabString(n)).append('}');
        return stringBuilder.toString();
    }

    @Override
    public Outlineable getParent() {
        return this.parent;
    }

    @Override
    public Outlineable get(int n) {
        return this.children.get(n);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    @Override
    public String getName() {
        return this.classHeader.getName();
    }

    @Override
    public int getItemType() {
        return 1;
    }

    public MethodDeclaration insideWichMethodIsThisOffset(int n, int n2) {
        for (MethodDeclaration methodDeclaration : this.methods) {
            if (n == methodDeclaration.getBodyLineStart() && n2 > methodDeclaration.getBodyColumnStart()) {
                return methodDeclaration;
            }
            if (n == methodDeclaration.getBodyLineEnd() && n2 < methodDeclaration.getBodyColumnEnd()) {
                return methodDeclaration;
            }
            if (n <= methodDeclaration.getBodyLineStart() || n >= methodDeclaration.getBodyLineEnd()) continue;
            return methodDeclaration;
        }
        return null;
    }

    public ClassHeader getClassHeader() {
        return this.classHeader;
    }

    public int getBodyLineStart() {
        return this.bodyLineStart;
    }

    public void setBodyLineStart(int n) {
        this.bodyLineStart = n;
    }

    public int getBodyColumnStart() {
        return this.bodyColumnStart;
    }

    public void setBodyColumnStart(int n) {
        this.bodyColumnStart = n;
    }

    public int getBodyLineEnd() {
        return this.bodyLineEnd;
    }

    public void setBodyLineEnd(int n) {
        this.bodyLineEnd = n;
        this.setEndLine(n);
    }

    public int getBodyColumnEnd() {
        return this.bodyColumnEnd;
    }

    public void setBodyColumnEnd(int n) {
        this.bodyColumnEnd = n;
        this.setEndColumn(n);
    }

    public Icon getIcon() {
        if (icon == null) {
            icon = GUIUtilities.loadIcon((String)ClassDeclaration.class.getResource("/gatchan/phpparser/icons/class.png").toString());
        }
        return icon;
    }

    public String getShortString() {
        return this.toString();
    }

    public String getLongString() {
        return this.toString();
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setStart(Position position) {
        this.start = position;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public void setName(String string) {
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.classHeader.isAt(n, n2)) {
            return this.classHeader;
        }
        for (MethodDeclaration object2 : this.methods) {
            if (!object2.isAt(n, n2)) continue;
            return object2;
        }
        List<FieldDeclaration> list = this.classHeader.getFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)iterator.next();
            if (!fieldDeclaration.isAt(n, n2)) continue;
            return fieldDeclaration;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        String string;
        List<FieldDeclaration> list = this.classHeader.getFields();
        HashSet<String> hashSet = new HashSet<String>(this.methods.size());
        HashSet<String> hashSet2 = new HashSet<String>(list.size());
        for (MethodDeclaration statement : this.methods) {
            statement.analyzeCode(pHPParser);
            string = statement.getName();
            ClassDeclaration.checkMethod(hashSet, string, statement.getMethodHeader(), pHPParser, "this method name is already used by another field or method in the class : ");
        }
        for (FieldDeclaration fieldDeclaration : list) {
            string = fieldDeclaration.getName();
            ClassDeclaration.checkField(hashSet, hashSet2, string, fieldDeclaration, pHPParser);
        }
    }

    private static void checkMethod(Collection<String> collection, String string, AstNode astNode, PHPParser pHPParser, String string2) {
        if (!collection.add(string)) {
            pHPParser.fireParseError(new PHPParseErrorEvent(2, pHPParser.getPath(), string2 + string, astNode.getSourceStart(), astNode.getSourceEnd(), astNode.getBeginLine(), astNode.getEndLine(), astNode.getBeginColumn(), astNode.getEndColumn()));
        }
    }

    private static void checkField(Collection<String> collection, Collection<String> collection2, String string, AstNode astNode, PHPParser pHPParser) {
        if (!collection2.add(string)) {
            pHPParser.fireParseError(new PHPParseErrorEvent(2, pHPParser.getPath(), "this field name is already used by another field or method in the class : " + string, astNode.getSourceStart(), astNode.getSourceEnd(), astNode.getBeginLine(), astNode.getEndLine(), astNode.getBeginColumn(), astNode.getEndColumn()));
        } else if (collection.contains(string)) {
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.methodFieldNameCollision, pHPParser.getPath(), "a method is defined with the same name " + string, astNode.getSourceStart(), astNode.getSourceEnd(), astNode.getBeginLine(), astNode.getEndLine(), astNode.getBeginColumn(), astNode.getEndColumn()));
        }
    }

    @Override
    public void visitSubNodes(NodeVisitor nodeVisitor) {
        for (MethodDeclaration methodDeclaration : this.methods) {
            nodeVisitor.visit(methodDeclaration);
            methodDeclaration.visitSubNodes(nodeVisitor);
        }
    }
}

