/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.project.itemfinder.PHPItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ClassConstant;
import net.sourceforge.phpdt.internal.compiler.ast.ClassIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.InterfaceIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.MethodHeader;
import net.sourceforge.phpdt.internal.compiler.ast.Modifier;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import org.gjt.sp.jedit.GUIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHeader
extends AstNode
implements PHPItem,
Serializable {
    private final String path;
    private final String namespace;
    private final ClassIdentifier className;
    private String nameLowerCase;
    private final ClassIdentifier superClassName;
    private final List<InterfaceIdentifier> interfaceNames;
    private final List<MethodHeader> methodsHeaders = new ArrayList<MethodHeader>();
    private final List<ClassConstant> constants = new ArrayList<ClassConstant>();
    private final List<Modifier> modifiers = new ArrayList<Modifier>(3);
    private final List<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
    private static transient Icon icon;
    private transient String cachedToString;
    private static final long serialVersionUID = 8213003151739601011L;

    public ClassHeader(String string, String string2, ClassIdentifier classIdentifier, ClassIdentifier classIdentifier2, List<InterfaceIdentifier> list, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.namespace = string;
        this.path = string2;
        this.className = classIdentifier;
        this.superClassName = classIdentifier2;
        this.interfaceNames = list;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(ClassHeader.tabString(n));
        stringBuilder.append("class ");
        stringBuilder.append(this.className);
        if (this.superClassName != null) {
            stringBuilder.append(" extends ");
            stringBuilder.append(this.superClassName);
        }
        if (this.interfaceNames != null) {
            stringBuilder.append(" implements ");
            for (int i = 0; i < this.interfaceNames.size(); ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.interfaceNames.get(i));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.className);
            if (this.superClassName != null) {
                stringBuilder.append(':');
                stringBuilder.append(this.superClassName);
            }
            this.cachedToString = stringBuilder.toString();
        }
        return this.cachedToString;
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    public void addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public String getName() {
        if (this.className == null) {
            return "syntax error";
        }
        return this.className.toString();
    }

    @Override
    public String getNameLowerCase() {
        if (this.nameLowerCase == null) {
            this.nameLowerCase = this.getName().toLowerCase();
        }
        return this.nameLowerCase;
    }

    public String getSuperClassName() {
        if (this.superClassName == null) {
            return "syntax error";
        }
        return this.superClassName.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassHeader)) {
            return false;
        }
        return ((ClassHeader)object).getName().equals(this.className);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Icon getIcon() {
        if (icon == null) {
            icon = GUIUtilities.loadIcon((String)ClassHeader.class.getResource("/gatchan/phpparser/icons/class.png").toString());
        }
        return icon;
    }

    public void addMethod(MethodHeader methodHeader) {
        this.methodsHeaders.add(methodHeader);
    }

    public void addField(FieldDeclaration fieldDeclaration) {
        this.fields.add(fieldDeclaration);
    }

    public void addConstant(ClassConstant classConstant) {
        this.constants.add(classConstant);
    }

    public List<MethodHeader> getMethodsHeaders() {
        return this.methodsHeaders;
    }

    public List<FieldDeclaration> getFields() {
        return this.fields;
    }

    @Override
    public int getItemType() {
        return 1;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
    }

    public List<InterfaceIdentifier> getInterfaceNames() {
        return this.interfaceNames;
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.className != null && this.className.isAt(n + 1, n2)) {
            return this.className;
        }
        if (this.superClassName != null && this.superClassName.isAt(n + 1, n2)) {
            return this.superClassName;
        }
        if (this.interfaceNames != null) {
            for (InterfaceIdentifier interfaceIdentifier : this.interfaceNames) {
                if (!interfaceIdentifier.isAt(n, n2)) continue;
                return interfaceIdentifier;
            }
        }
        return null;
    }
}

