/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.WarningMessageClass;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorExpression;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalExpression
extends OperatorExpression {
    private final Expression condition;
    private final Expression valueIfTrue;
    private final Expression valueIfFalse;

    public ConditionalExpression(Expression expression, Expression expression2, Expression expression3) {
        super(expression3.getType(), -1, expression.getSourceStart(), expression3.getSourceEnd(), expression.getBeginLine(), expression3.getEndLine(), expression.getBeginColumn(), expression3.getEndColumn());
        this.condition = expression;
        this.valueIfTrue = expression2 == null ? expression : expression2;
        this.valueIfFalse = expression3;
        if (expression instanceof Assignment) {
            Assignment assignment = (Assignment)expression;
            assignment.setType(this.getType());
            assignment.getTarget().setType(this.getType());
        }
    }

    @Override
    public String toStringExpression() {
        String string = this.condition.toStringExpression();
        String string2 = this.valueIfTrue.toStringExpression();
        String string3 = this.valueIfFalse.toStringExpression();
        StringBuilder stringBuilder = new StringBuilder(8 + string.length() + string2.length() + string3.length());
        stringBuilder.append('(');
        stringBuilder.append(string);
        stringBuilder.append(") ? ");
        stringBuilder.append(string2);
        stringBuilder.append(" : ");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.condition.getModifiedVariable(list);
        this.valueIfTrue.getModifiedVariable(list);
        this.valueIfFalse.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.condition.getUsedVariable(list);
        this.valueIfTrue.getUsedVariable(list);
        this.valueIfFalse.getUsedVariable(list);
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.condition.isAt(n, n2)) {
            return this.condition;
        }
        if (this.valueIfTrue.isAt(n, n2)) {
            return this.valueIfTrue;
        }
        if (this.valueIfFalse.isAt(n, n2)) {
            return this.valueIfFalse;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        Type type;
        if (this.valueIfFalse.equals(this.valueIfTrue)) {
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.conditionalExpressionCheck, pHPParser.getPath(), "Conditional expression : silly expression, the result is always the same", this.sourceStart, this.sourceEnd, this.beginLine, this.endLine, this.beginColumn, this.endColumn));
            return;
        }
        Type type2 = this.valueIfFalse.getType();
        if (!(type2.isCompatibleWith(type = this.valueIfTrue.getType()) || Type.NUMBER.isCompatibleWith(type2) || Type.NUMBER.isCompatibleWith(type))) {
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.conditionalExpressionCheck, pHPParser.getPath(), "Conditional expression : warning, the true value is type " + type + " and the false value is " + type2, this.sourceStart, this.sourceEnd, this.beginLine, this.endLine, this.beginColumn, this.endColumn));
        }
    }
}

