/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoStatement
extends Statement {
    private final Expression condition;
    private final Statement action;

    public DoStatement(Expression expression, Statement statement, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.condition = expression;
        this.action = statement;
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer;
        String string = this.condition.toStringExpression();
        if (this.action == null) {
            stringBuffer = new StringBuffer(17 + n + string.length());
            stringBuffer.append("do ");
            stringBuffer.append(" {} ;");
        } else {
            String string2 = this.action.toString(n + 1);
            stringBuffer = new StringBuffer(13 + string.length() + string2.length());
            stringBuffer.append("do ");
            stringBuffer.append('\n');
            stringBuffer.append(string2);
        }
        stringBuffer.append(DoStatement.tabString(n));
        stringBuffer.append(" while (");
        stringBuffer.append(string);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        this.condition.getOutsideVariable(list);
        this.action.getOutsideVariable(list);
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.condition.getModifiedVariable(list);
        this.action.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.condition.getUsedVariable(list);
        this.action.getUsedVariable(list);
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.condition.isAt(n, n2)) {
            return this.condition;
        }
        if (this.action.isAt(n, n2)) {
            return this.action.subNodeAt(n, n2);
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.condition.analyzeCode(pHPParser);
        this.action.analyzeCode(pHPParser);
    }
}

