/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElseIf
extends Statement {
    private final Expression condition;
    private final Statement[] statements;

    public ElseIf(Expression expression, Statement[] statementArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.condition = expression;
        this.statements = statementArray;
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(ElseIf.tabString(n));
        stringBuilder.append("elseif (");
        stringBuilder.append(this.condition.toStringExpression());
        stringBuilder.append(") \n");
        for (int i = 0; i < this.statements.length; ++i) {
            Statement statement = this.statements[i];
            stringBuilder.append(statement.toString(n + 1)).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].getModifiedVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].getModifiedVariable(list);
        }
        this.condition.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].getUsedVariable(list);
        }
        this.condition.getUsedVariable(list);
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.condition.isAt(n, n2)) {
            return this.condition;
        }
        for (int i = 0; i < this.statements.length; ++i) {
            Statement statement = this.statements[i];
            if (!statement.isAt(n, n2)) continue;
            return null;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.condition.analyzeCode(pHPParser);
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].analyzeCode(pHPParser);
        }
    }
}

