/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends Statement {
    private final Expression[] initializations;
    private final Expression condition;
    private final Expression[] increments;
    private final Statement action;

    public ForStatement(Expression[] expressionArray, Expression expression, Expression[] expressionArray2, Statement statement, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.initializations = expressionArray;
        this.condition = expression;
        this.increments = expressionArray2;
        this.action = statement;
    }

    @Override
    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(ForStatement.tabString(n));
        stringBuilder.append("for (");
        if (this.initializations != null) {
            for (n2 = 0; n2 < this.initializations.length; ++n2) {
                stringBuilder.append(this.initializations[n2].toStringExpression());
                if (n2 == this.initializations.length - 1) continue;
                stringBuilder.append(" , ");
            }
        }
        stringBuilder.append("; ");
        if (this.condition != null) {
            stringBuilder.append(this.condition.toStringExpression());
        }
        stringBuilder.append("; ");
        if (this.increments != null) {
            for (n2 = 0; n2 < this.increments.length; ++n2) {
                stringBuilder.append(this.increments[n2].toStringExpression());
                if (n2 == this.increments.length - 1) continue;
                stringBuilder.append(" , ");
            }
        }
        stringBuilder.append(") ");
        if (this.action == null) {
            stringBuilder.append("{}");
        } else {
            stringBuilder.append(this.action.toString(n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        int n;
        if (this.condition != null) {
            this.condition.getOutsideVariable(list);
        }
        if (this.action != null) {
            this.action.getOutsideVariable(list);
        }
        if (this.initializations != null) {
            for (n = 0; n < this.initializations.length; ++n) {
                this.initializations[n].getOutsideVariable(list);
            }
        }
        if (this.increments != null) {
            for (n = 0; n < this.increments.length; ++n) {
                this.increments[n].getOutsideVariable(list);
            }
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        int n;
        if (this.condition != null) {
            this.condition.getModifiedVariable(list);
        }
        if (this.action != null) {
            this.action.getModifiedVariable(list);
        }
        if (this.initializations != null) {
            for (n = 0; n < this.initializations.length; ++n) {
                this.initializations[n].getModifiedVariable(list);
            }
        }
        if (this.increments != null) {
            for (n = 0; n < this.increments.length; ++n) {
                this.increments[n].getModifiedVariable(list);
            }
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        int n;
        if (this.condition != null) {
            this.condition.getUsedVariable(list);
        }
        if (this.action != null) {
            this.action.getUsedVariable(list);
        }
        if (this.initializations != null) {
            for (n = 0; n < this.initializations.length; ++n) {
                this.initializations[n].getUsedVariable(list);
            }
        }
        if (this.increments != null) {
            for (n = 0; n < this.increments.length; ++n) {
                this.increments[n].getUsedVariable(list);
            }
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        Expression expression;
        int n3;
        if (this.condition != null && this.condition.isAt(n, n2)) {
            return this.condition;
        }
        if (this.action != null && this.action.isAt(n, n2)) {
            return this.action.subNodeAt(n, n2);
        }
        if (this.initializations != null) {
            for (n3 = 0; n3 < this.initializations.length; ++n3) {
                expression = this.initializations[n3];
                if (!expression.isAt(n, n2)) continue;
                return expression;
            }
        }
        if (this.increments != null) {
            for (n3 = 0; n3 < this.increments.length; ++n3) {
                expression = this.increments[n3];
                if (!expression.isAt(n, n2)) continue;
                return expression;
            }
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        int n;
        if (this.initializations != null) {
            for (n = 0; n < this.initializations.length; ++n) {
                this.initializations[n].analyzeCode(pHPParser);
            }
        }
        if (this.condition != null) {
            this.condition.analyzeCode(pHPParser);
        }
        if (this.increments != null) {
            for (n = 0; n < this.increments.length; ++n) {
                this.increments[n].analyzeCode(pHPParser);
            }
        }
        this.action.analyzeCode(pHPParser);
    }
}

