/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeachStatement
extends Statement {
    private final Expression expression;
    private final Expression variable;
    private final Statement statement;

    public ForeachStatement(Expression expression, Expression expression2, Statement statement, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.expression = expression;
        this.variable = expression2;
        this.statement = statement;
    }

    @Override
    public String toString(int n) {
        String string = this.expression == null ? "__EXPRESSION__" : this.expression.toStringExpression();
        String string2 = this.variable == null ? "__VARIABLE__" : this.variable.toStringExpression();
        String string3 = this.statement == null ? "__STATEMENT__" : this.statement.toString(n + 1);
        StringBuilder stringBuilder = new StringBuilder(n + string.length() + string2.length() + string3.length() + 18);
        stringBuilder.append(AstNode.tabString(n));
        stringBuilder.append("foreach (");
        stringBuilder.append(string);
        stringBuilder.append(" as ");
        stringBuilder.append(string2);
        stringBuilder.append(" {\n");
        stringBuilder.append(string3);
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        if (this.expression != null) {
            this.expression.getOutsideVariable(list);
        }
        if (this.variable != null) {
            this.variable.getOutsideVariable(list);
        }
        if (this.statement != null) {
            this.statement.getOutsideVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        if (this.expression != null) {
            this.expression.getModifiedVariable(list);
        }
        if (this.variable != null) {
            this.variable.getUsedVariable(list);
        }
        if (this.statement != null) {
            this.statement.getModifiedVariable(list);
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        if (this.expression != null) {
            this.expression.getUsedVariable(list);
        }
        if (this.statement != null) {
            this.statement.getUsedVariable(list);
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.expression != null && this.expression.isAt(n, n2)) {
            return this.expression;
        }
        if (this.variable != null && this.variable.isAt(n, n2)) {
            return this.variable;
        }
        if (this.statement != null && this.statement.isAt(n, n2)) {
            return this.statement.subNodeAt(n, n2);
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        if (this.expression != null) {
            this.expression.analyzeCode(pHPParser);
        }
        if (this.variable != null) {
            this.variable.analyzeCode(pHPParser);
        }
        if (this.statement != null) {
            this.statement.analyzeCode(pHPParser);
        }
    }
}

