/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.PHPParserPlugin;
import gatchan.phpparser.methodlist.Argument;
import gatchan.phpparser.methodlist.Function;
import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.WarningMessageClass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractSuffixExpression;
import net.sourceforge.phpdt.internal.compiler.ast.ArgumentList;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ConstantIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
extends AbstractSuffixExpression {
    private final Expression clazz;
    private final boolean staticClassAccess;
    private final Expression functionName;
    private final ArgumentList args;
    private transient Function definition;

    public FunctionCall(Expression expression, boolean bl, Expression expression2, ArgumentList argumentList) {
        super(Type.UNKNOWN, expression2.getSourceStart(), argumentList.getSourceEnd(), expression2.getBeginLine(), argumentList.getEndLine(), expression2.getBeginColumn(), argumentList.getEndColumn());
        this.clazz = expression;
        this.staticClassAccess = bl;
        this.functionName = expression2;
        this.args = argumentList;
        this.initFunctionDefinition();
    }

    public FunctionCall(Expression expression, ArgumentList argumentList) {
        this(null, false, expression, argumentList);
    }

    public Expression getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toStringExpression() {
        StringBuilder stringBuilder = new StringBuilder(this.functionName.toStringExpression());
        stringBuilder.append(this.args.toString());
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        if (this.definition == null) {
            this.args.getModifiedVariable(list);
        } else {
            Expression[] expressionArray = this.args.getArgs();
            if (expressionArray == null) {
                return;
            }
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression = expressionArray[i];
                Argument argument = this.definition.getArgument(i);
                if (argument != null && argument.isReference()) {
                    expression.getUsedVariable(list);
                    continue;
                }
                expression.getModifiedVariable(list);
            }
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.functionName.getUsedVariable(list);
        if (this.definition == null) {
            this.args.getUsedVariable(list);
        } else {
            Expression[] expressionArray = this.args.getArgs();
            if (expressionArray == null) {
                return;
            }
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression = expressionArray[i];
                Argument argument = this.definition.getArgument(i);
                if (argument != null && argument.isReference()) continue;
                expression.getUsedVariable(list);
            }
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.functionName.isAt(n, n2)) {
            return this.functionName;
        }
        return this.args.expressionAt(n, n2);
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        Serializable serializable;
        int n;
        if (this.definition == null) {
            return;
        }
        Expression[] expressionArray = this.args.getArgs();
        if (expressionArray != null) {
            for (n = 0; n < expressionArray.length; ++n) {
                serializable = expressionArray[n];
                Argument argument = this.definition.getArgument(n);
                if (argument == null) {
                    if (this.definition.isVarargs()) break;
                    pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.tooManyArguments, pHPParser.getPath(), "Too many arguments", ((AstNode)serializable).getSourceStart(), ((AstNode)serializable).getSourceEnd(), ((AstNode)serializable).getBeginLine(), ((AstNode)serializable).getEndLine(), ((AstNode)serializable).getBeginColumn(), ((AstNode)serializable).getEndColumn()));
                    break;
                }
                if (argument.getType().isCompatibleWith(((Expression)serializable).getType())) continue;
                if (argument.getType() == Type.VOID) {
                    pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.tooManyArguments, pHPParser.getPath(), "Too many arguments", ((AstNode)serializable).getSourceStart(), ((AstNode)serializable).getSourceEnd(), ((AstNode)serializable).getBeginLine(), ((AstNode)serializable).getEndLine(), ((AstNode)serializable).getBeginColumn(), ((AstNode)serializable).getEndColumn()));
                    break;
                }
                pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.wrongArgumentType, pHPParser.getPath(), "wrong argument type, " + ((Expression)serializable).getType() + " cannot match " + argument.toString(), ((AstNode)serializable).getSourceStart(), ((AstNode)serializable).getSourceEnd(), ((AstNode)serializable).getBeginLine(), ((AstNode)serializable).getEndLine(), ((AstNode)serializable).getBeginColumn(), ((AstNode)serializable).getEndColumn()));
            }
        }
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (n < this.definition.getMinArgumentCount()) {
            serializable = new StringBuilder();
            for (int i = n; i < this.definition.getArgumentCount(); ++i) {
                if (i != n) {
                    ((StringBuilder)serializable).append(", ");
                }
                ((StringBuilder)serializable).append(this.definition.getArgument(i));
            }
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.tooFewArguments, pHPParser.getPath(), "Too few arguments, expecting " + ((StringBuilder)serializable).toString(), this.args.getSourceStart(), this.args.getSourceEnd(), this.args.getBeginLine(), this.args.getEndLine(), this.args.getBeginColumn(), this.args.getEndColumn()));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initFunctionDefinition();
    }

    private void initFunctionDefinition() {
        if (this.clazz == null && this.functionName instanceof ConstantIdentifier) {
            this.definition = PHPParserPlugin.phpFunctionList.getFunction(this.getFunctionName().toString());
            Expression[] expressionArray = this.args.getArgs();
            if (expressionArray == null) {
                for (Function function = this.definition; function != null; function = function.getAlternative()) {
                    if (function.getMinArgumentCount() != 0) continue;
                    this.definition = function;
                    break;
                }
            } else {
                for (Function function = this.definition; function != null; function = function.getAlternative()) {
                    if (function.getMinArgumentCount() != expressionArray.length) continue;
                    this.definition = function;
                    break;
                }
            }
            if (this.definition != null) {
                this.setType(this.definition.getReturnType());
            }
        }
    }
}

