/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.WarningMessageClass;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.Position;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractVariable;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.Variable;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import sidekick.IAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalStatement
extends Statement
implements Outlineable,
IAsset {
    private final AbstractVariable[] variables;
    private final transient Outlineable parent;
    private transient Position start;
    private transient Position end;
    private String cachedToString;

    public GlobalStatement(Outlineable outlineable, AbstractVariable[] abstractVariableArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.variables = abstractVariableArray;
        this.parent = outlineable;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder stringBuilder = new StringBuilder("global ");
            for (int i = 0; i < this.variables.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.variables[i].toStringExpression());
            }
            this.cachedToString = stringBuilder.toString();
        }
        return this.cachedToString;
    }

    @Override
    public String toString(int n) {
        return GlobalStatement.tabString(n) + this.toString();
    }

    @Override
    public Outlineable getParent() {
        return this.parent;
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        for (AbstractVariable abstractVariable : this.variables) {
            abstractVariable.getUsedVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        for (AbstractVariable abstractVariable : this.variables) {
            if (!GlobalStatement.arrayContains(Variable.SPECIAL_VARS, abstractVariable.getName())) continue;
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.unnecessaryGlobal, pHPParser.getPath(), "warning, you shouldn't request " + abstractVariable.getName() + " as global", abstractVariable.sourceStart, abstractVariable.sourceEnd, abstractVariable.getBeginLine(), abstractVariable.getEndLine(), abstractVariable.getBeginColumn(), abstractVariable.getEndColumn()));
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getItemType() {
        return 64;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public Position getStart() {
        return this.start;
    }

    public void setStart(Position position) {
        this.start = position;
    }

    public Icon getIcon() {
        return null;
    }

    public String getShortString() {
        return this.toString();
    }

    public String getLongString() {
        return this.toString();
    }

    public void setName(String string) {
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        for (AbstractVariable abstractVariable : this.variables) {
            if (!abstractVariable.isAt(n, n2)) continue;
            return abstractVariable;
        }
        return null;
    }

    @Override
    public boolean add(Outlineable outlineable) {
        return false;
    }

    @Override
    public Outlineable get(int n) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }
}

