/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.Token;
import gatchan.phpparser.parser.WarningMessageClass;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ConstantIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GotoStatement
extends Statement {
    private final ConstantIdentifier label;

    public GotoStatement(Token token, ConstantIdentifier constantIdentifier, int n, int n2, int n3) {
        super(token.sourceStart, n, token.beginLine, n2, token.beginColumn, n3);
        this.label = constantIdentifier;
    }

    public ConstantIdentifier getName() {
        return this.label;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("goto ");
        stringBuilder.append(this.label).append(';');
        return stringBuilder.toString();
    }

    @Override
    public String toString(int n) {
        String string = GotoStatement.tabString(n);
        String string2 = this.toString();
        return string + string2;
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.label != null && this.label.isAt(n, n2)) {
            return this.label;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.gotostatement, pHPParser.getPath(), "use of a goto statement", this.getSourceStart(), this.label.getSourceEnd(), this.getBeginLine(), this.label.getEndLine(), this.getBeginColumn(), this.label.getEndColumn()));
    }
}

