/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Else;
import net.sourceforge.phpdt.internal.compiler.ast.ElseIf;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfStatement
extends Statement {
    private final Expression condition;
    private final Statement statement;
    private final ElseIf[] elseifs;
    private final Else els;

    public IfStatement(Expression expression, Statement statement, ElseIf[] elseIfArray, Else else_, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.condition = expression;
        this.statement = statement;
        this.elseifs = elseIfArray;
        this.els = else_;
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(IfStatement.tabString(n));
        stringBuilder.append("if (");
        stringBuilder.append(this.condition.toStringExpression()).append(") ");
        if (this.statement != null) {
            stringBuilder.append(this.statement.toString(n + 1));
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            stringBuilder.append(this.elseifs[i].toString(n + 1));
            stringBuilder.append('\n');
        }
        if (this.els != null) {
            stringBuilder.append(this.els.toString(n + 1));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        this.condition.getOutsideVariable(list);
        if (this.statement != null) {
            this.statement.getOutsideVariable(list);
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            this.elseifs[i].getOutsideVariable(list);
        }
        if (this.els != null) {
            this.els.getOutsideVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.condition.getModifiedVariable(list);
        if (this.statement != null) {
            this.statement.getModifiedVariable(list);
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            this.elseifs[i].getModifiedVariable(list);
        }
        if (this.els != null) {
            this.els.getModifiedVariable(list);
        }
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.condition.analyzeCode(pHPParser);
        if (this.statement != null) {
            this.statement.analyzeCode(pHPParser);
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            this.elseifs[i].analyzeCode(pHPParser);
        }
        if (this.els != null) {
            this.els.analyzeCode(pHPParser);
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.condition.getUsedVariable(list);
        if (this.statement != null) {
            this.statement.getUsedVariable(list);
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            this.elseifs[i].getUsedVariable(list);
        }
        if (this.els != null) {
            this.els.getUsedVariable(list);
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.condition.isAt(n, n2)) {
            return this.condition;
        }
        if (this.statement != null && this.statement.isAt(n, n2)) {
            return this.statement.subNodeAt(n, n2);
        }
        for (int i = 0; i < this.elseifs.length; ++i) {
            ElseIf elseIf = this.elseifs[i];
            if (!elseIf.isAt(n, n2)) continue;
            return elseIf.subNodeAt(n, n2);
        }
        if (this.els != null && this.els.isAt(n, n2)) {
            return this.els.subNodeAt(n, n2);
        }
        return null;
    }
}

