/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.PHPParserConstants;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import sidekick.IAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusionExpression
extends Expression
implements Outlineable,
IAsset {
    private boolean silent;
    private final int keyword;
    private final Expression expression;
    private final transient Outlineable parent;
    private transient Position start;
    private transient Position end;
    private static transient Icon icon;
    private String cachedToString;

    public InclusionExpression(Outlineable outlineable, int n, Expression expression, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(Type.INTEGER, n2, n3, n4, n5, n6, n7);
        this.keyword = n;
        this.expression = expression;
        this.parent = outlineable;
    }

    private String keywordToString() {
        return PHPParserConstants.tokenImage[this.keyword];
    }

    @Override
    public String toStringExpression() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            String string = this.keywordToString();
            string = string.substring(1, string.length() - 1);
            String string2 = this.expression.toStringExpression();
            StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 2);
            if (this.silent) {
                stringBuilder.append('@');
            }
            stringBuilder.append(string);
            stringBuilder.append(' ');
            stringBuilder.append(string2);
            this.cachedToString = stringBuilder.toString();
        }
        return this.cachedToString;
    }

    @Override
    public Outlineable getParent() {
        return this.parent;
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        this.expression.getOutsideVariable(list);
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.expression.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.expression.getUsedVariable(list);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getItemType() {
        return 128;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public Position getStart() {
        return this.start;
    }

    public void setStart(Position position) {
        this.start = position;
    }

    public Icon getIcon() {
        if (icon == null) {
            icon = new ImageIcon(InclusionExpression.class.getResource("/gatchan/phpparser/icons/require.png"));
        }
        return icon;
    }

    public String getShortString() {
        return this.toString();
    }

    public String getLongString() {
        return this.toString();
    }

    public void setName(String string) {
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        return this.expression.isAt(n, n2) ? this.expression : null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.expression.analyzeCode(pHPParser);
    }

    @Override
    public boolean add(Outlineable outlineable) {
        return false;
    }

    @Override
    public Outlineable get(int n) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }
}

