/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParseErrorEvent;
import gatchan.phpparser.parser.PHPParseMessageEvent;
import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.WarningMessageClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.ConstantIdentifier;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.GotoStatement;
import net.sourceforge.phpdt.internal.compiler.ast.LabeledStatement;
import net.sourceforge.phpdt.internal.compiler.ast.MethodHeader;
import net.sourceforge.phpdt.internal.compiler.ast.NodeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import sidekick.IAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDeclaration
extends Expression
implements Outlineable,
IAsset {
    private final MethodHeader methodHeader;
    private Statement[] statements;
    private int bodyLineStart;
    private int bodyColumnStart;
    private int bodyLineEnd;
    private int bodyColumnEnd;
    private boolean isConstructor;
    private transient Outlineable parent;
    private final List<Outlineable> children = new ArrayList<Outlineable>();
    private transient Position start;
    private transient Position end;
    private static Icon icon;
    private transient List<VariableUsage> assignedVariablesInCode;
    private static final long serialVersionUID = 8471570829959168564L;

    public MethodDeclaration(Outlineable outlineable, MethodHeader methodHeader) {
        this.sourceStart = methodHeader.getSourceStart();
        this.beginLine = methodHeader.getBeginLine();
        this.beginColumn = methodHeader.getBeginColumn();
        this.endLine = methodHeader.getEndLine();
        this.endColumn = methodHeader.getEndColumn();
        this.parent = outlineable;
        this.methodHeader = methodHeader;
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.methodHeader.toString(n));
        stringBuilder.append(this.toStringStatements(n + 1));
        return stringBuilder.toString();
    }

    @Override
    public String toStringExpression() {
        return this.toString(0);
    }

    @Override
    public String toString() {
        return this.methodHeader.toString();
    }

    private String toStringStatements(int n) {
        StringBuilder stringBuilder = new StringBuilder(" {");
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                stringBuilder.append('\n').append(statement.toString(n));
                if (statement instanceof Block) continue;
                stringBuilder.append(';');
            }
        }
        stringBuilder.append('\n').append(MethodDeclaration.tabString(n == 0 ? 0 : n - 1)).append('}');
        return stringBuilder.toString();
    }

    public void setParent(Outlineable outlineable) {
        this.parent = outlineable;
    }

    @Override
    public Outlineable getParent() {
        return this.parent;
    }

    @Override
    public boolean add(Outlineable outlineable) {
        return this.children.add(outlineable);
    }

    @Override
    public Outlineable get(int n) {
        return this.children.get(n);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    private void getGlobalVariable(List<VariableUsage> list) {
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                statement.getOutsideVariable(list);
            }
        }
    }

    private List<VariableUsage> getAssignedVariableInCode() {
        if (this.assignedVariablesInCode == null) {
            this.assignedVariablesInCode = new ArrayList<VariableUsage>(50);
            if (this.statements != null) {
                for (Statement statement : this.statements) {
                    statement.getModifiedVariable(this.assignedVariablesInCode);
                }
            }
        }
        return this.assignedVariablesInCode;
    }

    private void getUsedVariableInCode(List<VariableUsage> list) {
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                statement.getUsedVariable(list);
            }
        }
    }

    public VariableUsage getAssignedVariableInCode(String string, int n, int n2) {
        List<VariableUsage> list = this.getAssignedVariableInCode();
        VariableUsage variableUsage = null;
        for (VariableUsage variableUsage2 : list) {
            if (variableUsage2.getEndLine() > n || variableUsage2.getEndLine() == n && variableUsage2.getBeginColumn() > n2) break;
            if (!variableUsage2.getName().equals(string) || variableUsage != null && !variableUsage.isDeclaredBefore(variableUsage2)) continue;
            variableUsage = variableUsage2;
        }
        return variableUsage;
    }

    private static boolean isVariableDeclaredBefore(Iterable<VariableUsage> iterable, VariableUsage variableUsage) {
        String string = variableUsage.getName();
        int n = variableUsage.getSourceStart();
        for (VariableUsage variableUsage2 : iterable) {
            if (!variableUsage2.getName().equals(string) || variableUsage2.getSourceStart() >= n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        Serializable serializable;
        Serializable serializable2;
        this.methodHeader.analyzeCode(pHPParser);
        if (this.statements == null) {
            return;
        }
        HashMap<String, ConstantIdentifier> hashMap = new HashMap<String, ConstantIdentifier>();
        HashMap<String, ConstantIdentifier> hashMap2 = new HashMap<String, ConstantIdentifier>();
        for (Statement serializable32 : this.statements) {
            if (serializable32 instanceof LabeledStatement) {
                serializable2 = (LabeledStatement)serializable32;
                serializable = ((LabeledStatement)serializable2).getName();
                hashMap.put(((ConstantIdentifier)serializable).toString(), (ConstantIdentifier)serializable);
            } else if (serializable32 instanceof GotoStatement) {
                serializable2 = (GotoStatement)serializable32;
                serializable = ((GotoStatement)serializable2).getName();
                hashMap2.put(((ConstantIdentifier)serializable).toString(), (ConstantIdentifier)serializable);
            }
            serializable32.analyzeCode(pHPParser);
        }
        for (String string : hashMap.keySet()) {
            hashMap2.remove(string);
        }
        for (ConstantIdentifier constantIdentifier : hashMap2.values()) {
            pHPParser.fireParseError(new PHPParseErrorEvent(2, pHPParser.getPath(), "unknown label used " + constantIdentifier.toString(), constantIdentifier.getSourceStart(), constantIdentifier.getSourceEnd(), constantIdentifier.getBeginLine(), constantIdentifier.getEndLine(), constantIdentifier.getBeginColumn(), constantIdentifier.getEndColumn()));
        }
        for (ConstantIdentifier constantIdentifier : hashMap.values()) {
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.unusedLabel, pHPParser.getPath(), "unused label", constantIdentifier.getSourceStart(), constantIdentifier.getSourceEnd(), constantIdentifier.getBeginLine(), constantIdentifier.getEndLine(), constantIdentifier.getBeginColumn(), constantIdentifier.getEndColumn()));
        }
        ArrayList arrayList = new ArrayList();
        this.getGlobalVariable(arrayList);
        List<VariableUsage> list = this.getAssignedVariableInCode();
        ArrayList<VariableUsage> arrayList2 = new ArrayList<VariableUsage>(this.methodHeader.getArgumentsCount());
        this.methodHeader.getParameters(arrayList2);
        ArrayList<VariableUsage> arrayList3 = new ArrayList<VariableUsage>(arrayList.size() + list.size() + arrayList2.size());
        arrayList3.addAll(arrayList);
        arrayList3.addAll(list);
        arrayList3.addAll(arrayList2);
        serializable2 = new ArrayList();
        this.getUsedVariableInCode((List<VariableUsage>)((Object)serializable2));
        serializable = new ArrayList(list.size() + serializable2.size());
        serializable.addAll(list);
        serializable.addAll(serializable2);
        MethodDeclaration.findUnusedParameters(pHPParser, (Iterable<VariableUsage>)((Object)serializable), arrayList2);
        MethodDeclaration.findUnknownUsedVars(pHPParser, (Collection<VariableUsage>)((Object)serializable2), arrayList3);
    }

    private static void findUnusedParameters(PHPParser pHPParser, Iterable<VariableUsage> iterable, Iterable<VariableUsage> iterable2) {
        for (VariableUsage variableUsage : iterable2) {
            if (MethodDeclaration.isVariableInList(variableUsage.getName(), iterable)) continue;
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.unusedParameters, pHPParser.getPath(), "warning, the parameter " + variableUsage.getName() + " seems to be never used in your method", variableUsage.getSourceStart(), variableUsage.getSourceEnd(), variableUsage.getBeginLine(), variableUsage.getEndLine(), variableUsage.getBeginColumn(), variableUsage.getEndColumn()));
        }
    }

    private static boolean isVariableInList(String string, Iterable<VariableUsage> iterable) {
        for (VariableUsage variableUsage : iterable) {
            if (!variableUsage.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void findUnknownUsedVars(PHPParser pHPParser, Collection<VariableUsage> collection, Iterable<VariableUsage> iterable) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (VariableUsage variableUsage : collection) {
            if ("this".equals(variableUsage.getName()) || hashSet.contains(variableUsage.getName()) || MethodDeclaration.isVariableDeclaredBefore(iterable, variableUsage)) continue;
            hashSet.add(variableUsage.getName());
            pHPParser.fireParseMessage(new PHPParseMessageEvent(1, WarningMessageClass.unassignedVariable, pHPParser.getPath(), "warning, usage of a variable that seems to be unassigned yet : " + variableUsage.getName(), variableUsage.getSourceStart(), variableUsage.getSourceEnd(), variableUsage.getBeginLine(), variableUsage.getEndLine(), variableUsage.getBeginColumn(), variableUsage.getEndColumn()));
        }
    }

    @Override
    public String getName() {
        return this.methodHeader.getName();
    }

    public MethodHeader getMethodHeader() {
        return this.methodHeader;
    }

    public void setStatements(Statement[] statementArray) {
        this.statements = statementArray;
    }

    public int getBodyLineStart() {
        return this.bodyLineStart;
    }

    public void setBodyLineStart(int n) {
        this.bodyLineStart = n;
    }

    public int getBodyColumnStart() {
        return this.bodyColumnStart;
    }

    public void setBodyColumnStart(int n) {
        this.bodyColumnStart = n;
    }

    public int getBodyLineEnd() {
        return this.bodyLineEnd;
    }

    public void setBodyLineEnd(int n) {
        this.bodyLineEnd = n;
        this.setEndLine(n);
    }

    public int getBodyColumnEnd() {
        return this.bodyColumnEnd;
    }

    public void setBodyColumnEnd(int n) {
        this.bodyColumnEnd = n;
        this.setEndColumn(n);
    }

    @Override
    public int getItemType() {
        return 2;
    }

    public Icon getIcon() {
        if (icon == null) {
            icon = new ImageIcon(MethodDeclaration.class.getResource("/gatchan/phpparser/icons/method.png"));
        }
        return icon;
    }

    public Position getStart() {
        return this.start;
    }

    public void setStart(Position position) {
        this.start = position;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public String getShortString() {
        return this.toString();
    }

    public String getLongString() {
        return this.toString();
    }

    public void setName(String string) {
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.methodHeader.isAt(n, n2)) {
            return this.methodHeader;
        }
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                if (!statement.isAt(n, n2)) continue;
                return statement;
            }
        }
        return null;
    }

    @Override
    public void visitSubNodes(NodeVisitor nodeVisitor) {
        if (this.statements == null) {
            return;
        }
        for (Statement statement : this.statements) {
            if (statement == null) break;
            nodeVisitor.visit(statement);
            statement.visitSubNodes(nodeVisitor);
        }
    }
}

