/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.project.itemfinder.PHPItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import net.sourceforge.phpdt.internal.compiler.ast.ArgumentList;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.FormalParameter;
import net.sourceforge.phpdt.internal.compiler.ast.Modifier;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import org.gjt.sp.jedit.GUIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHeader
extends Statement
implements PHPItem,
Serializable {
    private final List<Modifier> modifiers;
    private final String path;
    private final String namespace;
    private final String name;
    private final boolean reference;
    private final ArgumentList uses;
    private final List<FormalParameter> arguments;
    private String cachedToString;
    private transient Icon icon;
    private String nameLowerCase;
    private static final long serialVersionUID = -8681675454927194940L;

    public MethodHeader(String string, String string2, List<Modifier> list, String string3, boolean bl, ArgumentList argumentList, List<FormalParameter> list2, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.namespace = string;
        this.modifiers = list;
        this.path = string2;
        this.name = string3;
        this.reference = bl;
        this.uses = argumentList;
        this.arguments = list2;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameLowerCase() {
        if (this.nameLowerCase == null) {
            this.nameLowerCase = this.name.toLowerCase();
        }
        return this.nameLowerCase;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (this.reference) {
                stringBuilder.append('&');
            }
            stringBuilder.append(this.name);
            stringBuilder.append('(');
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.size(); ++i) {
                    FormalParameter formalParameter = this.arguments.get(i);
                    stringBuilder.append(formalParameter.toStringExpression());
                    if (i == this.arguments.size() - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(')');
            this.cachedToString = stringBuilder.toString();
        }
        return this.cachedToString;
    }

    @Override
    public String toString(int n) {
        return MethodHeader.tabString(n) + this.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    public int getArgumentsCount() {
        return this.arguments.size();
    }

    public void getParameters(Collection<VariableUsage> collection) {
        if (this.arguments != null) {
            for (FormalParameter formalParameter : this.arguments) {
                VariableUsage variableUsage = new VariableUsage(Type.UNKNOWN, formalParameter.getName(), formalParameter.getSourceStart(), formalParameter.getSourceEnd(), formalParameter.getBeginLine(), formalParameter.getEndLine(), formalParameter.getBeginColumn(), formalParameter.getEndColumn());
                collection.add(variableUsage);
            }
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getItemType() {
        return 2;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = GUIUtilities.loadIcon((String)MethodHeader.class.getResource("/gatchan/phpparser/icons/method.png").toString());
        }
        return this.icon;
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.arguments != null) {
            for (FormalParameter formalParameter : this.arguments) {
                if (!formalParameter.isAt(n, n2)) continue;
                return formalParameter;
            }
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.checkModifiers(pHPParser);
    }

    private void checkModifiers(PHPParser pHPParser) {
        if (this.modifiers == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(5);
        for (int i = 0; i < this.modifiers.size(); ++i) {
            Modifier modifier = this.modifiers.get(i);
            if (modifier.isVisibilityModifier()) {
                if (hashSet.add(Integer.toString(-1))) continue;
                pHPParser.fireParseError("You already have a visibility modifier", modifier);
                continue;
            }
            if (!hashSet.add(modifier.toString())) {
                pHPParser.fireParseError("Duplicate modifier " + modifier.toString(), modifier);
                continue;
            }
            modifier.checkCompatibility(pHPParser, this.modifiers);
        }
    }
}

