/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifier
extends AstNode {
    public static final int FINAL = 1;
    public static final int STATIC = 2;
    public static final int PUBLIC = 4;
    public static final int PRIVATE = 8;
    public static final int PROTECTED = 16;
    public static final int CONST = 32;
    public static final int ABSTRACT = 64;
    private final int kind;
    private static final long serialVersionUID = -6959851555310749803L;
    private static final transient Map incompatibilityMap = new HashMap(2);

    public Modifier(Token token) {
        super(token.sourceStart, token.sourceEnd, token.beginLine, token.endLine, token.beginColumn, token.endColumn);
        if ("final".equalsIgnoreCase(token.image)) {
            this.kind = 1;
        } else if ("static".equalsIgnoreCase(token.image)) {
            this.kind = 2;
        } else if ("public".equalsIgnoreCase(token.image)) {
            this.kind = 4;
        } else if ("private".equalsIgnoreCase(token.image)) {
            this.kind = 8;
        } else if ("protected".equalsIgnoreCase(token.image)) {
            this.kind = 16;
        } else if ("const".equalsIgnoreCase(token.image)) {
            this.kind = 32;
        } else if ("abstract".equalsIgnoreCase(token.image)) {
            this.kind = 64;
        } else {
            throw new IllegalArgumentException("Invalid modifier token " + token.image);
        }
    }

    @Override
    public String toString(int n) {
        return Modifier.tabString(n) + Modifier.toStringModifier(this.kind);
    }

    @Override
    public String toString() {
        return Modifier.toStringModifier(this.kind);
    }

    private static String toStringModifier(int n) {
        switch (n) {
            case 1: {
                return "final";
            }
            case 2: {
                return "static";
            }
            case 4: {
                return "public";
            }
            case 8: {
                return "private";
            }
            case 16: {
                return "protected";
            }
            case 32: {
                return "const";
            }
            case 64: {
                return "abstract";
            }
        }
        throw new IllegalArgumentException("Invalid modifier kind " + n);
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
    }

    public boolean isVisibilityModifier() {
        return this.kind == 4 || this.kind == 8 || this.kind == 16;
    }

    public int getKind() {
        return this.kind;
    }

    public void checkCompatibility(PHPParser pHPParser, List<Modifier> list) {
        Map map = (Map)incompatibilityMap.get(this.toString());
        if (map != null) {
            for (Modifier modifier : list) {
                String string = (String)map.get(modifier.toString());
                if (string == null) continue;
                pHPParser.fireParseError(string, modifier);
            }
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(Modifier.toStringModifier(64), "Incompatible modifiers final / abstract");
        HashMap<String, String> hashMap2 = new HashMap<String, String>(1);
        hashMap2.put(Modifier.toStringModifier(1), "Incompatible modifiers final / abstract");
        incompatibilityMap.put(Modifier.toStringModifier(1), hashMap);
        incompatibilityMap.put(Modifier.toStringModifier(64), hashMap2);
    }
}

