/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.Position;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.ClassDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.HTMLCode;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.NodeVisitor;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
import sidekick.IAsset;

public class PHPDocument
implements Outlineable,
IAsset {
    private AstNode[] nodes;
    private final String name;
    private final List<Outlineable> children = new ArrayList<Outlineable>();
    private transient Position start;
    private transient Position end;

    public PHPDocument(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nodes != null) {
            AstNode astNode;
            for (int i = 0; i < this.nodes.length && (astNode = this.nodes[i]) != null; ++i) {
                stringBuilder.append(astNode.toString(0));
                if (astNode instanceof HTMLCode) {
                    stringBuilder.append('\n');
                    continue;
                }
                stringBuilder.append(";\n");
            }
        }
        return stringBuilder.toString();
    }

    public boolean add(Outlineable outlineable) {
        return this.children.add(outlineable);
    }

    public Outlineable get(int n) {
        return this.children.get(n);
    }

    public int size() {
        return this.children.size();
    }

    public Outlineable getParent() {
        return null;
    }

    public void analyzeCode(PHPParser pHPParser) {
        if (this.nodes != null) {
            AstNode astNode;
            for (int i = 0; i < this.nodes.length && (astNode = this.nodes[i]) != null; ++i) {
                astNode.analyzeCode(pHPParser);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public ClassDeclaration classAtOffset(int n, int n2) {
        for (int i = 0; i < this.children.size(); ++i) {
            Outlineable outlineable = this.children.get(i);
            if (outlineable.getItemType() != 1) continue;
            ClassDeclaration classDeclaration = (ClassDeclaration)outlineable;
            if (n == classDeclaration.getBodyLineStart() && n2 > classDeclaration.getBodyColumnStart()) {
                return classDeclaration;
            }
            if (n == classDeclaration.getBodyLineEnd() && n2 < classDeclaration.getBodyColumnEnd()) {
                return classDeclaration;
            }
            if (n <= classDeclaration.getBodyLineStart() || n >= classDeclaration.getBodyLineEnd()) continue;
            return classDeclaration;
        }
        return null;
    }

    public MethodDeclaration methodAtOffset(int n, int n2) {
        for (int i = 0; i < this.children.size(); ++i) {
            Outlineable outlineable = this.children.get(i);
            if (outlineable.getItemType() != 2) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)outlineable;
            if (n == methodDeclaration.getBodyLineStart() && n2 > methodDeclaration.getBodyColumnStart()) {
                return methodDeclaration;
            }
            if (n == methodDeclaration.getBodyLineEnd() && n2 < methodDeclaration.getBodyColumnEnd()) {
                return methodDeclaration;
            }
            if (n <= methodDeclaration.getBodyLineStart() || n >= methodDeclaration.getBodyLineEnd()) continue;
            return methodDeclaration;
        }
        return null;
    }

    public AstNode getNodeAt(int n, int n2) {
        AstNode astNode = null;
        for (int i = 0; i < this.nodes.length && (astNode = this.nodes[i]) != null; ++i) {
            if (n == astNode.getBeginLine() && n2 > astNode.getBeginColumn()) {
                return astNode;
            }
            if (n == astNode.getEndLine() && n2 < astNode.getEndColumn()) {
                return astNode;
            }
            if (n <= astNode.getBeginLine() || n >= astNode.getEndLine()) continue;
            return astNode;
        }
        return astNode;
    }

    public void setNodes(AstNode[] astNodeArray) {
        this.nodes = astNodeArray;
    }

    public void visitNodes(NodeVisitor nodeVisitor) {
        for (AstNode astNode : this.nodes) {
            if (astNode == null) break;
            nodeVisitor.visit(astNode);
            astNode.visitSubNodes(nodeVisitor);
        }
    }

    public int getItemType() {
        return 16;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public Position getStart() {
        return this.start;
    }

    public void setStart(Position position) {
        this.start = position;
    }

    public Icon getIcon() {
        return null;
    }

    public String getShortString() {
        return "/";
    }

    public String getLongString() {
        return "/";
    }

    public void setName(String string) {
    }
}

