/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractCase;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatement
extends Statement {
    private final Expression variable;
    private final AbstractCase[] cases;

    public SwitchStatement(Expression expression, AbstractCase[] abstractCaseArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.variable = expression;
        this.cases = abstractCaseArray;
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(SwitchStatement.tabString(n));
        stringBuilder.append("switch (").append(this.variable.toStringExpression()).append(") {\n");
        for (int i = 0; i < this.cases.length; ++i) {
            AbstractCase abstractCase = this.cases[i];
            stringBuilder.append(abstractCase.toString(n + 1));
            stringBuilder.append('\n');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.cases.length; ++i) {
            this.cases[i].getOutsideVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.cases.length; ++i) {
            this.cases[i].getModifiedVariable(list);
        }
        this.variable.getModifiedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        for (int i = 0; i < this.cases.length; ++i) {
            this.cases[i].getUsedVariable(list);
        }
        this.variable.getUsedVariable(list);
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.variable.isAt(n, n2)) {
            return this.variable;
        }
        for (int i = 0; i < this.cases.length; ++i) {
            AbstractCase abstractCase = this.cases[i];
            if (!abstractCase.isAt(n, n2)) continue;
            return abstractCase.subNodeAt(n, n2);
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.variable.analyzeCode(pHPParser);
        for (int i = 0; i < this.cases.length; ++i) {
            this.cases[i].analyzeCode(pHPParser);
        }
    }
}

