/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import java.io.Serializable;
import org.gjt.sp.util.Log;

public class Type
implements Serializable {
    public static final int UNKNOWN_INT = 0;
    public static final int BOOLEAN_INT = 1;
    public static final int FLOAT_INT = 4;
    public static final int INTEGER_INT = 5;
    public static final int OBJECT_INT = 6;
    public static final int NULL_INT = 7;
    public static final int STRING_INT = 8;
    public static final int ARRAY_INT = 9;
    public static final int RESOURCE_INT = 10;
    public static final int VOID_INT = 11;
    public static final int NUMBER_INT = 12;
    public static final int DOUBLE_INT = 13;
    private final int type;
    public static final Type UNKNOWN = new Type(0);
    public static final Type BOOLEAN = new Type(1);
    public static final Type FLOAT = new Type(4);
    public static final Type INTEGER = new Type(5);
    public static final Type OBJECT = new Type(6);
    public static final Type NULL = new Type(7);
    public static final Type STRING = new Type(8);
    public static final Type ARRAY = new Type(9);
    public static final Type RESOURCE = new Type(10);
    public static final Type VOID = new Type(11);
    public static final Type NUMBER = new Type(12);
    public static final Type DOUBLE = new Type(13);
    private final String className;

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "boolean";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                if (this.className == null) {
                    return "object (unknown)";
                }
                return "object (" + this.className + ')';
            }
            case 7: {
                return "null";
            }
            case 8: {
                return "string";
            }
            case 9: {
                return "array";
            }
            case 10: {
                return "resource";
            }
            case 11: {
                return "void";
            }
            case 12: {
                return "numbers";
            }
            case 13: {
                return "double";
            }
        }
        Log.log((int)9, (Object)this, (Object)("net.sourceforge.phpdt.internal.compiler.ast.Type unknown : " + this.type));
        return null;
    }

    public static Type fromString(String string) {
        if ("boolean".equals(string) || "bool".equals(string)) {
            return BOOLEAN;
        }
        if ("float".equals(string)) {
            return FLOAT;
        }
        if ("integer".equals(string) || "int".equals(string)) {
            return INTEGER;
        }
        if ("null".equals(string)) {
            return NULL;
        }
        if ("string".equals(string)) {
            return STRING;
        }
        if ("array".equals(string)) {
            return ARRAY;
        }
        if ("mixed".equals(string) || "unknown".equals(string)) {
            return UNKNOWN;
        }
        if ("object".equals(string)) {
            return OBJECT;
        }
        if ("resource".equals(string)) {
            return RESOURCE;
        }
        if ("void".equals(string)) {
            return VOID;
        }
        if ("number".equals(string)) {
            return NUMBER;
        }
        return new Type(6, string);
    }

    public Type(int n) {
        this(n, null);
    }

    public Type(int n, String string) {
        this.type = n;
        this.className = string;
    }

    public int getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isCompatibleWith(Type type) {
        if (type == this) {
            return true;
        }
        if (this == UNKNOWN) {
            return true;
        }
        if (type == UNKNOWN) {
            return true;
        }
        if (this == NUMBER && (type == NUMBER || type == FLOAT || type == INTEGER || type == DOUBLE)) {
            return true;
        }
        return this == FLOAT && (type == DOUBLE || type == INTEGER);
    }

    public boolean isEmpty() {
        return this.type == 0 || this.type == 7;
    }
}

