/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import gatchan.phpparser.parser.Token;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractVariable;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Type;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
extends AbstractVariable {
    private String name;
    private AbstractVariable variable;
    private Expression expression;
    private static final String _GET = "_GET";
    private static final String _POST = "_POST";
    private static final String _REQUEST = "_REQUEST";
    private static final String _SERVER = "_SERVER";
    private static final String _SESSION = "_SESSION";
    private static final String _this = "this";
    private static final String GLOBALS = "GLOBALS";
    private static final String _COOKIE = "_COOKIE";
    private static final String _FILES = "_FILES";
    private static final String _ENV = "_ENV";
    public static final String[] SPECIAL_VARS = new String[]{"_GET", "_POST", "_REQUEST", "_SERVER", "_SESSION", "this", "GLOBALS", "_COOKIE", "_FILES", "_ENV"};

    public Variable(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Type.UNKNOWN, n, n2, n3, n4, n5, n6);
        this.name = string;
    }

    public Variable(Token token) {
        super(Type.UNKNOWN, token.sourceStart, token.sourceEnd, token.beginLine, token.endLine, token.beginColumn, token.endColumn);
        this.name = token.image;
    }

    public Variable(AbstractVariable abstractVariable, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Type.UNKNOWN, n, n2, n3, n4, n5, n6);
        this.variable = abstractVariable;
    }

    public Variable(Expression expression, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Type.UNKNOWN, n, n2, n3, n4, n5, n6);
        this.expression = expression;
    }

    @Override
    public String toStringExpression() {
        return '$' + this.getName();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.variable != null) {
            return this.variable.toStringExpression();
        }
        return '{' + this.expression.toStringExpression() + '}';
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        this.getUsedVariable(list);
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.getUsedVariable(list);
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        String string = this.name != null ? this.name : (this.variable != null ? this.variable.getName() : this.expression.toStringExpression());
        if (!Variable.arrayContains(SPECIAL_VARS, this.name)) {
            list.add(new VariableUsage(this.type, string, this.sourceStart, this.sourceEnd, this.beginLine, this.endLine, this.beginColumn, this.endColumn));
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.variable != null && this.variable.isAt(n, n2)) {
            return this.variable;
        }
        if (this.expression != null && this.expression.isAt(n, n2)) {
            return this.expression;
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        if (this.name == null) {
            if (this.variable != null) {
                this.variable.analyzeCode(pHPParser);
            } else {
                this.expression.analyzeCode(pHPParser);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Variable variable = (Variable)object;
        if (this.expression != null ? !this.expression.equals(variable.expression) : variable.expression != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(variable.name) : variable.name != null) {
            return false;
        }
        return !(this.variable != null ? !this.variable.equals(variable.variable) : variable.variable != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.variable != null ? this.variable.hashCode() : 0);
        n = 31 * n + (this.expression != null ? this.expression.hashCode() : 0);
        return n;
    }
}

