/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import gatchan.phpparser.parser.PHPParser;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileStatement
extends Statement {
    private final Expression condition;
    private final Statement action;

    public WhileStatement(Expression expression, Statement statement, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.condition = expression;
        this.action = statement;
    }

    @Override
    public String toString(int n) {
        String string = WhileStatement.tabString(n);
        StringBuilder stringBuilder = new StringBuilder(string).append("while (");
        stringBuilder.append(this.condition.toStringExpression()).append(')');
        if (this.action == null) {
            stringBuilder.append(" {} ;");
        } else {
            stringBuilder.append('\n').append(this.action.toString(n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void getOutsideVariable(List<VariableUsage> list) {
        this.condition.getOutsideVariable(list);
        if (this.action != null) {
            this.action.getOutsideVariable(list);
        }
    }

    @Override
    public void getModifiedVariable(List<VariableUsage> list) {
        this.condition.getModifiedVariable(list);
        if (this.action != null) {
            this.action.getModifiedVariable(list);
        }
    }

    @Override
    public void getUsedVariable(List<VariableUsage> list) {
        this.condition.getUsedVariable(list);
        if (this.action != null) {
            this.action.getUsedVariable(list);
        }
    }

    @Override
    public AstNode subNodeAt(int n, int n2) {
        if (this.condition.isAt(n, n2)) {
            return this.condition;
        }
        if (this.action != null && this.action.isAt(n, n2)) {
            return this.action.subNodeAt(n, n2);
        }
        return null;
    }

    @Override
    public void analyzeCode(PHPParser pHPParser) {
        this.condition.analyzeCode(pHPParser);
        if (this.action != null) {
            this.action.analyzeCode(pHPParser);
        }
    }
}

