/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.gui.ModalJFileChooser;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.jEdit;

public class FileTextField
extends JPanel
implements ActionListener {
    private JTextField text;
    private JButton chooser;
    private boolean forceExists;
    private int selectionMode;

    public FileTextField() {
        this(false);
    }

    public FileTextField(boolean forceExists) {
        this((String)null, forceExists);
    }

    public FileTextField(String text, boolean forceExists) {
        super(new BorderLayout());
        this.forceExists = forceExists;
        this.selectionMode = 0;
        this.text = new JTextField(text);
        this.add("Center", this.text);
        this.chooser = new JButton(jEdit.getProperty((String)"common.gui.filetextfield.choose"));
        this.chooser.addActionListener(this);
        this.add("East", this.chooser);
    }

    public JTextField getTextField() {
        return this.text;
    }

    public void setFileSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ModalJFileChooser chooser = new ModalJFileChooser();
        chooser.setFileSelectionMode(this.selectionMode);
        chooser.setSelectedFile(new File(this.text.getText()));
        if (chooser.showDialog(this, jEdit.getProperty((String)"common.gui.filetextfield.choose")) != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (!(!this.forceExists || f.exists() && f.canRead())) {
            Container parent = SwingUtilities.getAncestorOfClass(JDialog.class, this);
            if (parent == null) {
                parent = SwingUtilities.getAncestorOfClass(JFrame.class, this);
            }
            JOptionPane.showMessageDialog(parent, jEdit.getProperty((String)"common.gui.filetextfield.file_not_found"), jEdit.getProperty((String)"common.gui.error"), 0);
        } else {
            this.getTextField().setText(f.getPath());
        }
    }
}

