/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public class ModalJFileChooser
extends JFileChooser
implements ActionListener {
    private boolean defaultHiddenFileStatus;
    private FileFilter hiddenFileFilter;

    public ModalJFileChooser() {
        this.init();
    }

    public ModalJFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    public ModalJFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.init();
    }

    public ModalJFileChooser(FileSystemView fsv) {
        super(fsv);
        this.init();
    }

    public ModalJFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.init();
    }

    public ModalJFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    private void init() {
        this.hiddenFileFilter = new HiddenFileFilter();
        this.defaultHiddenFileStatus = this.isFileHidingEnabled();
        this.addActionListener(this);
        this.addChoosableFileFilter(this.hiddenFileFilter);
        this.setFileFilter(this.getAcceptAllFileFilter());
    }

    @Override
    protected JDialog createDialog(Component parent) {
        JDialog dialog;
        JDialog parentDlg = null;
        if (parent == null) {
            parent = jEdit.getActiveView();
        } else {
            JDialog jDialog = parentDlg = parent instanceof JDialog ? (JDialog)parent : GUIUtilities.getParentDialog((Component)parent);
        }
        if (parentDlg != null) {
            parent = parentDlg;
            dialog = new JDialog((Dialog)parentDlg, true);
        } else {
            dialog = new JDialog(JOptionPane.getFrameForComponent(parent), true);
        }
        dialog.setTitle(this.getUI().getDialogTitle(this));
        dialog.getContentPane().add(this);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        this.fireActionPerformed("fileFilterChanged");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("fileFilterChanged")) {
            if (this.getFileFilter() == this.hiddenFileFilter) {
                this.setFileHidingEnabled(false);
            } else {
                this.setFileHidingEnabled(this.defaultHiddenFileStatus);
            }
        }
    }

    public static class HiddenFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return jEdit.getProperty((String)"projectviewer.general.hidden_file_filter");
        }
    }
}

