/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.gui.ListPanel;
import common.gui.actions.CustomAction;
import common.gui.util.ConstraintFactory;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

@Deprecated
public class SelectionListPanel
extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected String title = "Select some options";
    protected ConstraintFactory cf;
    protected JButton moveRight;
    protected JButton moveLeft;
    protected ListPanel[] lists = new ListPanel[2];

    public SelectionListPanel() {
        this.cf = new ConstraintFactory();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new ListPanel("List " + i);
        }
        this.add((Component)this.lists[0], this.cf.buildConstraints(0, 0, 10, 20, 10, 1, 100, 100));
        this.add((Component)this.buildMovePanel(), this.cf.buildConstraints(10, 0, 2, 10, 10, 3, 0, 100));
        this.add((Component)this.lists[1], this.cf.buildConstraints(12, 0, 10, 20, 10, 1, 100, 100));
    }

    private JPanel buildMovePanel() {
        CustomAction moveRightAction = new CustomAction("Move Right", GUIUtilities.loadIcon((String)"ArrowR.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectionListPanel.this.moveElements(0, 1);
            }
        };
        this.moveRight = new JButton(moveRightAction);
        this.moveRight.setText("");
        CustomAction moveLeftAction = new CustomAction("Move Left", GUIUtilities.loadIcon((String)"ArrowL.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectionListPanel.this.moveElements(1, 0);
            }
        };
        this.moveLeft = new JButton(moveLeftAction);
        this.moveLeft.setText("");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.moveRight, this.cf.buildConstraints(0, 0, 1, 1, 15, 0, 0, 0));
        panel.add((Component)this.moveLeft, this.cf.buildConstraints(0, 1, 1, 1, 11, 0, 0, 0));
        return panel;
    }

    protected int otherList(int list) {
        return Math.abs(list - 1);
    }

    protected void addElement(int list, Object element) {
        this.removeElement(this.otherList(list), element);
        this.lists[list].addElement(element);
    }

    protected boolean removeElement(int list, Object element) {
        return this.lists[list].removeElement(element);
    }

    protected void moveElements(int srcList, int destList) {
        Object[] selected = this.lists[srcList].getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            int index = this.lists[srcList].getLastSelectedIndex();
            this.removeElement(srcList, selected[i]);
            this.addElement(destList, selected[i]);
            this.lists[srcList].setSelectedIndex(index);
        }
    }

    public void saveToPropertyAsString(int list, String propertyName) {
        int i;
        Object[] elements = this.lists[list].toArray();
        for (i = 0; i < elements.length; ++i) {
            jEdit.setProperty((String)(propertyName + "." + i), (String)elements[i].toString());
        }
        jEdit.unsetProperty((String)(propertyName + "." + i));
    }

    public void loadFromPropertyAsString(int list, String propertyName) {
        ArrayList elements = new ArrayList();
        int index = 0;
        String s = jEdit.getProperty((String)(propertyName + "." + index));
        ++index;
        while (s != null) {
            this.addElement(list, new String(s));
            s = jEdit.getProperty((String)(propertyName + "." + index));
            ++index;
        }
    }

    public void setTitle(String text) {
        this.title = text;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.title));
    }

    public void setListLabel(int list, String text) {
        this.lists[list].setLabel(text);
    }

    public void setListContents(int list, Object[] options) {
        int otherList = Math.abs(list - 1);
        for (int i = 0; i < options.length; ++i) {
            this.removeElement(otherList, options[i]);
            this.addElement(list, options[i]);
        }
    }

    public Object[] getSelectedValues(int list) {
        return this.lists[list].getSelectedValues();
    }

    public Object[] getValues(int list) {
        return this.lists[list].toArray();
    }
}

