/*
 * Decompiled with CFR 0.152.
 */
package common.gui.itemfinder;

import common.gui.itemfinder.ItemFinder;
import common.gui.itemfinder.ItemFinderWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.GUIUtilities;

public class ItemFinderPanel<E>
extends JPanel {
    private final JWindow window;
    private final JTextField searchField;
    private final JList itemList;
    public final RequestFocusWorker requestFocusWorker;
    private final ItemFinder<E> itemFinder;
    private final JScrollPane scroll;

    public ItemFinderPanel(Window owner, ItemFinder<E> itemFinder) {
        super(new BorderLayout());
        this.itemFinder = itemFinder;
        this.window = new JWindow(owner);
        this.searchField = new JTextField(50);
        this.itemList = new JList(itemFinder.getModel());
        this.itemList.setBorder(BorderFactory.createEtchedBorder());
        ListCellRenderer listCellRenderer = itemFinder.getListCellRenderer();
        if (listCellRenderer != null) {
            this.itemList.setCellRenderer(listCellRenderer);
        }
        this.itemList.addKeyListener(new ItemListKeyAdapter(this.searchField));
        this.itemList.addMouseListener(new MyMouseAdapter());
        this.searchField.addKeyListener(new SearchFieldKeyAdapter());
        this.searchField.getDocument().addDocumentListener(new MyDocumentListener());
        this.scroll = new JScrollPane(this.itemList);
        this.window.setContentPane(this.scroll);
        String label = itemFinder.getLabel();
        if (label != null) {
            JLabel comp = new JLabel(label);
            if (owner instanceof ItemFinderWindow) {
                this.add((Component)comp, "North");
            } else {
                this.add((Component)comp, "West");
            }
        }
        this.add((Component)this.searchField, "Center");
        this.window.pack();
        this.requestFocusWorker = new RequestFocusWorker(this.searchField);
    }

    public void dispose() {
        Window owner = this.window.getOwner();
        this.window.dispose();
        if (owner instanceof ItemFinderWindow) {
            owner.dispose();
        }
    }

    private static boolean handledByList(KeyEvent e) {
        return e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 34 || e.getKeyCode() == 33;
    }

    private void select() {
        Object value = this.itemList.getSelectedValue();
        if (value != null) {
            this.searchField.setText("");
            this.itemFinder.selectionMade(value);
            this.dispose();
        }
    }

    public void setText(String s) {
        this.searchField.setText(s);
        this.searchField.selectAll();
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateList(ItemFinderPanel.this.searchField.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateList(ItemFinderPanel.this.searchField.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateList(ItemFinderPanel.this.searchField.getText());
        }

        private void updateList(String s) {
            ItemFinderPanel.this.itemFinder.updateList(s);
            int size = ItemFinderPanel.this.itemList.getModel().getSize();
            if (size == 0) {
                ItemFinderPanel.this.itemList.clearSelection();
                ItemFinderPanel.this.window.setVisible(false);
            } else {
                Rectangle bounds = ItemFinderPanel.this.getBounds();
                Point locationOnScreen = ItemFinderPanel.this.getLocationOnScreen();
                ItemFinderPanel.this.window.setLocation(locationOnScreen.x, locationOnScreen.y + bounds.height);
                Rectangle screenBounds = GUIUtilities.getScreenBounds();
                ItemFinderPanel.this.window.pack();
                Dimension preferredSize = ItemFinderPanel.this.itemList.getPreferredSize();
                int maxWidth = screenBounds.width - locationOnScreen.x;
                int scrollbarWidth = ((ItemFinderPanel)ItemFinderPanel.this).scroll.getVerticalScrollBar().getPreferredSize().width;
                int width = Math.min(preferredSize.width + scrollbarWidth, maxWidth);
                int scrollbarHeight = ((ItemFinderPanel)ItemFinderPanel.this).scroll.getHorizontalScrollBar().getPreferredSize().height;
                int height = Math.min(preferredSize.height + scrollbarHeight, 200);
                ItemFinderPanel.this.window.setSize(width, height);
                ItemFinderPanel.this.window.setVisible(true);
                if (ItemFinderPanel.this.itemList.getSelectedIndex() == -1) {
                    ItemFinderPanel.this.itemList.setSelectedIndex(0);
                }
            }
            EventQueue.invokeLater(ItemFinderPanel.this.requestFocusWorker);
        }
    }

    protected static class RequestFocusWorker
    implements Runnable {
        private final JTextField searchField;

        private RequestFocusWorker(JTextField searchField) {
            this.searchField = searchField;
        }

        @Override
        public void run() {
            this.searchField.requestFocus();
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ItemFinderPanel.this.select();
            }
        }
    }

    private static class ItemListKeyAdapter
    extends KeyAdapter {
        private final JTextField searchField;

        private ItemListKeyAdapter(JTextField searchField) {
            this.searchField = searchField;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.searchField.dispatchEvent(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!ItemFinderPanel.handledByList(e)) {
                this.searchField.dispatchEvent(e);
            }
        }
    }

    private class SearchFieldKeyAdapter
    extends KeyAdapter {
        private SearchFieldKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ItemFinderPanel.handledByList(e)) {
                ItemFinderPanel.this.itemList.dispatchEvent(e);
            } else if (e.getKeyCode() == 27) {
                ItemFinderPanel.this.searchField.setText("");
                ItemFinderPanel.this.dispose();
            } else if (e.getKeyCode() == 10) {
                ItemFinderPanel.this.select();
            }
        }
    }
}

