/*
 * Decompiled with CFR 0.152.
 */
package common.io;

import common.threads.WorkRequest;
import common.threads.WorkerThreadPool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.util.Log;

public class ProcessExecutor {
    private String[] cmd;
    private String cwd;
    private Map<String, String> envp;
    private Process child;
    private StreamReader stderr;
    private StreamReader stdout;
    private List<VisitorEntry> visitors;
    private WorkRequest stderrReq;
    private WorkRequest stdoutReq;

    public ProcessExecutor(String ... cmd) {
        assert (cmd.length > 0) : "cmd cannot be empty";
        this.cmd = cmd;
        this.visitors = new LinkedList<VisitorEntry>();
    }

    public ProcessExecutor setDirectory(String cwd) {
        assert (this.child == null) : "can't set stream after child is executing.";
        this.cwd = cwd;
        return this;
    }

    public ProcessExecutor addCurrentEnv() {
        assert (this.child == null) : "can't set stream after child is executing.";
        if (this.envp == null) {
            this.envp = new HashMap<String, String>();
        }
        this.envp.putAll(System.getenv());
        return this;
    }

    public ProcessExecutor addEnv(String name, String value) {
        assert (this.child == null) : "can't set stream after child is executing.";
        if (this.envp == null) {
            this.envp = new HashMap<String, String>();
        }
        this.envp.put(name, value);
        return this;
    }

    public ProcessExecutor addVisitor(Visitor v) {
        assert (this.child == null) : "can't set stream after child is executing.";
        this.visitors.add(new VisitorEntry(v));
        return this;
    }

    public ProcessExecutor addVisitor(LineVisitor v) {
        assert (this.child == null) : "can't set stream after child is executing.";
        return this.addVisitor(new LineVisitorHelper(v));
    }

    public Process start() throws IOException {
        assert (this.child == null) : "can't reuse ProcessExecutor instances";
        File fcwd = null;
        if (this.cwd != null) {
            fcwd = new File(this.cwd);
        }
        String[] env = null;
        if (this.envp != null) {
            int i = 0;
            env = new String[this.envp.size()];
            for (Map.Entry<String, String> e : this.envp.entrySet()) {
                env[i++] = String.format("%s=%s", e.getKey(), e.getValue());
            }
        }
        this.child = Runtime.getRuntime().exec(this.cmd, env, fcwd);
        this.stderr = new StreamReader(this.child.getErrorStream(), true);
        this.stdout = new StreamReader(this.child.getInputStream(), false);
        WorkRequest[] reqs = WorkerThreadPool.getSharedInstance().runRequests(new Runnable[]{this.stdout, this.stderr});
        this.stdoutReq = reqs[0];
        this.stderrReq = reqs[1];
        return this.child;
    }

    public int waitFor() throws InterruptedException {
        assert (this.child != null) : "command not yet executed";
        this.child.waitFor();
        this.stdoutReq.waitFor();
        this.stderrReq.waitFor();
        return this.child.exitValue();
    }

    public int exitValue() {
        assert (this.child != null) : "command not yet executed";
        return this.child.exitValue();
    }

    private static class VisitorEntry {
        public final Visitor visitor;
        private boolean enabled;

        VisitorEntry(Visitor v) {
            this.visitor = v;
            this.enabled = true;
        }

        public void process(byte[] buf, int len, boolean isError) {
            if (this.enabled) {
                this.enabled = this.visitor.process(buf, len, isError);
            }
        }
    }

    private static class LineVisitorHelper
    implements Visitor {
        private final LineVisitor visitor;
        private final StringBuilder error;
        private final StringBuilder output;

        LineVisitorHelper(LineVisitor visitor) {
            this.visitor = visitor;
            this.error = new StringBuilder();
            this.output = new StringBuilder();
        }

        @Override
        public boolean process(byte[] buf, int len, boolean isError) {
            int idx;
            StringBuilder target;
            StringBuilder stringBuilder = target = isError ? this.error : this.output;
            if (buf != null) {
                for (int i = 0; i < len; ++i) {
                    target.append((char)buf[i]);
                }
            } else if (target.length() > 0) {
                target.append("\n");
            }
            while ((idx = target.indexOf("\n")) >= 0) {
                int cut = idx;
                if (idx > 0 && target.charAt(idx - 1) == '\r') {
                    --cut;
                }
                String line = target.substring(0, cut);
                target.delete(0, idx + 1);
                if (this.visitor.process(line, isError)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BufferingVisitor
    implements Visitor {
        private final ByteArrayOutputStream output;
        private final ByteArrayOutputStream error;

        public BufferingVisitor() {
            this(Streams.BOTH);
        }

        public BufferingVisitor(Streams stream) {
            switch (stream) {
                case BOTH: {
                    this.output = new ByteArrayOutputStream();
                    this.error = new ByteArrayOutputStream();
                    break;
                }
                case STDOUT: {
                    this.output = new ByteArrayOutputStream();
                    this.error = null;
                    break;
                }
                case STDERR: {
                    this.error = new ByteArrayOutputStream();
                    this.output = null;
                    break;
                }
                case MERGE: {
                    this.output = this.error = new ByteArrayOutputStream();
                    break;
                }
                default: {
                    throw new RuntimeException("W.T.F.");
                }
            }
        }

        @Override
        public boolean process(byte[] buf, int len, boolean isError) {
            ByteArrayOutputStream target;
            ByteArrayOutputStream byteArrayOutputStream = target = isError ? this.error : this.output;
            if (target != null && buf != null) {
                target.write(buf, 0, len);
            }
            return true;
        }

        public byte[] getOutput() {
            return this.output.toByteArray();
        }

        public String getOutputString() {
            byte[] data = this.getOutput();
            return new String(data, 0, data.length);
        }

        public byte[] getError() {
            return this.error.toByteArray();
        }

        public String getErrorString() {
            byte[] data = this.getError();
            return new String(data, 0, data.length);
        }

        public static enum Streams {
            BOTH,
            STDOUT,
            STDERR,
            MERGE;

        }
    }

    public static interface LineVisitor {
        public boolean process(String var1, boolean var2);
    }

    public static interface Visitor {
        public boolean process(byte[] var1, int var2, boolean var3);
    }

    private class StreamReader
    implements Runnable {
        private boolean iserr;
        private InputStream input;

        public StreamReader(InputStream in, boolean iserr) {
            this.input = in;
            this.iserr = iserr;
        }

        @Override
        public void run() {
            try {
                byte[] param;
                byte[] buf = new byte[128];
                do {
                    int read = this.input.read(buf);
                    param = buf;
                    if (read == -1) {
                        param = null;
                        read = 0;
                    }
                    for (VisitorEntry entry : ProcessExecutor.this.visitors) {
                        entry.process(param, read, this.iserr);
                    }
                } while (param != null);
            }
            catch (IOException ioe) {
                Log.log((int)1, (Object)this, (Object)ioe);
            }
        }
    }
}

