/*
 * Decompiled with CFR 0.152.
 */
package common.threads;

import common.threads.WorkRequest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.util.Log;

public class WorkerThreadPool {
    private static WorkerThreadPool instance = new WorkerThreadPool();
    private List threads;
    private List requests = new LinkedList();
    private final Object lock = new Object();
    private final ThreadGroup group = new ThreadGroup("CommonControls Worker Pool");
    private static int THREAD_ID = 0;

    public static WorkerThreadPool getSharedInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkRequest addRequest(Runnable req) {
        this.ensureCapacity(1);
        WorkRequest wreq = new WorkRequest(req);
        Object object = this.lock;
        synchronized (object) {
            this.requests.add(wreq);
            this.lock.notifyAll();
        }
        return wreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkRequest[] addRequests(Runnable[] reqs) {
        this.ensureCapacity(reqs.length);
        WorkRequest[] wreqs = this.toWorkRequest(reqs);
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < wreqs.length; ++i) {
                this.requests.add(wreqs[i]);
            }
            this.lock.notifyAll();
        }
        return wreqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkRequest[] runRequests(Runnable[] reqs) {
        WorkRequest[] wreqs = this.toWorkRequest(reqs);
        this.ensureCapacity(wreqs.length);
        Object object = this.lock;
        synchronized (object) {
            int curr = 0;
            Iterator i = this.threads.iterator();
            while (curr < wreqs.length && i.hasNext()) {
                WorkerThread wt = (WorkerThread)i.next();
                if (!wt.isIdle()) continue;
                wt.setWorkload(wreqs[curr++]);
            }
            for (int i2 = curr; i2 < wreqs.length; ++i2) {
                WorkerThread t = new WorkerThread();
                t.setWorkload(wreqs[i2]);
                t.start();
                this.threads.add(t);
            }
            this.lock.notifyAll();
        }
        return wreqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int size) {
        Object object = this.lock;
        synchronized (object) {
            if (this.threads == null) {
                this.threads = new LinkedList();
            }
            while (this.threads.size() < size) {
                WorkerThread t = new WorkerThread();
                t.start();
                this.threads.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.threads != null) {
                Iterator i = this.threads.iterator();
                while (i.hasNext()) {
                    ((WorkerThread)i.next()).requestShutdown();
                    i.remove();
                }
            }
        }
    }

    private WorkRequest[] toWorkRequest(Runnable[] reqs) {
        WorkRequest[] wreqs = new WorkRequest[reqs.length];
        for (int i = 0; i < wreqs.length; ++i) {
            wreqs[i] = new WorkRequest(reqs[i]);
        }
        return wreqs;
    }

    private class WorkerThread
    extends Thread {
        private boolean run;
        private int idleCount;
        private volatile WorkRequest work;

        public WorkerThread() {
            super(WorkerThreadPool.this.group, "CC::Worker #" + ++THREAD_ID);
            this.run = true;
            this.idleCount = 0;
            this.work = null;
            this.setDaemon(true);
        }

        public void setWorkload(WorkRequest work) {
            this.work = work;
        }

        public boolean isIdle() {
            return this.work == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                this.idleCount = 0;
                Object object = WorkerThreadPool.this.lock;
                synchronized (object) {
                    while (this.run && this.work == null && this.idleCount < 10) {
                        if (WorkerThreadPool.this.requests.size() > 0) {
                            this.work = (WorkRequest)WorkerThreadPool.this.requests.remove(0);
                            break;
                        }
                        try {
                            WorkerThreadPool.this.lock.wait(10000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                        ++this.idleCount;
                    }
                }
                if (this.work != null) {
                    Log.log((int)5, (Object)this, (Object)("Executing request: " + this.work.getRunnable()));
                    this.work.run();
                    this.work = null;
                    continue;
                }
                if (this.idleCount < 10) continue;
                object = WorkerThreadPool.this.lock;
                synchronized (object) {
                    boolean bl = this.run = WorkerThreadPool.this.threads.size() <= 1;
                    if (!this.run) {
                        WorkerThreadPool.this.threads.remove(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestShutdown() {
            Object object = WorkerThreadPool.this.lock;
            synchronized (object) {
                this.run = false;
                WorkerThreadPool.this.lock.notifyAll();
            }
        }
    }
}

