/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks.url;

import gatchan.jedit.hyperlinks.Hyperlink;
import gatchan.jedit.hyperlinks.HyperlinkSource;
import gatchan.jedit.hyperlinks.jEditOpenFileHyperlink;
import java.net.MalformedURLException;
import java.net.URL;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.TextUtilities;

public class URLHyperlinkSource
implements HyperlinkSource {
    private static final String NO_WORD_SEP = "/.-_&;:%#?=";
    private Hyperlink currentLink;

    public Hyperlink getHyperlink(Buffer buffer, int caretPosition) {
        if (this.currentLink != null && this.currentLink.getStartOffset() <= caretPosition && this.currentLink.getEndOffset() >= caretPosition) {
            return this.currentLink;
        }
        int line = buffer.getLineOfOffset(caretPosition);
        int lineStart = buffer.getLineStartOffset(line);
        int lineLength = buffer.getLineLength(line);
        if (lineLength == 0) {
            return null;
        }
        int offset = caretPosition - lineStart;
        String lineText = buffer.getLineText(line);
        if (offset == lineLength) {
            --offset;
        }
        int wordStart = TextUtilities.findWordStart((String)lineText, (int)offset, (String)NO_WORD_SEP, (boolean)true, (boolean)false, (boolean)false);
        int wordEnd = TextUtilities.findWordEnd((String)lineText, (int)(offset + 1), (String)NO_WORD_SEP, (boolean)true, (boolean)false, (boolean)false);
        String url = lineText.substring(wordStart, wordEnd);
        try {
            new URL(url);
            this.currentLink = new jEditOpenFileHyperlink(lineStart + wordStart, lineStart + wordEnd, line, url);
        }
        catch (MalformedURLException e) {
            this.currentLink = null;
        }
        return this.currentLink;
    }
}

