/* Generated By:JavaCC: Do not edit this line. PHPParser.java */
package gatchan.phpparser.parser;

//{{{ Imports
import java.util.ArrayList;
import java.io.*;
import java.util.List;
import java.util.Collection;
import java.util.Stack;

import net.sourceforge.phpdt.internal.compiler.ast.declarations.VariableUsage;
import net.sourceforge.phpdt.internal.compiler.ast.*;
import net.sourceforge.phpdt.internal.compiler.parser.Outlineable;
//}}}

//{{{ PHPParser class
/**
 * @author Matthieu Casanova <chocolat.mou@gmail.com>
 * @version $Id: PHPParser.jj 23718 2014-11-06 10:01:49Z kpouer $
 */
public class PHPParser implements PHPParserConstants {
        //{{{ Fields

        //{{{ constants for methods and function distinction (some keywords are allowed in method classes

        public static final int CONST_METHOD = 0;
        public static final int CONST_FUNCTION = 1;
        //}}}
        public static final int ERROR = 2;
        public static final int WARNING = 1;
        public static final int INFO = 0;

        /** The current segment. */
        private Outlineable currentSegment;

        /** The message of the current ParseException. If it's null it's because the parse exception wasn't handled */
        private String errorMessage;

        private int errorStart = -1;
        private int errorEnd = -1;
        private PHPDocument phpDocument;

        public static final String SYNTAX_ERROR_CHAR = "syntax error";
        /**
	* The point where html starts.
	* It will be used by the token manager to create HTMLCode objects
	*/
        private int htmlStart;
        private int htmlLineStart;
        private int htmlColumnStart;

        //ast stack
        private static final int AstStackIncrement = 100;
        /** The stack of node. */
        private Statement[] nodes;
        /** The cursor in expression stack. */
        private int nodePtr;

        private final List<PHPParserListener> parserListeners = new ArrayList<PHPParserListener>();

        private String path;

        /** Tell if the parsing should be stopped. */
        private boolean shouldStop;

        private Stack<Scope> scopeStack;

        private Scope scope;

        private final List tempList = new ArrayList();

        /**
	 * The current namespace
	 */
        private String namespace;

        private String currentBuffer;
        //}}}

        //{{{ PHPParser constructor
        public PHPParser()
        {
        } //}}}

        //{{{ setPath() method
        /**
	 * Set the path of the file that is currently parsed.
	 * This path will be sent in parse errors and messages
	 *
	 * @param path the path of the parsed file
	 */
        public void setPath(String path)
        {
                 this.path = path;
        } //}}}

        //{{{ getPath()
        public String getPath()
        {
                return path;
        } //}}}

        //{{{ stop()
        /**
	 * Ask the parser to stop his work.
	 */
        public void stop()
        {
                shouldStop = true;
        } //}}}

        //{{{ isStopped()
        public boolean isStopped()
        {
                return shouldStop;
        } //}}}

        //{{{ addParserListener(PHPParserListener listener)
        public void addParserListener(PHPParserListener listener)
        {
                if (!parserListeners.contains(listener))
                        parserListeners.add(listener);
        } //}}}

        //{{{ removeParserListener(PHPParserListener listener)
        public void removeParserListener(PHPParserListener listener)
        {
                parserListeners.remove(listener);
        } //}}}

        //{{{ fireParseError(PHPParseErrorEvent e)
        public void fireParseError(PHPParseErrorEvent e)
        {
                for (PHPParserListener listener : parserListeners)
                        listener.parseError(e);
        } //}}}

        //{{{ fireParseError() methods
        public void fireParseError(String message, String expected, Token token)
        {
                fireParseError(new PHPParseErrorEvent(ERROR,
                                                      path,
                                                      message,
                                                      expected,
                                                      token));
        }

        public void fireParseError(String message, AstNode node)
        {
                fireParseError(new PHPParseErrorEvent(ERROR,
                                                      path,
                                                      message,
                                                      node.getSourceStart(),
                                                      node.getSourceEnd(),
                                                      node.getBeginLine(),
                                                      node.getEndLine(),
                                                      node.getBeginColumn(),
                                                      node.getEndColumn()));
        } //}}}

        //{{{ fireParseMessage(PHPParseMessageEvent e)
        public void fireParseMessage(PHPParseMessageEvent e)
        {
                for (PHPParserListener listener: parserListeners)
                        listener.parseMessage(e);
        } //}}}

        //{{{ phpParserTester(String strEval)
        public void phpParserTester(String strEval) throws ParseException
        {
                StringReader stream = new StringReader(strEval);
                if (jj_input_stream == null)
                {
                        jj_input_stream = new SimpleCharStream(stream, 1, 1);
                        token_source = new PHPParserTokenManager(jj_input_stream);
                }
                ReInit(new StringReader(strEval));
                init();
                phpDocument = new PHPDocument("_root");
                scope = new Scope();
                scopeStack = new Stack<Scope>();
                scopeStack.push(scope);
                currentSegment = phpDocument;
                token_source.SwitchTo(PHPPARSING);
                phpTest();
        } //}}}

        //{{{ htmlParserTester() methods
        public void htmlParserTester(File fileName) throws FileNotFoundException, ParseException
        {
                Reader stream = new FileReader(fileName);
                if (jj_input_stream == null)
                {
                        jj_input_stream = new SimpleCharStream(stream, 1, 1);
                        token_source = new PHPParserTokenManager(jj_input_stream);
                }
                ReInit(stream);
                init();
                phpDocument = new PHPDocument("_root");
                scope = new Scope();
                scopeStack = new Stack<Scope>();
                scopeStack.push(scope);
                currentSegment = phpDocument;
                phpFile();
        }

        public void htmlParserTester(String strEval) throws ParseException
        {
                StringReader stream = new StringReader(strEval);
                if (jj_input_stream == null)
                {
                        jj_input_stream = new SimpleCharStream(stream, 1, 1);
                        token_source = new PHPParserTokenManager(jj_input_stream);
                }
                ReInit(stream);
                init();
                phpDocument = new PHPDocument("_root");
                scope = new Scope();
                scopeStack = new Stack<Scope>();
                scopeStack.push(scope);
                currentSegment = phpDocument;
                phpFile();
        } //}}}

        //{{{ init()
        /**
	 * Reinitialize the parser.
	 */
        private void init()
        {
                nodes = new Statement[AstStackIncrement];
                nodePtr = -1;
                htmlStart = 0;
                htmlColumnStart = 0;
                htmlLineStart = 0;
        } //}}}

        //{{{ pushOnAstNodes(Statement node)
        /**
	 * Add an php node on the stack.
	 * @param node the node that will be added to the stack
	 */
        private void pushOnAstNodes(Statement node)
        {
                try
                {
                        nodes[++nodePtr] = node;
                }
                catch (IndexOutOfBoundsException e)
                {
                        int oldStackLength = nodes.length;
                        Statement[] oldStack = nodes;
                        nodes = new Statement[oldStackLength + AstStackIncrement];
                        System.arraycopy(oldStack, 0, nodes, 0, oldStackLength);
                        nodePtr = oldStackLength;
                        nodes[nodePtr] = node;
                }
        } //}}}

        //{{{ parse() methods
         public void parse() throws ParseException
         {
                 phpFile();
         }

        public void parse(String s) throws ParseException
        {
                currentBuffer = s;
                Reader reader = new StringReader(s);
                parse(reader);
        }

        public void parse(Reader reader) throws ParseException
        {
                phpDocument = new PHPDocument("_root");
                scope = new Scope();
                scopeStack = new Stack<Scope>();
                scopeStack.push(scope);
                currentSegment = phpDocument;
                if (jj_input_stream == null)
                {
                        jj_input_stream = new SimpleCharStream(reader, 1, 1);
                        jj_input_stream.setTabSize(1);
                        token_source = new PHPParserTokenManager(jj_input_stream);
                }
                ReInit(reader);
                init();
                parse();
                Statement[] astNodes = new Statement[nodes.length];
                phpDocument.setNodes(astNodes);
                System.arraycopy(nodes,0,astNodes,0,nodes.length);
                phpDocument.analyzeCode(this);
        } //}}}

        //{{{ createNewHTMLCode() method
        /**
	 * Put a new html block in the stack.
	 */
        public void createNewHTMLCode()
        {
                int currentPosition = token.sourceStart;

                if (currentPosition <= htmlStart)
                        return;
                pushOnAstNodes(new HTMLCode(currentBuffer.substring(htmlStart, currentPosition),
                        htmlStart,currentPosition,htmlLineStart,token.endLine,htmlColumnStart,token.endColumn));
        } //}}}

        //{{{ error_skipto(int kind)
        Token error_skipto(int kind)
        {
                //  ParseException e = generateParseException();  // generate the exception object.
                //  System.out.println(e.toString());  // print the error message
                Token t;
                do
                {
                        t = getNextToken();
                }
                while (t.kind != kind && t.kind != EOF && t.kind != RBRACE);
                return t;
        } //}}}

        //{{{ getPHPDocument()
        public PHPDocument getPHPDocument()
        {
                return phpDocument;
        } //}}}

        //{{{ setTypeFromScope(Variable variable)
        private void setTypeFromScope(Variable variable)
        {
                VariableUsage usage = scope.getVariable(variable.getName(),variable.getBeginLine(),variable.getBeginColumn());
                if (usage != null)
                {
                        variable.setType(usage.getType());
                }
        }

//}}}



//{{{ PHP Structures

//{{{ phpTest()
  final public void phpTest() throws ParseException {
    Php();
    jj_consume_token(0);
  }

  //}}}

//{{{ phpFile()
  final public void phpFile() throws ParseException {
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PHPSTARTSHORT:
        case PHPSTARTLONG:
        case PHPECHOSTART:
        case PHPEND:
        case ABSTRACT:
        case INTERFACE:
        case FINAL:
        case TRY:
        case THROW:
        case CLASS:
        case FUNCTION:
        case NAMESPACE:
        case USE:
        case IF:
        case ARRAY:
        case BREAK:
        case LIST:
        case PRINT:
        case ECHO:
        case INCLUDE:
        case REQUIRE:
        case INCLUDE_ONCE:
        case REQUIRE_ONCE:
        case GLOBAL:
        case STATIC:
        case CONST:
        case CONTINUE:
        case DO:
        case FOR:
        case NEW:
        case CLONE:
        case RETURN:
        case SWITCH:
        case WHILE:
        case FOREACH:
        case DEFINE:
        case GOTO:
        case NULL:
        case SUPER:
        case THIS:
        case TRUE:
        case FALSE:
        case STRING:
        case OBJECT:
        case BOOL:
        case BOOLEAN:
        case REAL:
        case DOUBLE:
        case FLOAT:
        case INT:
        case INTEGER:
        case AT:
        case BANG:
        case TILDE:
        case PLUS_PLUS:
        case MINUS_MINUS:
        case PLUS:
        case MINUS:
        case BIT_AND:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case DOUBLEQUOTE:
        case HEREDOCSTARTTOKEN:
        case DOLLAR:
        case IDENTIFIER:
        case NAMESPACE_IDENTIFIER:
        case LPAREN:
        case SEMICOLON:
        case LBRACE:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        phpBlock();
      }
                        createNewHTMLCode();
    } catch (TokenMgrError e) {
                //{{{ Parse Error
                fireParseError(new PHPParseErrorEvent(ERROR,
                                                      path,
                                                      e.getMessage(),
                                                      e.getMessage(),
                                                      null,
                                                      jj_input_stream.getBeginOffset(),
                                                      jj_input_stream.getEndOffset(),
                                                      jj_input_stream.getBeginLine(),
                                                      jj_input_stream.getEndLine(),
                                                      jj_input_stream.getBeginColumn(),
                                                      jj_input_stream.getEndColumn())); //}}}

    }
  }

  //}}}

//{{{ phpBlock() method
/**
 * A php block is a <?= expression [;]?>
 * or <?php somephpcode ?>
 * or <? somephpcode ?>
 */
  final public void phpBlock() throws ParseException {
        PHPEchoBlock phpEchoBlock;
        Token token;
        Token phpEnd;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PHPECHOSTART:
      phpEchoBlock = phpEchoBlock();
                pushOnAstNodes(phpEchoBlock);
      break;
    case PHPSTARTSHORT:
    case PHPSTARTLONG:
    case PHPEND:
    case ABSTRACT:
    case INTERFACE:
    case FINAL:
    case TRY:
    case THROW:
    case CLASS:
    case FUNCTION:
    case NAMESPACE:
    case USE:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONST:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPSTARTSHORT:
      case PHPSTARTLONG:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PHPSTARTLONG:
          jj_consume_token(PHPSTARTLONG);
          break;
        case PHPSTARTSHORT:
          token = jj_consume_token(PHPSTARTSHORT);
                fireParseMessage(new PHPParseMessageEvent(INFO,
                                                          WarningMessageClass.shortOpenTag,
                                                          path,
                                                          "You should use '<?php' instead of '<?' it will avoid some problems with XML",
                                                          token));
          break;
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[2] = jj_gen;
        ;
      }
                createNewHTMLCode();
      Php();
      try {
        phpEnd = jj_consume_token(PHPEND);
                        htmlStart = phpEnd.sourceEnd;
                        htmlLineStart = phpEnd.endLine;
                        htmlColumnStart = phpEnd.endColumn;
      } catch (ParseException e) {

      }
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  //}}}

//{{{ phpEchoBlock() method
  final public PHPEchoBlock phpEchoBlock() throws ParseException {
        Expression expr;
        PHPEchoBlock echoBlock;
        Token echoStartToken;
        Token echoEndToken;
    echoStartToken = jj_consume_token(PHPECHOSTART);
                createNewHTMLCode();
    expr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    try {
      echoEndToken = jj_consume_token(PHPEND);
                        htmlStart = echoEndToken.sourceEnd;
                        htmlLineStart = echoEndToken.endLine;
                        htmlColumnStart = echoEndToken.endColumn;
                        echoBlock = new PHPEchoBlock(expr,echoStartToken.sourceStart,
                                                     echoEndToken.sourceEnd,
                                                     echoStartToken.beginLine,
                                                     echoEndToken.endLine,
                                                     echoStartToken.beginColumn,
                                                     echoEndToken.endColumn);
    } catch (ParseException e) {
                echoBlock = new PHPEchoBlock(expr,
                                             echoStartToken.sourceStart,
                                             e.currentToken.sourceEnd,
                                             echoStartToken.beginLine,
                                             e.currentToken.endLine,
                                             echoStartToken.beginColumn,
                                             e.currentToken.endColumn);
    }
                pushOnAstNodes(echoBlock);
                {if (true) return echoBlock;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ Php()
  final public void Php() throws ParseException {
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case INTERFACE:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case NAMESPACE:
      case USE:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONST:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAMESPACE:
        namespace();
        break;
      case USE:
        useNamespace();
        break;
      case CONST:
        constantStatement();
        break;
      case ABSTRACT:
      case INTERFACE:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        BlockStatement();
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  //}}}

//}}}

//{{{ namespace() method
  final public Namespace namespace() throws ParseException {
        Token namespaceToken;
        Token namespaceNameToken = null;
        Token semicolon;
        int sourceEnd;
        int endLine;
        int endColumn;
                namespace = null;
    namespaceToken = jj_consume_token(NAMESPACE);
                sourceEnd = namespaceToken.sourceEnd;
                endLine = namespaceToken.endLine;
                endColumn = namespaceToken.endColumn;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case INTERFACE:
        case FINAL:
        case TRY:
        case THROW:
        case CLASS:
        case FUNCTION:
        case USE:
        case IF:
        case ARRAY:
        case BREAK:
        case LIST:
        case PRINT:
        case ECHO:
        case INCLUDE:
        case REQUIRE:
        case INCLUDE_ONCE:
        case REQUIRE_ONCE:
        case GLOBAL:
        case STATIC:
        case CONST:
        case CONTINUE:
        case DO:
        case FOR:
        case NEW:
        case CLONE:
        case RETURN:
        case SWITCH:
        case WHILE:
        case FOREACH:
        case DEFINE:
        case GOTO:
        case NULL:
        case SUPER:
        case THIS:
        case TRUE:
        case FALSE:
        case STRING:
        case OBJECT:
        case BOOL:
        case BOOLEAN:
        case REAL:
        case DOUBLE:
        case FLOAT:
        case INT:
        case INTEGER:
        case AT:
        case BANG:
        case TILDE:
        case PLUS_PLUS:
        case MINUS_MINUS:
        case PLUS:
        case MINUS:
        case BIT_AND:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case DOUBLEQUOTE:
        case HEREDOCSTARTTOKEN:
        case DOLLAR:
        case IDENTIFIER:
        case NAMESPACE_IDENTIFIER:
        case LPAREN:
        case SEMICOLON:
        case LBRACE:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case USE:
          useNamespace();
          break;
        case CONST:
          constantStatement();
          break;
        case ABSTRACT:
        case INTERFACE:
        case FINAL:
        case TRY:
        case THROW:
        case CLASS:
        case FUNCTION:
        case IF:
        case ARRAY:
        case BREAK:
        case LIST:
        case PRINT:
        case ECHO:
        case INCLUDE:
        case REQUIRE:
        case INCLUDE_ONCE:
        case REQUIRE_ONCE:
        case GLOBAL:
        case STATIC:
        case CONTINUE:
        case DO:
        case FOR:
        case NEW:
        case CLONE:
        case RETURN:
        case SWITCH:
        case WHILE:
        case FOREACH:
        case DEFINE:
        case GOTO:
        case NULL:
        case SUPER:
        case THIS:
        case TRUE:
        case FALSE:
        case STRING:
        case OBJECT:
        case BOOL:
        case BOOLEAN:
        case REAL:
        case DOUBLE:
        case FLOAT:
        case INT:
        case INTEGER:
        case AT:
        case BANG:
        case TILDE:
        case PLUS_PLUS:
        case MINUS_MINUS:
        case PLUS:
        case MINUS:
        case BIT_AND:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case DOUBLEQUOTE:
        case HEREDOCSTARTTOKEN:
        case DOLLAR:
        case IDENTIFIER:
        case NAMESPACE_IDENTIFIER:
        case LPAREN:
        case SEMICOLON:
        case LBRACE:
          BlockStatement();
          break;
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
                        String namespaceName = namespaceNameToken == null ? null : namespaceNameToken.image;
                        namespace = Namespace.getNamespace(namespaceName);
                        {if (true) return new Namespace(namespace,
                                             namespaceToken.sourceStart,
                                             sourceEnd,
                                             namespaceToken.beginLine,
                                             endLine,
                                             namespaceToken.beginColumn,
                                             endColumn);}
      break;
    case NAMESPACE_NAME:
      namespaceNameToken = jj_consume_token(NAMESPACE_NAME);
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          jj_consume_token(LBRACE);
          label_4:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ABSTRACT:
            case INTERFACE:
            case FINAL:
            case TRY:
            case THROW:
            case CLASS:
            case FUNCTION:
            case USE:
            case IF:
            case ARRAY:
            case BREAK:
            case LIST:
            case PRINT:
            case ECHO:
            case INCLUDE:
            case REQUIRE:
            case INCLUDE_ONCE:
            case REQUIRE_ONCE:
            case GLOBAL:
            case STATIC:
            case CONST:
            case CONTINUE:
            case DO:
            case FOR:
            case NEW:
            case CLONE:
            case RETURN:
            case SWITCH:
            case WHILE:
            case FOREACH:
            case DEFINE:
            case GOTO:
            case NULL:
            case SUPER:
            case THIS:
            case TRUE:
            case FALSE:
            case STRING:
            case OBJECT:
            case BOOL:
            case BOOLEAN:
            case REAL:
            case DOUBLE:
            case FLOAT:
            case INT:
            case INTEGER:
            case AT:
            case BANG:
            case TILDE:
            case PLUS_PLUS:
            case MINUS_MINUS:
            case PLUS:
            case MINUS:
            case BIT_AND:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case STRING_LITERAL:
            case DOUBLEQUOTE:
            case HEREDOCSTARTTOKEN:
            case DOLLAR:
            case IDENTIFIER:
            case NAMESPACE_IDENTIFIER:
            case LPAREN:
            case SEMICOLON:
            case LBRACE:
              ;
              break;
            default:
              jj_la1[9] = jj_gen;
              break label_4;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case USE:
              useNamespace();
              break;
            case CONST:
              constantStatement();
              break;
            case ABSTRACT:
            case INTERFACE:
            case FINAL:
            case TRY:
            case THROW:
            case CLASS:
            case FUNCTION:
            case IF:
            case ARRAY:
            case BREAK:
            case LIST:
            case PRINT:
            case ECHO:
            case INCLUDE:
            case REQUIRE:
            case INCLUDE_ONCE:
            case REQUIRE_ONCE:
            case GLOBAL:
            case STATIC:
            case CONTINUE:
            case DO:
            case FOR:
            case NEW:
            case CLONE:
            case RETURN:
            case SWITCH:
            case WHILE:
            case FOREACH:
            case DEFINE:
            case GOTO:
            case NULL:
            case SUPER:
            case THIS:
            case TRUE:
            case FALSE:
            case STRING:
            case OBJECT:
            case BOOL:
            case BOOLEAN:
            case REAL:
            case DOUBLE:
            case FLOAT:
            case INT:
            case INTEGER:
            case AT:
            case BANG:
            case TILDE:
            case PLUS_PLUS:
            case MINUS_MINUS:
            case PLUS:
            case MINUS:
            case BIT_AND:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case STRING_LITERAL:
            case DOUBLEQUOTE:
            case HEREDOCSTARTTOKEN:
            case DOLLAR:
            case IDENTIFIER:
            case NAMESPACE_IDENTIFIER:
            case LPAREN:
            case SEMICOLON:
            case LBRACE:
              BlockStatement();
              break;
            default:
              jj_la1[10] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(RBRACE);
                                        namespace = Namespace.getNamespace(namespaceNameToken.image);
                                        {if (true) return new Namespace(namespace,
                                                             namespaceToken.sourceStart,
                                                             sourceEnd,
                                                             namespaceToken.beginLine,
                                                             endLine,
                                                             namespaceToken.beginColumn,
                                                             endColumn);}
          break;
        case SEMICOLON:
          semicolon = jj_consume_token(SEMICOLON);
                                        sourceEnd = semicolon.sourceEnd;
                                        endLine = semicolon.endLine;
                                        endColumn = semicolon.endColumn;
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
                        fireParseError("{ ...} or ; expected",";",e.currentToken.next);
      }
                        namespace = Namespace.getNamespace(namespaceNameToken.image);
                        {if (true) return new Namespace(namespace,
                                             namespaceToken.sourceStart,
                                             sourceEnd,
                                             namespaceToken.beginLine,
                                             endLine,
                                             namespaceToken.beginColumn,
                                             endColumn);}
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ useNamespace() method
  final public UseNamespace useNamespace() throws ParseException {
        Token useToken;
        Token namespaceNameToken;
        Token semicolon;
        Token asToken;
        int sourceEnd;
        int endLine;
        int endColumn;
        List<Expression> list = new ArrayList<Expression>();
        Expression expr;
    //{{{ <USE>
            useToken = jj_consume_token(USE);
                sourceEnd = useToken.sourceEnd;
                endLine = useToken.endLine;
                endColumn = useToken.endColumn;
    try {
      namespaceNameToken = namespaceIdentifier();
                        expr = new ConstantIdentifier(namespaceNameToken);
                        sourceEnd = namespaceNameToken.sourceEnd;
                        endLine = namespaceNameToken.endLine;
                        endColumn = namespaceNameToken.endColumn;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        asToken = jj_consume_token(AS);
                                sourceEnd = namespaceNameToken.sourceEnd;
                                endLine = namespaceNameToken.endLine;
                                endColumn = namespaceNameToken.endColumn;
        jj_consume_token(IDENTIFIER);
                                sourceEnd = namespaceNameToken.sourceEnd;
                                endLine = namespaceNameToken.endLine;
                                endColumn = namespaceNameToken.endColumn;
                                expr = new BinaryExpression(expr,
                                                            new ConstantIdentifier(token),
                                                            asToken.kind,
                                                            expr.getSourceStart(),
                                                            sourceEnd,
                                                            expr.getBeginLine(),
                                                            endLine,
                                                            expr.getBeginColumn(),
                                                            endColumn);
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
                        list.add(expr);
    } catch (ParseException e) {
                fireParseError("namespace expected",";",e.currentToken.next);
    }
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      try {
        namespaceNameToken = namespaceIdentifier();
                        expr = new ConstantIdentifier(namespaceNameToken);
                        sourceEnd = namespaceNameToken.sourceEnd;
                        endLine = namespaceNameToken.endLine;
                        endColumn = namespaceNameToken.endColumn;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AS:
          asToken = jj_consume_token(AS);
                                sourceEnd = namespaceNameToken.sourceEnd;
                                endLine = namespaceNameToken.endLine;
                                endColumn = namespaceNameToken.endColumn;
          jj_consume_token(IDENTIFIER);
                                sourceEnd = namespaceNameToken.sourceEnd;
                                endLine = namespaceNameToken.endLine;
                                endColumn = namespaceNameToken.endColumn;
                                expr = new BinaryExpression(expr,
                                                            new ConstantIdentifier(token),
                                                            asToken.kind,
                                                            expr.getSourceStart(),
                                                            sourceEnd,
                                                            expr.getBeginLine(),
                                                            endLine,
                                                            expr.getBeginColumn(),
                                                            endColumn);
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
                        list.add(expr);
      } catch (ParseException e) {
                fireParseError("namespace expected",";",e.currentToken.next);
      }
    }
    try {
      semicolon = jj_consume_token(SEMICOLON);
                sourceEnd = semicolon.sourceEnd;
                endLine = semicolon.endLine;
                endColumn = semicolon.endColumn;
    } catch (ParseException e) {
                fireParseError("; expected",";",e.currentToken.next);
    }
                {if (true) return new UseNamespace(list,
                        useToken.sourceStart,
                        sourceEnd,
                        useToken.beginLine,
                        endLine,
                        useToken.beginColumn,
                        endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ interfaceDeclaration()
  final public InterfaceDeclaration interfaceDeclaration() throws ParseException {
        Token modifierToken;
        Token interfaceToken, rBraceToken;
        Token nameToken;
        InterfaceDeclaration interfaceDeclaration;
        String interfaceNameImage = SYNTAX_ERROR_CHAR;
        MethodDeclaration methodDeclaration;
        List<ConstantIdentifier> superInterfaces = null;
        List<Modifier> modifiers = new ArrayList<Modifier>(1);
        List<ClassConstant> classConstants;
    //{{{ interface <IDENTIFIER>
            interfaceToken = jj_consume_token(INTERFACE);
    try {
      nameToken = jj_consume_token(IDENTIFIER);
                        interfaceNameImage = nameToken.image;
    } catch (ParseException e) {
                fireParseError("identifier expected","identifier",e.currentToken.next);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      nameToken = superClassOrInterface();
                        superInterfaces = new ArrayList<ConstantIdentifier>();
                        superInterfaces.add(new ConstantIdentifier(nameToken));
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_6;
        }
        jj_consume_token(COMMA);
        nameToken = superClassOrInterface();
                        superInterfaces.add(new ConstantIdentifier(nameToken));
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
                interfaceDeclaration = new InterfaceDeclaration(namespace,
                                                                path,
                                                                currentSegment,
                                                                interfaceNameImage,
                                                                superInterfaces,
                                                                interfaceToken.sourceStart,
                                                                interfaceToken.beginLine,
                                                                interfaceToken.beginColumn);
                currentSegment.add(interfaceDeclaration);
                currentSegment = interfaceDeclaration;
                scope = new Scope();
                scopeStack.push(scope);
    try {
      jj_consume_token(LBRACE);
    } catch (ParseException e) {
                fireParseError("{ expected","{",e.currentToken.next);
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
      case FUNCTION:
      case STATIC:
      case CONST:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
      case FUNCTION:
      case STATIC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PUBLIC:
        case STATIC:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PUBLIC:
            //{{{ public [static]
                                     modifierToken = jj_consume_token(PUBLIC);
                                 modifiers.add(new Modifier(modifierToken));
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case STATIC:
              try {
                modifierToken = jj_consume_token(STATIC);
                                         modifiers.add(new Modifier(modifierToken));
              } catch (ParseException e) {
                                 fireParseError("static or function token expected","static|function",e.currentToken.next);
              }
              break;
            default:
              jj_la1[19] = jj_gen;
              ;
            }
            break;
          case STATIC:
            //{{{ static [public]
                                     modifierToken = jj_consume_token(STATIC);
                                 modifiers.add(new Modifier(modifierToken));
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PUBLIC:
              try {
                modifierToken = jj_consume_token(PUBLIC);
                                         modifiers.add(new Modifier(modifierToken));
              } catch (ParseException e) {
                                 fireParseError("public or function token expected","public|function",e.currentToken.next);
              }
              break;
            default:
              jj_la1[20] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[21] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        methodDeclaration = interfaceMethodDeclaration(modifiers);
                         interfaceDeclaration.add(methodDeclaration);
        break;
      case CONST:
        classConstants = classConstant();
                         for (ClassConstant classConstant : classConstants)
                         {
                                 interfaceDeclaration.addConstant(classConstant);
                         }
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    try {
      rBraceToken = jj_consume_token(RBRACE);
                        interfaceDeclaration.setSourceEnd(rBraceToken.sourceEnd);
                        interfaceDeclaration.setEndLine(rBraceToken.endLine);
                        interfaceDeclaration.setEndColumn(rBraceToken.endColumn);
    } catch (ParseException e) {
                fireParseError("} expected","}",e.currentToken.next);
    }
                currentSegment = interfaceDeclaration.getParent();
                scope = scopeStack.pop();
                {if (true) return interfaceDeclaration;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ classConstant() method
  final public List<ClassConstant> classConstant() throws ParseException {
        Token constToken, token;
        String constName = SYNTAX_ERROR_CHAR;
        List<ClassConstant> constants = new ArrayList<ClassConstant>();
        ClassConstant classConstant;
    constToken = jj_consume_token(CONST);
    classConstant = _classConstant(constToken);
                constants.add(classConstant);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_8;
      }
      token = jj_consume_token(COMMA);
      classConstant = _classConstant(token);
                        constants.add(classConstant);
    }
    try {
      token = jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                fireParseError("';' expected",";",e.currentToken.next);
    }
                {if (true) return constants;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ _classConstant() method
  final public ClassConstant _classConstant(Token startToken) throws ParseException {
        Token identifier;
        Token token;
        String constName = SYNTAX_ERROR_CHAR;
        Expression initializer = null;
        int end, endLine, endColumn;
                end = startToken.sourceEnd;
                endLine = startToken.endLine;
                endColumn = startToken.endColumn;
    try {
      identifier = methodIdentifier();
                        startToken = identifier;
                        constName = identifier.image;
                        end = identifier.sourceEnd;
                        endLine = identifier.endLine;
                        endColumn = identifier.endColumn;
    } catch (ParseException e) {
                fireParseError("constant expected","constant",e.currentToken.next);
    }
    try {
      token = jj_consume_token(ASSIGN);
                        end = token.sourceEnd;
                        endLine = token.endLine;
                        endColumn = token.endColumn;
    } catch (ParseException e) {
                fireParseError("'=' expected","=",e.currentToken.next);
    }
    try {
      initializer = VariableInitializer();
                        end = initializer.getSourceEnd();
                        endLine = initializer.getEndLine();
                        endColumn = initializer.getEndColumn();
    } catch (ParseException e) {
                fireParseError("expression expected","expression",e.currentToken.next);
    }
                {if (true) return new ClassConstant(namespace,
                        path,
                        currentSegment,
                        constName,
                        initializer,
                        startToken.sourceStart,
                        end,
                        startToken.beginLine,
                        endLine,
                        startToken.beginColumn,
                        endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}


//{{{ interfaceMethodDeclaration(Liscodifiers)
/**
 * A Method Declaration.
 * <b>function</b> MetodDeclarator() Block()
 *
 * @return a MethodDeclaration
 */
  final public MethodDeclaration interfaceMethodDeclaration(List<Modifier> modifiers) throws ParseException {
        MethodDeclaration functionDeclaration;
        MethodHeader methodHeader;
        Token functionToken;
    functionToken = jj_consume_token(FUNCTION);
    methodHeader = methodHeader(functionToken,CONST_METHOD, modifiers);
                functionDeclaration = new MethodDeclaration(currentSegment,methodHeader);
    try {
      jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                fireParseError("unexpected token : "+e.currentToken.image, ";",
                               e.currentToken);
    }
                {if (true) return functionDeclaration;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ Class methods

//{{{ classDeclaration()
/**
 * A Class declaration.
 * class <IDENTIFIER> [extends <IDENTIFIER>] Class body
 *
 * @return a ClassDeclaration
 */
  final public ClassDeclaration classDeclaration() throws ParseException {
        ClassHeader classHeader;
        ClassDeclaration classDeclaration;
        Token abstractToken = null;
        Token finalToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
      abstractToken = jj_consume_token(ABSTRACT);
      classHeader = classHeader(abstractToken);
                classDeclaration = new ClassDeclaration(currentSegment,
                        classHeader,
                        classHeader.getSourceStart(),
                        classHeader.getSourceEnd(),
                        classHeader.getBeginLine(),
                        classHeader.getEndLine(),
                        classHeader.getBeginColumn(),
                        classHeader.getEndColumn());
                currentSegment.add(classDeclaration);
                currentSegment = classDeclaration;
                scope = new Scope();
                scopeStack.push(scope);
      abstractClassBody(classDeclaration);
                currentSegment = currentSegment.getParent();
                scope = scopeStack.pop();
                pushOnAstNodes(classDeclaration);
                {if (true) return classDeclaration;}
      break;
    case FINAL:
    case CLASS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FINAL:
        finalToken = jj_consume_token(FINAL);
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      classHeader = classHeader(finalToken);
                if (finalToken != null)
                {
                        classHeader.addModifier(new Modifier(finalToken));
                }
                classDeclaration = new ClassDeclaration(currentSegment,
                        classHeader,
                        classHeader.getSourceStart(),
                        classHeader.getSourceEnd(),
                        classHeader.getBeginLine(),
                        classHeader.getEndLine(),
                        classHeader.getBeginColumn(),
                        classHeader.getEndColumn());
                currentSegment.add(classDeclaration);
                currentSegment = classDeclaration;
                scope = new Scope();
                scopeStack.push(scope);
      classBody(classDeclaration);
                currentSegment = currentSegment.getParent();
                scope = scopeStack.pop();
                pushOnAstNodes(classDeclaration);
                {if (true) return classDeclaration;}
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ classHeader(Token abstractToken)
  final public ClassHeader classHeader(Token abstractToken) throws ParseException {
        Token classToken;
        Token className = null;
        Token superclassName = null;
        Token firstToken = abstractToken;
        List<InterfaceIdentifier> interfaces = null;
    try {
      classToken = jj_consume_token(CLASS);
                        if (firstToken == null) firstToken = classToken;
    } catch (ParseException e) {
                fireParseError("identifier expected","identifier", e.currentToken.next);
    }
    try {
      className = jj_consume_token(IDENTIFIER);
    } catch (ParseException e) {
                fireParseError("identifier expected","identifier",e.currentToken.next);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      try {
        superclassName = superClassOrInterface();
      } catch (ParseException e) {
                //{{{ Parse error
                fireParseError("identifier expected", "identifier", e.currentToken.next);
                error_skipto(LBRACE);//}}}

      }
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      jj_consume_token(IMPLEMENTS);
                        interfaces = new ArrayList<InterfaceIdentifier>();
                        Token interfaceToken;
      try {
        interfaceToken = superClassOrInterface();
                                interfaces.add(new InterfaceIdentifier(interfaceToken));
      } catch (ParseException e) {
                        fireParseError("interface identifier expected", "identifier", e.currentToken.next);
      }
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        try {
          interfaceToken = superClassOrInterface();
                                        interfaces.add(new InterfaceIdentifier(interfaceToken));
        } catch (ParseException e) {
                                fireParseError("interface identifier expected", "identifier", e.currentToken.next);
        }
      }
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
                int end,endLine,endColumn;
                if (interfaces != null && !interfaces.isEmpty())
                {
                        InterfaceIdentifier id = interfaces.get(interfaces.size() - 1);
                        end = id.getSourceEnd();
                        endLine = id.getEndLine();
                        endColumn = id.getEndColumn();
                }
                else
                {
                        if (superclassName != null)
                        {
                                end = superclassName.sourceEnd;
                                endLine = superclassName.endLine;
                                endColumn = superclassName.endColumn;
                        }
                        else
                        {
                                if (className == null)
                                {
                                        end         = firstToken.sourceEnd;
                                        endLine     = firstToken.endLine;
                                        endColumn   = firstToken.endColumn;
                                }
                                else
                                {
                                        end         = className.sourceEnd;
                                        endLine     = className.endLine;
                                        endColumn   = className.endColumn;
                                }
                        }
                }

                {if (true) return new ClassHeader(namespace,
                                       path,
                                       className == null ? null : new ClassIdentifier(className),
                                       superclassName == null ? null : new ClassIdentifier(superclassName),
                                       interfaces,
                                       firstToken.sourceStart,
                                       end,
                                       firstToken.beginLine,
                                       endLine,
                                       firstToken.beginColumn,
                                       endColumn);}
    throw new Error("Missing return statement in function");
  }

 //}}}

//{{{ classBody(ClassDeclaration classDeclaration)
  final public void classBody(ClassDeclaration classDeclaration) throws ParseException {
        Token lBraceToken;
        Token rBraceToken;
    try {
      lBraceToken = jj_consume_token(LBRACE);
                        classDeclaration.setBodyLineStart(lBraceToken.beginLine);
                        classDeclaration.setBodyColumnStart(lBraceToken.beginColumn);
    } catch (ParseException e) {
                fireParseError("'{' expected", "{", e.currentToken);
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
      case PROTECTED:
      case PRIVATE:
      case ABSTRACT:
      case FINAL:
      case FUNCTION:
      case VAR:
      case STATIC:
      case CONST:
      case DOLLAR:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_10;
      }
      classBodyDeclaration(classDeclaration);
    }
    try {
      rBraceToken = jj_consume_token(RBRACE);
                        classDeclaration.setBodyLineEnd(rBraceToken.endLine);
                        classDeclaration.setBodyColumnEnd(rBraceToken.endColumn);
    } catch (ParseException e) {
                fireParseError("'}' expected", "}", e.currentToken.next);
                rBraceToken = error_skipto(RBRACE);
                classDeclaration.setBodyLineEnd(rBraceToken.endLine);
                classDeclaration.setBodyColumnEnd(rBraceToken.endColumn);
    }
  }

  //}}}

//{{{ abstractClassBody(ClassDeclaration classDeclaration)
  final public void abstractClassBody(ClassDeclaration classDeclaration) throws ParseException {
  Token lBraceToken;
  Token rBraceToken;
    try {
      lBraceToken = jj_consume_token(LBRACE);
      classDeclaration.setBodyLineStart(lBraceToken.beginLine);
      classDeclaration.setBodyColumnStart(lBraceToken.beginColumn);
    } catch (ParseException e) {
    //{{{ Parse error
    fireParseError(new PHPParseErrorEvent(ERROR,
                                          path,
                                          "'{' expected",
                                          "{",
                                          e.currentToken.image,
                                          e.currentToken.sourceStart,
                                          e.currentToken.sourceEnd,
                                          e.currentToken.beginLine,
                                          e.currentToken.endLine,
                                          e.currentToken.endColumn,
                                          e.currentToken.endColumn+1)); //}}}

    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
      case PROTECTED:
      case PRIVATE:
      case ABSTRACT:
      case FINAL:
      case FUNCTION:
      case VAR:
      case STATIC:
      case CONST:
      case DOLLAR:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_11;
      }
      abstractClassBodyDeclaration(classDeclaration);
    }
    try {
      rBraceToken = jj_consume_token(RBRACE);
      classDeclaration.setBodyLineEnd(rBraceToken.endLine);
      classDeclaration.setBodyColumnEnd(rBraceToken.endColumn);
    } catch (ParseException e) {
    //{{{ Parse error
    fireParseError(new PHPParseErrorEvent(ERROR,
                                          path,
                                          "'}' expected",
                                          "}",
                                          e.currentToken.image,
                                          e.currentToken.sourceStart,
                                          e.currentToken.sourceEnd,
                                          e.currentToken.beginLine,
                                          e.currentToken.endLine,
                                          e.currentToken.endColumn,
                                          e.currentToken.endColumn+1)); //}}}
    rBraceToken = error_skipto(RBRACE);
    classDeclaration.setBodyLineEnd(rBraceToken.endLine);
    classDeclaration.setBodyColumnEnd(rBraceToken.endColumn);
    }
  }

  //}}}

//{{{ classBodyDeclaration(ClassDeclaration classDeclaration)
/**
 * A class can contain only methods and fields.
 */
  final public void classBodyDeclaration(ClassDeclaration classDeclaration) throws ParseException {
        MethodDeclaration method;
        List<FieldDeclaration> fieldList;
        Modifier modifier;
        List<Modifier> modifiers = new ArrayList<Modifier>();
        List<FieldDeclaration> fields;
        List<ClassConstant> classConstants;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      classConstants = classConstant();
                        for (ClassConstant classConstant:classConstants)
                        {
                                classDeclaration.addConstant(classConstant);
                        }
      break;
    case PUBLIC:
    case PROTECTED:
    case PRIVATE:
    case ABSTRACT:
    case FINAL:
    case FUNCTION:
    case STATIC:
    case DOLLAR:
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PUBLIC:
        case PROTECTED:
        case PRIVATE:
        case STATIC:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_12;
        }
        modifier = commonModifiers();
                                modifiers.add(modifier);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOLLAR:
          fields = fieldDeclarationPHP5(modifiers);
                                        for (FieldDeclaration field : fields)
                                                classDeclaration.addField(field);
          break;
        case ABSTRACT:
        case FINAL:
        case FUNCTION:
          label_13:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ABSTRACT:
            case FINAL:
              ;
              break;
            default:
              jj_la1[33] = jj_gen;
              break label_13;
            }
            modifier = methodModifiers();
                                                modifiers.add(modifier);
            label_14:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case PUBLIC:
              case PROTECTED:
              case PRIVATE:
              case STATIC:
                ;
                break;
              default:
                jj_la1[34] = jj_gen;
                break label_14;
              }
              modifier = commonModifiers();
                                                        modifiers.add(modifier);
            }
          }
          method = methodDeclaration(CONST_METHOD,modifiers);
                                        //  method.analyzeCode(this);
                                        classDeclaration.addMethod(method);
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
                        fireParseError("unexpected token " + e.currentToken.image, "", e.currentToken);
      }
      break;
    case VAR:
      fieldList = fieldDeclaration();
                        if (fieldList != null)
                        {
                                for (FieldDeclaration field:fieldList)
                                        classDeclaration.addField(field);
                        }
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  //}}}

//{{{ commonModifiers() method
/**
 * A class can contain only methods and fields.
 */
  final public Modifier commonModifiers() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATIC:
      token = jj_consume_token(STATIC);
      break;
    case PUBLIC:
      token = jj_consume_token(PUBLIC);
      break;
    case PROTECTED:
      token = jj_consume_token(PROTECTED);
      break;
    case PRIVATE:
      token = jj_consume_token(PRIVATE);
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return new Modifier(token);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ methodModifiers()
  final public Modifier methodModifiers() throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINAL:
      token = jj_consume_token(FINAL);
      break;
    case ABSTRACT:
      token = jj_consume_token(ABSTRACT);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return new Modifier(token);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ abstractClassBodyDeclaration(ClassDeclaration classDeclaration)
/**
 * A class can contain only methods and fields.
 */
  final public void abstractClassBodyDeclaration(ClassDeclaration classDeclaration) throws ParseException {
        MethodDeclaration method;
        List<FieldDeclaration> fieldList;
        Modifier modifier;
        List<Modifier> modifiers = new ArrayList<Modifier>();
        List<FieldDeclaration> fields;
        List<ClassConstant> classConstants;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      classConstants = classConstant();
                for (ClassConstant classConstant:classConstants)
                {
                        classDeclaration.addConstant(classConstant);
                }
      break;
    case PUBLIC:
    case PROTECTED:
    case PRIVATE:
    case ABSTRACT:
    case FINAL:
    case FUNCTION:
    case STATIC:
    case DOLLAR:
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PUBLIC:
        case PROTECTED:
        case PRIVATE:
        case STATIC:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_15;
        }
        modifier = commonModifiers();
                        modifiers.add(modifier);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOLLAR:
          fields = fieldDeclarationPHP5(modifiers);
                                for (FieldDeclaration field:fields)
                                        classDeclaration.addField(field);
          break;
        case ABSTRACT:
        case FINAL:
        case FUNCTION:
          label_16:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ABSTRACT:
            case FINAL:
              ;
              break;
            default:
              jj_la1[40] = jj_gen;
              break label_16;
            }
            modifier = methodModifiers();
                                        modifiers.add(modifier);
            label_17:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case PUBLIC:
              case PROTECTED:
              case PRIVATE:
              case STATIC:
                ;
                break;
              default:
                jj_la1[41] = jj_gen;
                break label_17;
              }
              modifier = commonModifiers();
                                                modifiers.add(modifier);
            }
          }
          method = methodDeclaration(CONST_METHOD, modifiers);
                                //method.analyzeCode(this);
                                classDeclaration.addMethod(method);
          break;
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
                fireParseError("unexpected token " + e.currentToken.image, "", e.currentToken);
      }
      break;
    case VAR:
      fieldList = fieldDeclaration();
                if (fieldList != null)
                {
                        for (FieldDeclaration field:fieldList)
                        {
                                classDeclaration.addField(field);
                        }
                }
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  //}}}

//{{{ fieldDeclaration()
/**
 * A class field declaration : it's var VariableDeclarator() (, VariableDeclarator())*;.
 * it is only used by classBodyDeclaration()
 */
  final public List<FieldDeclaration> fieldDeclaration() throws ParseException {
        List<FieldDeclaration> arrayList;
    jj_consume_token(VAR);
                fireParseMessage(new PHPParseMessageEvent(INFO,
                        WarningMessageClass.varToken,
                        path,
                        "The var token is deprecated in php 5",
                        token));
    //}}}
            arrayList = fieldDeclarationPHP5(null);
                {if (true) return arrayList;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ fieldDeclarationPHP5()
/**
 * A class field declaration : it's var VariableDeclarator() (, VariableDeclarator())*;.
 * it is only used by ClassBodyDeclaration()
 */
  final public List<FieldDeclaration> fieldDeclarationPHP5(List<Modifier> modifiers) throws ParseException {
        VariableDeclaration variableDeclaration;
        List<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
    try {
      variableDeclaration = field();
                        fields.add(new FieldDeclaration(namespace,
                                currentSegment,
                                modifiers,
                                path,
                                variableDeclaration));
    } catch (ParseException e) {
                Token semicolon = error_skipto(SEMICOLON);
                fireParseError("field declaration expected","field declaration",semicolon);
    }
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      try {
        variableDeclaration = field();
                                fields.add(new FieldDeclaration(namespace,
                                        currentSegment,
                                        modifiers,
                                        path,
                                        variableDeclaration));
      } catch (ParseException e) {
                        Token semicolon = error_skipto(SEMICOLON);
                        fireParseError("field declaration expected","field declaration",semicolon);
      }
    }
    try {
      jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                Token semicolon = error_skipto(SEMICOLON);
                fireParseError("semicolon expected",";",e.currentToken);
    }
                {if (true) return fields;}
    throw new Error("Missing return statement in function");
  }

 //}}}

//}}}

//{{{ Variables

//{{{ field() method
/**
 * One field declaration
 */
  final public VariableDeclaration field() throws ParseException {
        Token identifierToken, lbrace,rbrace;
        Expression expr;
        Expression initializer = null;
        Token assignToken = null;
        Token dollarToken;
        Variable variable;
    dollarToken = jj_consume_token(DOLLAR);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASS:
      case FUNCTION:
      case VAR:
      case IF:
      case ELSEIF:
      case ELSE:
      case BREAK:
      case _DEFAULT:
      case NEW:
      case CLONE:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case IDENTIFIER:
        identifierToken = methodIdentifier();
                                variable = new Variable(identifierToken.image,
                                        dollarToken.sourceStart,
                                        identifierToken.sourceEnd,
                                        dollarToken.beginLine,
                                        identifierToken.endLine,
                                        dollarToken.beginColumn,
                                        identifierToken.endColumn);
        break;
      case LBRACE:
        lbrace = jj_consume_token(LBRACE);
        expr = Expression();
        rbrace = jj_consume_token(RBRACE);
                                variable = new Variable(expr,
                                        lbrace.sourceStart,
                                        rbrace.sourceEnd,
                                        lbrace.beginLine,
                                        rbrace.endLine,
                                        lbrace.beginColumn,
                                        rbrace.endColumn);
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
                fireParseError("identifier expected", "", e.currentToken);
                variable = new Variable("",
                        e.currentToken.sourceStart,
                        e.currentToken.sourceEnd,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.beginColumn,
                        e.currentToken.endColumn);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      assignToken = jj_consume_token(ASSIGN);
      try {
        initializer = VariableInitializer();
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "Literal expression expected in variable initializer",
                                "literal",
                                e.currentToken.image,
                                assignToken.sourceEnd,
                                assignToken.sourceEnd +1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
                setTypeFromScope(variable);
                if (assignToken == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment, variable);}
                }
                if (initializer == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment,
                                variable,
                                null,
                                "=",
                                variable.getSourceStart(),
                                assignToken.sourceEnd,
                                variable.getBeginLine(),
                                assignToken.endLine,
                                variable.getBeginColumn(),
                                assignToken.endColumn);}
                }
                {if (true) return new VariableDeclaration(currentSegment,
                        variable,
                        initializer,
                        "=",
                        variable.getSourceStart(),
                        initializer.getSourceEnd(),
                        variable.getBeginLine(),
                        initializer.getEndLine(),
                        variable.getBeginColumn(),
                        initializer.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ VariableDeclaratorNoSuffix()
/**
 * a strict variable declarator : there cannot be a suffix here.
 * It will be used by fields and formal parameters
 */
  final public VariableDeclaration VariableDeclaratorNoSuffix() throws ParseException {
        Token identifierToken, lbrace,rbrace;
        Expression expr;
        Expression initializer = null;
        Token assignToken = null;
        Token dollarToken;
        Variable variable;
    dollarToken = jj_consume_token(DOLLAR);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        identifierToken = jj_consume_token(IDENTIFIER);
                                variable = new Variable(identifierToken.image,
                                        dollarToken.sourceStart,
                                        identifierToken.sourceEnd,
                                        dollarToken.beginLine,
                                        identifierToken.endLine,
                                        dollarToken.beginColumn,
                                        identifierToken.endColumn);
        break;
      case LBRACE:
        lbrace = jj_consume_token(LBRACE);
        expr = Expression();
        rbrace = jj_consume_token(RBRACE);
                                variable = new Variable(expr,
                                        lbrace.sourceStart,
                                        rbrace.sourceEnd,
                                        lbrace.beginLine,
                                        rbrace.endLine,
                                        lbrace.beginColumn,
                                        rbrace.endColumn);
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
                fireParseError("identifier expected", "", e.currentToken);
                variable = new Variable("",
                        e.currentToken.sourceStart,
                        e.currentToken.sourceEnd,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.beginColumn,
                        e.currentToken.endColumn);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      assignToken = jj_consume_token(ASSIGN);
      try {
        initializer = VariableInitializer();
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "Literal expression expected in variable initializer",
                                "literal",
                                e.currentToken.image,
                                assignToken.sourceEnd,
                                assignToken.sourceEnd +1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
                setTypeFromScope(variable);
                if (assignToken == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment,
                                variable);}
                }
                if (initializer == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment,
                                variable,
                                null,
                                "=",
                                variable.getSourceStart(),
                                assignToken.sourceEnd,
                                variable.getBeginLine(),
                                assignToken.endLine,
                                variable.getBeginColumn(),
                                assignToken.endColumn);}
                }
                {if (true) return new VariableDeclaration(currentSegment,
                        variable,
                        initializer,
                        "=",
                        variable.getSourceStart(),
                        initializer.getSourceEnd(),
                        variable.getBeginLine(),
                        initializer.getEndLine(),
                        variable.getBeginColumn(),
                        initializer.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ VariableDeclarator()
/**
 * this will be used by static statement
 */
  final public VariableDeclaration VariableDeclarator() throws ParseException {
        AbstractVariable variable;
        Expression initializer = null;
        Token assignToken = null;
    variable = VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      assignToken = jj_consume_token(ASSIGN);
      try {
        initializer = VariableInitializer();
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "Literal expression expected in variable initializer",
                                "literal",
                                e.currentToken.image,
                                token.sourceEnd,
                                token.sourceEnd+1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
                if (assignToken == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment,
                                variable);}
                }
                if (initializer == null)
                {
                        {if (true) return new VariableDeclaration(currentSegment,
                                variable,
                                null,
                                "=",
                                variable.getSourceStart(),
                                assignToken.sourceEnd,
                                variable.getBeginLine(),
                                assignToken.endLine,
                                variable.getBeginColumn(),
                                assignToken.endColumn);}
                }
                {if (true) return new VariableDeclaration(currentSegment,
                        variable,
                        initializer,
                        "=",
                        variable.getSourceStart(),
                        initializer.getSourceEnd(),
                        variable.getBeginLine(),
                        initializer.getEndLine(),
                        variable.getBeginColumn(),
                        initializer.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ VariableDeclaratorId()
/**
 * A Variable name.
 * @return the variable name (with suffix)
 */
  final public AbstractVariable VariableDeclaratorId() throws ParseException {
        AbstractVariable var;
    var = Variable();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASSACCESS:
      case STATICCLASSACCESS:
      case LBRACKET:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[50] = jj_gen;
        break label_19;
      }
      var = VariableSuffix(var);
    }
                {if (true) return var;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ Variable()
  final public Variable Variable() throws ParseException {
        Variable variable;
        Token dollarToken;
    dollarToken = jj_consume_token(DOLLAR);
    try {
      variable = Var();
    } catch (ParseException e) {
                fireParseError("'variable' expected","=",e.currentToken);
                variable = new  Variable("",
                        dollarToken.sourceStart,
                        e.currentToken.next.sourceStart,
                        dollarToken.beginLine,
                        e.currentToken.next.beginLine,
                        dollarToken.beginColumn,
                        e.currentToken.next.beginColumn);
    }
                {if (true) return variable;}
    throw new Error("Missing return statement in function");
  }

//}}}

//{{{ Var()
  final public Variable Var() throws ParseException {
        Variable variable;
        Token token, token2;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      //{{{ <DOLLAR>
                      token = jj_consume_token(DOLLAR);
      variable = Var();
                        fireParseMessage(new PHPParseMessageEvent(INFO,
                                WarningMessageClass.doubledollar,
                                path,
                                "You have several $$, this may be a bug",
                                token.sourceStart,
                                token.sourceEnd,
                                token.beginLine,
                                token.endLine,
                                token.beginColumn,
                                token.endColumn));
                        variable = new Variable(variable,
                                variable.getSourceStart(),
                                variable.getSourceEnd(),
                                variable.getBeginLine(),
                                variable.getEndLine(),
                                variable.getBeginColumn(),
                                variable.getBeginColumn());
      break;
    case LBRACE:
      token = jj_consume_token(LBRACE);
      expression = Expression();
      token2 = jj_consume_token(RBRACE);
                        variable = new Variable(expression,
                                token.sourceStart,
                                token2.sourceEnd,
                                token.beginLine,
                                token2.endLine,
                                token.beginColumn,
                                token2.endColumn);
      break;
    case IDENTIFIER:
      token = jj_consume_token(IDENTIFIER);
                        variable = new Variable(token);
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                setTypeFromScope(variable);
                {if (true) return variable;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ VariableInitializer()
  final public Expression VariableInitializer() throws ParseException {
  Expression expr;
    if (jj_2_1(2)) {
      expr = Literal();
    {if (true) return expr;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
          Token value;
          Token operator;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          operator = jj_consume_token(PLUS);
          break;
        case MINUS:
          operator = jj_consume_token(MINUS);
          break;
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
          value = jj_consume_token(INTEGER_LITERAL);
          break;
        case FLOATING_POINT_LITERAL:
          value = jj_consume_token(FLOATING_POINT_LITERAL);
          break;
        default:
          jj_la1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
    {if (true) return new PrefixedUnaryExpression(new NumberLiteral(Type.INTEGER,value),
                                       operator);}
        break;
      case ARRAY:
        //{{{ array
          expr = ArrayDeclarator();
          {if (true) return expr;}
        break;
      case CLASS:
      case FUNCTION:
      case VAR:
      case IF:
      case ELSEIF:
      case ELSE:
      case BREAK:
      case _DEFAULT:
      case NEW:
      case CLONE:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case DOLLAR:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CLASS:
        case FUNCTION:
        case VAR:
        case IF:
        case ELSEIF:
        case ELSE:
        case BREAK:
        case _DEFAULT:
        case NEW:
        case CLONE:
        case DEFINE:
        case GOTO:
        case NULL:
        case SUPER:
        case THIS:
        case TRUE:
        case FALSE:
        case STRING:
        case OBJECT:
        case BOOL:
        case BOOLEAN:
        case REAL:
        case DOUBLE:
        case FLOAT:
        case INT:
        case INTEGER:
        case IDENTIFIER:
          expr = classIdentifier();
          label_20:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CLASSACCESS:
            case STATICCLASSACCESS:
            case LBRACKET:
            case LBRACE:
              ;
              break;
            default:
              jj_la1[54] = jj_gen;
              break label_20;
            }
            expr = VariableSuffix(expr);
          }
          break;
        case DOLLAR:
          expr = VariableDeclaratorId();
          break;
        default:
          jj_la1[55] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      {if (true) return expr;}
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  //}}}


//}}}

//{{{ Arrays

//{{{ ArrayVariable()
  final public ArrayVariableDeclaration ArrayVariable() throws ParseException {
Expression expr,expr2;
Token arrayAssignToken;
    expr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAYASSIGN:
      arrayAssignToken = jj_consume_token(ARRAYASSIGN);
      expr2 = Expression();
      int sourceEnd,endLine,endColumn;
      if (expr2 == null) {
        sourceEnd = arrayAssignToken.sourceEnd;
        endLine   = arrayAssignToken.endLine;
        endColumn = arrayAssignToken.endColumn;
      } else {
        sourceEnd = expr2.getSourceEnd();
        endLine   = expr2.getEndLine();
        endColumn = expr2.getEndColumn();
      }

      {if (true) return new ArrayVariableDeclaration(expr,expr2,expr.getSourceStart(),sourceEnd,expr.getBeginLine(),endLine,expr.getBeginColumn(),endColumn);}
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    {if (true) return new ArrayVariableDeclaration(expr,expr.getSourceEnd(),expr.getBeginLine(),expr.getEndLine(),expr.getBeginColumn(),expr.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

//}}}

//{{{ ArrayInitializer()
  final public ArrayVariableDeclaration[] ArrayInitializer() throws ParseException {
        ArrayVariableDeclaration expr;
        List<ArrayVariableDeclaration> list = new ArrayList<ArrayVariableDeclaration>();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = ArrayVariable();
                        list.add(expr);
      label_21:
      while (true) {
        if (jj_2_2(2)) {
          ;
        } else {
          break label_21;
        }
        jj_consume_token(COMMA);
        expr = ArrayVariable();
                                list.add(expr);
      }
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
                         list.add(null);
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                ArrayVariableDeclaration[] vars = new ArrayVariableDeclaration[list.size()];
                list.toArray(vars);
                {if (true) return vars;}
    throw new Error("Missing return statement in function");
  }

  //}}}


//}}}

//{{{ METHODS

//{{{ methodDeclaration()
/**
 * A Method Declaration.
 * <b>function</b> MetodDeclarator() Block()
 *
 * @return a MethodDeclaration
 */
  final public MethodDeclaration methodDeclaration(int type, List<Modifier> modifiers) throws ParseException {
        MethodDeclaration functionDeclaration;
        MethodHeader methodHeader;
        Block block;
        Outlineable seg = currentSegment;
        Token functionToken;
        Token semicolon;
    functionToken = jj_consume_token(FUNCTION);
    methodHeader = methodHeader(functionToken,type, modifiers);
                functionDeclaration = new MethodDeclaration(currentSegment,methodHeader);
                currentSegment = functionDeclaration;
                scope = new Scope();
                scopeStack.push(scope);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        block = Block();
                                functionDeclaration.setStatements(block.getStatements());
                                functionDeclaration.setBodyLineStart(block.getBeginLine());
                                functionDeclaration.setBodyColumnStart(block.getBeginColumn());
                                functionDeclaration.setBodyLineEnd(block.getEndLine());
                                functionDeclaration.setBodyColumnEnd(block.getEndColumn());
        break;
      case SEMICOLON:
        semicolon = jj_consume_token(SEMICOLON);
                                functionDeclaration.setBodyLineStart(semicolon.beginLine);
                                functionDeclaration.setBodyColumnStart(semicolon.beginColumn);
                                functionDeclaration.setBodyLineEnd(semicolon.endLine);
                                functionDeclaration.setBodyColumnEnd(semicolon.endColumn);
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
                fireParseError("expected function body","function body",e.currentToken.next);
    }
                currentSegment = seg;
                scope = new Scope();
                scopeStack.push(scope);
                {if (true) return functionDeclaration;}
    throw new Error("Missing return statement in function");
  }

 //}}}

//{{{ closureDeclaration()
  final public MethodDeclaration closureDeclaration() throws ParseException {
        MethodDeclaration functionDeclaration;
        List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
        MethodHeader methodHeader;
        Block block;
        Outlineable seg = currentSegment;
        Token functionToken;
        Token use;
        ArgumentList useArguments = null;
    functionToken = jj_consume_token(FUNCTION);
    formalParameters(formalParameters);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USE:
      use = jj_consume_token(USE);
      try {
        useArguments = arguments();
      } catch (ParseException e) {
                        fireParseError("arguments list expected","($a,$b)",e.currentToken.next);
                        error_skipto(LBRACE);
      }
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
                methodHeader = new MethodHeader(namespace,
                        path,
                        null,
                        "",
                        false,
                        useArguments,
                        formalParameters,
                        functionToken.sourceStart,
                        token.sourceEnd,
                        functionToken.beginLine,
                        token.endLine,
                        functionToken.beginColumn,
                        token.endColumn);
                functionDeclaration = new MethodDeclaration(currentSegment,methodHeader);
                currentSegment = functionDeclaration;
                scope = new Scope();
                scopeStack.push(scope);
    block = Block();
                functionDeclaration.setStatements(block.getStatements());
                functionDeclaration.setBodyLineStart(block.getBeginLine());
                functionDeclaration.setBodyColumnStart(block.getBeginColumn());
                functionDeclaration.setBodyLineEnd(block.getEndLine());
                functionDeclaration.setBodyColumnEnd(block.getEndColumn());
                currentSegment = seg;
                scope = new Scope();
                scopeStack.push(scope);
                {if (true) return functionDeclaration;}
    throw new Error("Missing return statement in function");
  }

 //}}}

//{{{ methodHeader()
/**
 * A MethodDeclarator.
 * [&] IDENTIFIER(parameters ...).
 *
 * @return a function description for the outline
 */
  final public MethodHeader methodHeader(Token functionToken,int type, List<Modifier> modifiers) throws ParseException {
        Token reference = null;
        List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
        Token methodNameToken;
        String identifierChar = SYNTAX_ERROR_CHAR;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIT_AND:
      reference = jj_consume_token(BIT_AND);
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
                try
                {
                        if (type == CONST_FUNCTION)
                        {
                                methodNameToken = functionIdentifier();
                        }
                        else
                        {
                                methodNameToken = methodIdentifier();
                        }
                        identifierChar = methodNameToken.image;
                }
                catch (ParseException e)
                {
                        if (e.currentToken.next.kind == LPAREN)
                        {
                                //{{{ Parse error
                                fireParseError(new PHPParseErrorEvent(ERROR,
                                                                      path,
                                                                      "identifier expected",
                                                                      "identifier",
                                                                      e.currentToken.image,
                                                                      functionToken.sourceStart,
                                                                      e.currentToken.sourceStart,
                                                                      e.currentToken.beginLine,
                                                                      e.currentToken.endLine,
                                                                      e.currentToken.beginColumn-1,
                                                                      e.currentToken.endColumn)); //}}}
                        }
                        else
                        {
                                fireParseError("unexpected token","identifier",e.currentToken.next);
                        }
                }
    formalParameters(formalParameters);
                {if (true) return new MethodHeader(namespace,
                                        path,
                                        modifiers,
                                        identifierChar,
                                        reference != null,
                                        null,// use
                                        formalParameters,
                                        functionToken.sourceStart,
                                        token.sourceEnd,
                                        functionToken.beginLine,
                                        token.endLine,
                                        functionToken.beginColumn,
                                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ functionIdentifier()
/**
 * This is a function identifier.
 * It's not exactly the same as methodIdentifier since methods can use a lot of keywords for their names.
 *
 * @return an identifier for a function
 */
  final public Token functionIdentifier() throws ParseException {
        Token functionIdentifier;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      functionIdentifier = jj_consume_token(IDENTIFIER);
      break;
    case NULL:
      functionIdentifier = jj_consume_token(NULL);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return functionIdentifier;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ methodIdentifier()
/**
 * This is a method identifier.
 * It can returns a lot of keywords since those are allowed (but discouraged for method names).
 *
 * @return an identifier for a function
 */
  final public Token methodIdentifier() throws ParseException {
        Token methodIdentifier;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      methodIdentifier = jj_consume_token(IDENTIFIER);
      break;
    case DEFINE:
      methodIdentifier = jj_consume_token(DEFINE);
      break;
    case GOTO:
      methodIdentifier = jj_consume_token(GOTO);
      break;
    case NEW:
      methodIdentifier = jj_consume_token(NEW);
      break;
    case SUPER:
      methodIdentifier = jj_consume_token(SUPER);
      break;
    case THIS:
      methodIdentifier = jj_consume_token(THIS);
      break;
    case TRUE:
      methodIdentifier = jj_consume_token(TRUE);
      break;
    case FALSE:
      methodIdentifier = jj_consume_token(FALSE);
      break;
    case STRING:
      methodIdentifier = jj_consume_token(STRING);
      break;
    case OBJECT:
      methodIdentifier = jj_consume_token(OBJECT);
      break;
    case BOOL:
      methodIdentifier = jj_consume_token(BOOL);
      break;
    case BOOLEAN:
      methodIdentifier = jj_consume_token(BOOLEAN);
      break;
    case REAL:
      methodIdentifier = jj_consume_token(REAL);
      break;
    case DOUBLE:
      methodIdentifier = jj_consume_token(DOUBLE);
      break;
    case FLOAT:
      methodIdentifier = jj_consume_token(FLOAT);
      break;
    case INT:
      methodIdentifier = jj_consume_token(INT);
      break;
    case INTEGER:
      methodIdentifier = jj_consume_token(INTEGER);
      break;
    case CLASS:
      methodIdentifier = jj_consume_token(CLASS);
      break;
    case _DEFAULT:
      methodIdentifier = jj_consume_token(_DEFAULT);
      break;
    case FUNCTION:
      methodIdentifier = jj_consume_token(FUNCTION);
      break;
    case VAR:
      methodIdentifier = jj_consume_token(VAR);
      break;
    case IF:
      methodIdentifier = jj_consume_token(IF);
      break;
    case ELSEIF:
      methodIdentifier = jj_consume_token(ELSEIF);
      break;
    case ELSE:
      methodIdentifier = jj_consume_token(ELSE);
      break;
    case BREAK:
      methodIdentifier = jj_consume_token(BREAK);
      break;
    case NULL:
      methodIdentifier = jj_consume_token(NULL);
      break;
    case CLONE:
      methodIdentifier = jj_consume_token(CLONE);
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return methodIdentifier;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ constantIdentifier()
/**
 * This is a constant identifier.
 * It can returns a lot of keywords
 *
 * @return an identifier for a function
 */
  final public Token constantIdentifier() throws ParseException {
        Token constantIdentifier;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_IDENTIFIER:
      constantIdentifier = jj_consume_token(NAMESPACE_IDENTIFIER);
      break;
    case IDENTIFIER:
      constantIdentifier = jj_consume_token(IDENTIFIER);
      break;
    case DEFINE:
      constantIdentifier = jj_consume_token(DEFINE);
      break;
    case SUPER:
      constantIdentifier = jj_consume_token(SUPER);
      break;
    case THIS:
      constantIdentifier = jj_consume_token(THIS);
      break;
    case STRING:
      constantIdentifier = jj_consume_token(STRING);
      break;
    case OBJECT:
      constantIdentifier = jj_consume_token(OBJECT);
      break;
    case BOOL:
      constantIdentifier = jj_consume_token(BOOL);
      break;
    case BOOLEAN:
      constantIdentifier = jj_consume_token(BOOLEAN);
      break;
    case REAL:
      constantIdentifier = jj_consume_token(REAL);
      break;
    case DOUBLE:
      constantIdentifier = jj_consume_token(DOUBLE);
      break;
    case FLOAT:
      constantIdentifier = jj_consume_token(FLOAT);
      break;
    case INT:
      constantIdentifier = jj_consume_token(INT);
      break;
    case INTEGER:
      constantIdentifier = jj_consume_token(INTEGER);
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return constantIdentifier;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ formalParameters(List parameters)
/**
 * formalParameters follows method identifier.
 * (formalParameter())
 */
  final public void formalParameters(List<FormalParameter> parameters) throws ParseException {
        FormalParameter var;
    try {
      jj_consume_token(LPAREN);
    } catch (ParseException e) {
                fireParseError("'(' expected", "(",e.currentToken);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case BIT_AND:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
      try {
        var = formalParameter();
                                parameters.add(var);
      } catch (ParseException e) {
                        fireParseError("parameter expected",
                                        "parameter",e.currentToken);
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[66] = jj_gen;
          break label_22;
        }
        jj_consume_token(COMMA);
        try {
          var = formalParameter();
                                        parameters.add(var);
        } catch (ParseException e) {
                                fireParseError("parameter expected",
                                        "parameter",e.currentToken);
        }
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    try {
      jj_consume_token(RPAREN);
    } catch (ParseException e) {
          //recup rparen si avant lbrace
                Token nextToken = getNextToken();
                while (nextToken.kind != EOF && nextToken.kind != RPAREN && nextToken.kind != LBRACE)
                {
                        nextToken = getNextToken();
                }
                if (nextToken.kind == EOF)
                {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "unexpected end of file",
                                ")",
                                e.currentToken.next.image,
                                e.currentToken.sourceEnd,
                                nextToken.sourceStart,
                                e.currentToken.beginLine,
                                nextToken.endLine,
                                e.currentToken.endColumn,
                                nextToken.endColumn));
                }
                else if (nextToken.kind == RPAREN)
                {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "unexpected tokens",
                                "",
                                e.currentToken.next.image,
                                e.currentToken.next.sourceEnd,
                                nextToken.sourceStart,
                                e.currentToken.next.beginLine,
                                nextToken.beginLine,
                                e.currentToken.next.endColumn+1,
                                nextToken.beginColumn-1));
                }
                else
                {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "')' expected",
                                ")",
                                e.currentToken.next.image,
                                e.currentToken.sourceEnd,
                                nextToken.sourceStart,
                                e.currentToken.beginLine,
                                nextToken.endLine,
                                e.currentToken.endColumn+1,
                                nextToken.endColumn-1));
                }
    }
  }

  //}}}

//{{{ formalParameter()
/**
 * A formal parameter.
 * $varname[=value] (,$varname[=value])
 */
  final public FormalParameter formalParameter() throws ParseException {
        VariableDeclaration variableDeclaration;
        FormalParameter parameter;
        Token bitAndToken = null;
        ConstantIdentifier typeHint = null;
        int startOffset = -1;
        int startLine = -1;
        int startColumn = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
                        Token typeToken;
        typeToken = superClassOrInterface();
                                typeHint = new ObjectIdentifier(typeToken);
                                startOffset = typeToken.sourceStart;
                                startLine = typeToken.beginLine;
                                startColumn = typeToken.beginColumn;
        break;
      case ARRAY:
        typeToken = jj_consume_token(ARRAY);
                                typeHint = new ConstantIdentifier(typeToken);
                                startOffset = typeToken.sourceStart;
                                startLine = typeToken.beginLine;
                                startColumn = typeToken.beginColumn;
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIT_AND:
      bitAndToken = jj_consume_token(BIT_AND);
                        if (startOffset == -1)
                        {
                                startOffset = bitAndToken.sourceStart;
                                startLine = bitAndToken.beginLine;
                                startColumn = bitAndToken.beginColumn;
                        }
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    variableDeclaration = VariableDeclaratorNoSuffix();
                if (bitAndToken != null)
                {
                        variableDeclaration.setReference(true,
                                bitAndToken.sourceStart,bitAndToken.beginLine,
                                bitAndToken.beginColumn);
                }
                if (startOffset == -1)
                {
                        startOffset = variableDeclaration.getSourceStart();
                        startLine = variableDeclaration.getBeginLine();
                        startColumn = variableDeclaration.getBeginColumn();

                }
                Expression initialization = variableDeclaration.getInitialization();
                if (initialization == null)
                {
                        parameter = new FormalParameter(typeHint,
                                variableDeclaration.getName(),
                                bitAndToken != null,
                                startOffset,
                                variableDeclaration.getSourceEnd(),
                                startLine,
                                variableDeclaration.getEndLine(),
                                startColumn,
                                variableDeclaration.getEndColumn());
                }
                else
                {
                        parameter = new FormalParameter(typeHint,
                                variableDeclaration.getName(),
                                bitAndToken != null,
                                variableDeclaration.getInitialization().toStringExpression(),
                                startOffset,
                                variableDeclaration.getSourceEnd(),
                                startLine,
                                variableDeclaration.getEndLine(),
                                startColumn,
                                variableDeclaration.getEndColumn());
                }
                {if (true) return parameter;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ Type()
  final public ConstantIdentifier Type() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      token = jj_consume_token(STRING);
      break;
    case BOOL:
      token = jj_consume_token(BOOL);
      break;
    case BOOLEAN:
      token = jj_consume_token(BOOLEAN);
      break;
    case REAL:
      token = jj_consume_token(REAL);
      break;
    case DOUBLE:
      token = jj_consume_token(DOUBLE);
      break;
    case FLOAT:
      token = jj_consume_token(FLOAT);
      break;
    case INT:
      token = jj_consume_token(INT);
      break;
    case INTEGER:
      token = jj_consume_token(INTEGER);
      break;
    case OBJECT:
      token = jj_consume_token(OBJECT);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return new ConstantIdentifier(token);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ EXPRESSIONS

//{{{ Expression()
  final public Expression Expression() throws ParseException {
        Expression expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRINT:
      expr = PrintExpression();
      break;
    case ARRAY:
    case LIST:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      try {
        expr = ConditionalExpression();
      } catch (ParseException e) {
                        //{{{ Parse Exception
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "expression expected",
                                "expression",
                                e.currentToken.image,
                                token.sourceEnd,
                                token.sourceEnd,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn)); //}}}
                        {if (true) return new DummyExpression(e.currentToken);}
      }
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ assignment()
  final public Expression assignment() throws ParseException {
        Expression expr;
        Expression initializer;
        Token assignOperator;
    if (jj_2_3(2147483647)) {
      expr = prefixedPrimaryExpression();
      assignOperator = AssignmentOperator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        initializer = assignment();
        break;
      case FUNCTION:
        initializer = closureDeclaration();
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        if (initializer == null)
                        {
                                initializer = new DummyExpression(assignOperator.next);
                        }
                        expr = new Assignment(expr,
                                initializer,
                                assignOperator.kind,
                                expr.getSourceStart(),
                                initializer.getSourceEnd(),
                                expr.getBeginLine(),
                                initializer.getEndLine(),
                                expr.getBeginColumn(),
                                initializer.getEndColumn());
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        expr = InclusiveOrExpression();
        break;
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ prefixedPrimaryExpression()
  final public Expression prefixedPrimaryExpression() throws ParseException {
        Expression expr;
        Token prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BANG:
      prefix = jj_consume_token(BANG);
      expr = prefixedPrimaryExpression();
      break;
    case AT:
      prefix = jj_consume_token(AT);
      expr = prefixedPrimaryExpression();
      break;
    case TILDE:
      prefix = jj_consume_token(TILDE);
      expr = prefixedPrimaryExpression();
      break;
    case ARRAY:
    case LIST:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case SUPER:
    case THIS:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case BIT_AND:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
      expr = primaryExpression();
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (prefix != null)
                        expr = new PrefixedUnaryExpression(expr, prefix);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ AssignmentOperator()
/**
 * Any assignement operator.
 *
 * @return the assignement operator token
 */
  final public Token AssignmentOperator() throws ParseException {
        Token assignOperator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      assignOperator = jj_consume_token(ASSIGN);
      break;
    case STARASSIGN:
      assignOperator = jj_consume_token(STARASSIGN);
      break;
    case SLASHASSIGN:
      assignOperator = jj_consume_token(SLASHASSIGN);
      break;
    case REMASSIGN:
      assignOperator = jj_consume_token(REMASSIGN);
      break;
    case PLUSASSIGN:
      assignOperator = jj_consume_token(PLUSASSIGN);
      break;
    case MINUSASSIGN:
      assignOperator = jj_consume_token(MINUSASSIGN);
      break;
    case LSHIFTASSIGN:
      assignOperator = jj_consume_token(LSHIFTASSIGN);
      break;
    case RSIGNEDSHIFTASSIGN:
      assignOperator = jj_consume_token(RSIGNEDSHIFTASSIGN);
      break;
    case ANDASSIGN:
      assignOperator = jj_consume_token(ANDASSIGN);
      break;
    case XORASSIGN:
      assignOperator = jj_consume_token(XORASSIGN);
      break;
    case ORASSIGN:
      assignOperator = jj_consume_token(ORASSIGN);
      break;
    case DOTASSIGN:
      assignOperator = jj_consume_token(DOTASSIGN);
      break;
    case TILDEEQUAL:
      assignOperator = jj_consume_token(TILDEEQUAL);
      break;
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return assignOperator;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ConditionalExpression()
  final public Expression ConditionalExpression() throws ParseException {
        Expression expr;
        Expression expr2 = null;
        Expression expr3 = null;
    expr = ConditionalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOOK:
      jj_consume_token(HOOK);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        expr3 = Expression();
        break;
      case ARRAY:
      case LIST:
      case PRINT:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        expr2 = Expression();
        jj_consume_token(COLON);
        expr3 = Expression();
        break;
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[78] = jj_gen;
      ;
    }
                if (expr3 == null)
                {
                        {if (true) return expr;}
                }
                ConditionalExpression conditionalExpression = new ConditionalExpression(expr,expr2,expr3);
                //conditionalExpression.analyzeCode(this);
                {if (true) return conditionalExpression;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ConditionalOrExpression()
  final public Expression ConditionalOrExpression() throws ParseException {
        Expression expr,expr2;
        int sourceEnd,endLine,endColumn;
        Token orToken;
    expr = ConditionalAndExpression();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR_OR:
      case _ORL:
      case XOR:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_23;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR_OR:
        orToken = jj_consume_token(OR_OR);
        break;
      case _ORL:
        orToken = jj_consume_token(_ORL);
        break;
      case XOR:
        orToken = jj_consume_token(XOR);
        break;
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = ConditionalAndExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = orToken.sourceEnd;
                                endLine   = orToken.endLine;
                                endColumn = orToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,orToken.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ConditionalAndExpression()
  final public Expression ConditionalAndExpression() throws ParseException {
        Expression expr,expr2;
        int sourceEnd,endLine,endColumn;
        Token andToken;
    expr = ConcatExpression();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND_AND:
      case _ANDL:
        ;
        break;
      default:
        jj_la1[81] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND_AND:
        andToken = jj_consume_token(AND_AND);
        break;
      case _ANDL:
        andToken = jj_consume_token(_ANDL);
        break;
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = ConcatExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = andToken.sourceEnd;
                                endLine   = andToken.endLine;
                                endColumn = andToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,andToken.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ConcatExpression()
  final public Expression ConcatExpression() throws ParseException {
        Expression expr,expr2;
        Token dotToken;
        int sourceEnd,endLine,endColumn;
    expr = assignment();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_25;
      }
      dotToken = jj_consume_token(DOT);
      expr2 = assignment();
                        if (expr2 == null)
                        {
                                sourceEnd = dotToken.sourceEnd;
                                endLine   = dotToken.endLine;
                                endColumn = dotToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,
                                DOT,expr.getSourceStart(),
                                sourceEnd,expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ InclusiveOrExpression()
  final public Expression InclusiveOrExpression() throws ParseException {
        Expression expr,expr2;
        Token bitOrToken;
        int sourceEnd,endLine,endColumn;
    expr = ExclusiveOrExpression();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[84] = jj_gen;
        break label_26;
      }
      bitOrToken = jj_consume_token(BIT_OR);
      expr2 = ExclusiveOrExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = bitOrToken.sourceEnd;
                                endLine   = bitOrToken.endLine;
                                endColumn = bitOrToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,
                                BIT_OR,expr.getSourceStart(),
                                sourceEnd,expr.getBeginLine(),
                                endLine,expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ExclusiveOrExpression()
  final public Expression ExclusiveOrExpression() throws ParseException {
        Expression expr,expr2;
        Token bitXorToken;
        int sourceEnd,endLine,endColumn;
    expr = AndExpression();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_XOR:
        ;
        break;
      default:
        jj_la1[85] = jj_gen;
        break label_27;
      }
      bitXorToken = jj_consume_token(BIT_XOR);
      expr2 = AndExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = bitXorToken.sourceEnd;
                                endLine   = bitXorToken.endLine;
                                endColumn = bitXorToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,
                                BIT_XOR,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ AndExpression()
  final public Expression AndExpression() throws ParseException {
        Expression expr,expr2;
        Token bitAndToken;
        int sourceEnd,endLine,endColumn;
    expr = EqualityExpression();
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[86] = jj_gen;
        break label_28;
      }
      bitAndToken = jj_consume_token(BIT_AND);
      expr2 = EqualityExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = bitAndToken.sourceEnd;
                                endLine   = bitAndToken.endLine;
                                endColumn = bitAndToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,
                                BIT_AND,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ EqualityExpression()
  final public Expression EqualityExpression() throws ParseException {
        Expression left;
        Expression right;
        Token token;
        int sourceEnd;
        int endLine;
        int endColumn;
    left = instanceofExpression();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL_EQUAL:
      case NOT_EQUAL:
      case DIF:
      case BANGDOUBLEEQUAL:
      case TRIPLEEQUAL:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_29;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL_EQUAL:
        token = jj_consume_token(EQUAL_EQUAL);
        break;
      case DIF:
        token = jj_consume_token(DIF);
        break;
      case NOT_EQUAL:
        token = jj_consume_token(NOT_EQUAL);
        break;
      case BANGDOUBLEEQUAL:
        token = jj_consume_token(BANGDOUBLEEQUAL);
        break;
      case TRIPLEEQUAL:
        token = jj_consume_token(TRIPLEEQUAL);
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      try {
        right = instanceofExpression();
      } catch (ParseException e) {
                        if (errorMessage != null)
                        {
                                {if (true) throw e;}
                        }
                        right = new ConstantIdentifier(SYNTAX_ERROR_CHAR,
                                token.sourceEnd +1,
                                token.sourceEnd +1,
                                token.beginLine,
                                token.endLine,
                                token.beginColumn,
                                token.endColumn);
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "expression expected",
                                "expression",
                                e.currentToken.image,
                                token.sourceEnd,
                                token.sourceEnd+1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
                        if (right == null)
                        {
                                sourceEnd = token.sourceEnd;
                                endLine   = token.endLine;
                                endColumn = token.endColumn;
                        }
                        else
                        {
                                sourceEnd = right.getSourceEnd();
                                endLine   = right.getEndLine();
                                endColumn = right.getEndColumn();
                        }
                        left = new BinaryExpression(left,right,
                                token.kind,left.getSourceStart(),
                                sourceEnd,left.getBeginLine(),endLine,
                                left.getBeginColumn(),endColumn);
    }
                {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ instanceofExpression()
  final public Expression instanceofExpression() throws ParseException {
        Expression expr;
        Expression expr2 = null;
        int sourceEnd,endLine,endColumn;
    expr = RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTANCEOF:
      jj_consume_token(INSTANCEOF);
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAMESPACE_IDENTIFIER:
        case NAMESPACE_NAME:
          expr2 = fullyQualifiedIdentifier();
          break;
        case CLASS:
        case FUNCTION:
        case VAR:
        case IF:
        case ELSEIF:
        case ELSE:
        case BREAK:
        case _DEFAULT:
        case NEW:
        case CLONE:
        case DEFINE:
        case GOTO:
        case NULL:
        case SUPER:
        case THIS:
        case TRUE:
        case FALSE:
        case STRING:
        case OBJECT:
        case BOOL:
        case BOOLEAN:
        case REAL:
        case DOUBLE:
        case FLOAT:
        case INT:
        case INTEGER:
        case IDENTIFIER:
          expr2 = classIdentifier();
          break;
        case DOLLAR:
          expr2 = VariableDeclaratorId();
          break;
        default:
          jj_la1[89] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
                        fireParseError("string or object expected","string or object",e.currentToken.next);
      }
                        if (expr2 == null)
                        {
                                sourceEnd = token.sourceEnd;
                                endLine   = token.endLine;
                                endColumn = token.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,
                                INSTANCEOF,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ RelationalExpression()
  final public Expression RelationalExpression() throws ParseException {
        Expression expr,expr2;
        int sourceEnd,endLine,endColumn;
        Token token;
    expr = ShiftExpression();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
      case LT:
      case LE:
      case GE:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        token = jj_consume_token(LT);
        break;
      case GT:
        token = jj_consume_token(GT);
        break;
      case LE:
        token = jj_consume_token(LE);
        break;
      case GE:
        token = jj_consume_token(GE);
        break;
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = ShiftExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = token.sourceEnd;
                                endLine   = token.endLine;
                                endColumn = token.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,token.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ShiftExpression()
  final public Expression ShiftExpression() throws ParseException {
        Expression expr,expr2;
        int sourceEnd,endLine,endColumn;
        Token shiftToken;
    expr = AdditiveExpression();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
      case RSIGNEDSHIFT:
      case RUNSIGNEDSHIFT:
        ;
        break;
      default:
        jj_la1[93] = jj_gen;
        break label_31;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
        shiftToken = jj_consume_token(LSHIFT);
        break;
      case RSIGNEDSHIFT:
        shiftToken = jj_consume_token(RSIGNEDSHIFT);
        break;
      case RUNSIGNEDSHIFT:
        shiftToken = jj_consume_token(RUNSIGNEDSHIFT);
        break;
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = AdditiveExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = shiftToken.sourceEnd;
                                endLine   = shiftToken.endLine;
                                endColumn = shiftToken.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,shiftToken.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ AdditiveExpression()
  final public Expression AdditiveExpression() throws ParseException {
        Expression expr,expr2;
        int sourceEnd,endLine,endColumn;
        Token token;
    expr = MultiplicativeExpression();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_32;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        token = jj_consume_token(PLUS);
        break;
      case MINUS:
        token = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = MultiplicativeExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = token.sourceEnd;
                                endLine   = token.endLine;
                                endColumn = token.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,token.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ MultiplicativeExpression()
  final public Expression MultiplicativeExpression() throws ParseException {
        Expression expr;
        Expression expr2;
        int sourceEnd,endLine,endColumn;
        Token token;
    try {
      expr = unaryExpression();
    } catch (ParseException e) {
                if (errorMessage != null) {if (true) throw e;}
                errorMessage = "unexpected token "+e.currentToken.next.image;
                errorStart = this.token.sourceStart;
                errorEnd   = this.token.sourceEnd;
                {if (true) throw e;}
    }
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case REMAINDER:
        ;
        break;
      default:
        jj_la1[97] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        token = jj_consume_token(STAR);
        break;
      case SLASH:
        token = jj_consume_token(SLASH);
        break;
      case REMAINDER:
        token = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr2 = unaryExpression();
                        if (expr2 == null)
                        {
                                sourceEnd = token.sourceEnd;
                                endLine   = token.endLine;
                                endColumn = token.endColumn;
                        }
                        else
                        {
                                sourceEnd = expr2.getSourceEnd();
                                endLine   = expr2.getEndLine();
                                endColumn = expr2.getEndColumn();
                        }
                        expr = new BinaryExpression(expr,expr2,token.kind,
                                expr.getSourceStart(),sourceEnd,
                                expr.getBeginLine(),endLine,
                                expr.getBeginColumn(),endColumn);
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ unaryExpression()
/**
 * An unary expression starting with @, & or nothing.
 *
 * @return the unary expression
 */
  final public Expression unaryExpression() throws ParseException {
        Expression expr;
    expr = AtNotTildeUnaryExpression();
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ AtNotTildeUnaryExpression()
  final public Expression AtNotTildeUnaryExpression() throws ParseException {
        if (shouldStop)
                throw new ParsingAbortedError();
        Expression expr;
        Token prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      prefix = jj_consume_token(AT);
      expr = AtNotTildeUnaryExpression();
      break;
    case TILDE:
      prefix = jj_consume_token(TILDE);
      expr = AtNotTildeUnaryExpression();
      break;
    case BANG:
      prefix = jj_consume_token(BANG);
      expr = AtNotUnaryExpression();
      break;
    case ARRAY:
    case LIST:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = UnaryExpressionNoPrefix();
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (prefix != null)
                        expr = new PrefixedUnaryExpression(expr, prefix);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ AtNotUnaryExpression()
/**
 * An expression prefixed (or not) by one or more @ and !.
 * @return the expression
 */
  final public Expression AtNotUnaryExpression() throws ParseException {
        Expression expr;
        Token prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      prefix = jj_consume_token(AT);
      expr = AtNotUnaryExpression();
      break;
    case BANG:
      prefix = jj_consume_token(BANG);
      expr = AtNotUnaryExpression();
      break;
    case ARRAY:
    case LIST:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = UnaryExpressionNoPrefix();
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (prefix != null)
                        expr = new PrefixedUnaryExpression(expr, prefix);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ UnaryExpressionNoPrefix()
  final public Expression UnaryExpressionNoPrefix() throws ParseException {
        Expression expr;
        Token prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      prefix = jj_consume_token(PLUS);
      expr = AtNotTildeUnaryExpression();
      break;
    case MINUS:
      prefix = jj_consume_token(MINUS);
      expr = AtNotTildeUnaryExpression();
      break;
    case PLUS_PLUS:
    case MINUS_MINUS:
      expr = PreIncDecExpression();
      break;
    case ARRAY:
    case LIST:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = UnaryExpressionNotPlusMinus();
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (prefix != null)
                        expr = new PrefixedUnaryExpression(expr, prefix);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ PreIncDecExpression()
  final public Expression PreIncDecExpression() throws ParseException {
        Expression expr;
        Token prefix;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS_PLUS:
      prefix = jj_consume_token(PLUS_PLUS);
      break;
    case MINUS_MINUS:
      prefix = jj_consume_token(MINUS_MINUS);
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr = primaryExpression();
                {if (true) return new PrefixedUnaryExpression(expr, prefix);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ UnaryExpressionNotPlusMinus()
  final public Expression UnaryExpressionNotPlusMinus() throws ParseException {
        Expression expr;
    if (jj_2_4(2147483647)) {
      expr = CastExpression();
                                         {if (true) return expr;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case SUPER:
      case THIS:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case BIT_AND:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
        expr = PostfixExpression();
                                           {if (true) return expr;}
        break;
      case NULL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
        expr = Literal();
                                           {if (true) return expr;}
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        expr = Expression();
        try {
          jj_consume_token(RPAREN);
        } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "')' expected",
                        ")",
                        e.currentToken.image,
                        expr.getSourceEnd(),
                        expr.getSourceEnd()+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
        }
                {if (true) return expr;}
        break;
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ CastExpression()
  final public CastExpression CastExpression() throws ParseException {
        ConstantIdentifier type;
        Expression expr;
        Token lParen;
        Token arrayToken;
    lParen = jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
      type = Type();
      break;
    case ARRAY:
      arrayToken = jj_consume_token(ARRAY);
                        type = new ConstantIdentifier(arrayToken);
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
    expr = unaryExpression();
                {if (true) return new CastExpression(type,
                        expr,
                        lParen.sourceStart,
                        expr.getSourceEnd(),
                        lParen.beginLine,
                        expr.getEndLine(),
                        lParen.beginColumn,
                        expr.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ PostfixExpression()
  final public Expression PostfixExpression() throws ParseException {
        Expression expr;
        Token token = null;
    expr = primaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS_PLUS:
    case MINUS_MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS_PLUS:
        token = jj_consume_token(PLUS_PLUS);
        break;
      case MINUS_MINUS:
        token = jj_consume_token(MINUS_MINUS);
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[106] = jj_gen;
      ;
    }
                if (token == null)
                {
                        {if (true) return expr;}
                }
                {if (true) return new PostfixedUnaryExpression(expr,
                        token.kind,
                        token.sourceEnd,
                        token.endLine,
                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ primaryExpression()
  final public Expression primaryExpression() throws ParseException {
        Expression expr;
        Token bitAndToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIT_AND:
      bitAndToken = jj_consume_token(BIT_AND);
      expr = refPrimaryExpression(bitAndToken);
      break;
    case STATIC:
    case NEW:
    case DEFINE:
    case SUPER:
    case THIS:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
      expr = refPrimaryExpression(null);
      break;
    case CLONE:
      expr = cloning();
      break;
    case ARRAY:
      expr = ArrayDeclarator();
      break;
    case LIST:
      expr = listExpression();
      break;
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
      expr = IncludeExpression();
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ refPrimaryExpression(Token reference)
/**
 * @param bitAndToken it is the token with the &, it can be null if there is no
 * such token
 */
  final public Expression refPrimaryExpression(Token bitAndToken) throws ParseException {
        Expression expr;
        Token identifier;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEW:
      expr = instantiation(bitAndToken);
      break;
    case STATIC:
    case DEFINE:
    case SUPER:
    case THIS:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFINE:
      case SUPER:
      case THIS:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
        identifier = constantIdentifier();
                                expr = new ConstantIdentifier(identifier);
        break;
      case STATIC:
        identifier = jj_consume_token(STATIC);
                                expr = new ConstantIdentifier(identifier);
        break;
      case DOLLAR:
        expr = Variable();
        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CLASSACCESS:
        case STATICCLASSACCESS:
        case LPAREN:
        case LBRACKET:
        case LBRACE:
          ;
          break;
        default:
          jj_la1[109] = jj_gen;
          break label_34;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
                                ArgumentList argumentList;
          argumentList = arguments();
                                expr = new FunctionCall(expr, argumentList);
          break;
        case STATICCLASSACCESS:
          expr = staticClassAccess(expr);
          break;
        case CLASSACCESS:
          expr = classAccess(expr);
          break;
        case LBRACKET:
        case LBRACE:
          expr = arrayDeclarator(expr);
          break;
        default:
          jj_la1[110] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ fullyQualifiedIdentifier() method
  final public Expression fullyQualifiedIdentifier() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_IDENTIFIER:
      token = jj_consume_token(NAMESPACE_IDENTIFIER);
      break;
    case NAMESPACE_NAME:
      token = jj_consume_token(NAMESPACE_NAME);
      break;
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                 {if (true) return new ConstantIdentifier(token);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ superClassOrInterface() method
  final public Token superClassOrInterface() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_IDENTIFIER:
      token = jj_consume_token(NAMESPACE_IDENTIFIER);
      break;
    case IDENTIFIER:
      token = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[113] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ namespaceIdentifier() method
  final public Token namespaceIdentifier() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_IDENTIFIER:
      token = jj_consume_token(NAMESPACE_IDENTIFIER);
      break;
    case IDENTIFIER:
      token = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ instantiation()
  final public Expression instantiation(Token reference) throws ParseException {
        Token newToken;
        Expression expr;
        Expression arguments;
        Expression namespace;
    newToken = jj_consume_token(NEW);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAMESPACE_IDENTIFIER:
      case NAMESPACE_NAME:
        expr = fullyQualifiedIdentifier();
        break;
      case CLASS:
      case FUNCTION:
      case VAR:
      case IF:
      case ELSEIF:
      case ELSE:
      case BREAK:
      case _DEFAULT:
      case NEW:
      case CLONE:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case IDENTIFIER:
        expr = classIdentifier();
        break;
      case DOLLAR:
        expr = VariableDeclaratorId();
        break;
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        expr.setType(new Type(Type.OBJECT_INT,expr.toString()));
    } catch (ParseException e) {
                //{{{ Exception
                Token token = error_skipto(SEMICOLON);
                expr = new DummyExpression(newToken.sourceEnd,
                        token.sourceStart,
                        newToken.endLine,
                        token.beginLine,
                        newToken.endColumn,
                        token.beginColumn);
                expr.setType(Type.OBJECT);
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "class identifier expected",
                        "class identifier",
                        newToken.next.image,
                        newToken.next.sourceStart,
                        token.sourceStart,
                        newToken.next.beginLine,
                        token.beginLine,
                        newToken.next.beginColumn,
                        token.beginColumn)); //}}}

    }
                int start, beginLine, beginColumn;
                if (reference == null)
                {
                        start       = newToken.sourceStart;
                        beginLine   = newToken.beginLine;
                        beginColumn = newToken.beginColumn;
                }
                else
                {
                        start       = reference.sourceStart;
                        beginLine   = reference.beginLine;
                        beginColumn = reference.beginColumn;
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
                        ArgumentList args;
      args = arguments();
                        expr = new FunctionCall(expr,args);
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
                expr = new ClassInstantiation(expr,
                        reference != null,
                        start,
                        beginLine,
                        beginColumn);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ cloning()
  final public Expression cloning() throws ParseException {
        AbstractVariable variable;
    jj_consume_token(CLONE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      variable = VariableDeclaratorId();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      try {
        variable = VariableDeclaratorId();
      } catch (ParseException e) {
                        variable = new Variable(SYNTAX_ERROR_CHAR,
                        e.currentToken.sourceStart,e.currentToken.sourceEnd,
                                               e.currentToken.beginLine,
                                               e.currentToken.endLine,
                                               e.currentToken.beginColumn,
                                               e.currentToken.endColumn);
                        fireParseError("variable expected","variable",e.currentToken.next);
      }
      try {
        jj_consume_token(RPAREN);
      } catch (ParseException e) {
                        fireParseError(") expected",")",e.currentToken.next);
      }
      break;
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return variable;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ArrayDeclarator()
/**
 * An array declarator.
 * array(vars)
 * @return an array
 */
  final public ArrayInitializer ArrayDeclarator() throws ParseException {
        ArrayVariableDeclaration[] vars;
        Token arrayToken;
    arrayToken = jj_consume_token(ARRAY);
    vars = ArrayInitializer();
                {if (true) return new ArrayInitializer(vars,
                        arrayToken.sourceStart,
                        token.sourceEnd,
                        arrayToken.beginLine,
                        token.endLine,
                        arrayToken.beginColumn,
                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ClassIdentifier()
/**
 * A ClassIdentifier is anything that could be a class name that can be use in <code>class ClassIdentifier {}</code>
 */
  final public ClassIdentifier classIdentifier() throws ParseException {
        Token identifierToken;
    identifierToken = methodIdentifier();
                {if (true) return new ClassIdentifier(identifierToken);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ SUFFIXES

//{{{ VariableSuffix()
/**
 * Used by VariableDeclaratorId
 */
  final public AbstractVariable VariableSuffix(Expression prefix) throws ParseException {
        AbstractVariable abstractVariable;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSACCESS:
      abstractVariable = classAccess(prefix);
      break;
    case STATICCLASSACCESS:
      abstractVariable = staticClassAccess(prefix);
      break;
    case LBRACKET:
    case LBRACE:
      abstractVariable = arrayDeclarator(prefix);
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return abstractVariable;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ staticClassAccess()
/**
 * staticClassAccess
 * @param expr the expression in the left of the ::
 */
  final public ClassAccess staticClassAccess(Expression expr) throws ParseException {
        Expression expr2;
        ClassAccess ca;
        Token staticClassAccess;
        Token dollarToken, identifierToken;
    staticClassAccess = jj_consume_token(STATICCLASSACCESS);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOLLAR:
        //{{{ field access
                                dollarToken = jj_consume_token(DOLLAR);
        try {
          identifierToken = jj_consume_token(IDENTIFIER);
                                        expr2 = new ConstantIdentifier(identifierToken);
                                        ca = new ClassAccess(expr,expr2,STATICCLASSACCESS,expr2.getSourceEnd(),expr2.getEndLine(),expr2.getEndColumn());
        } catch (ParseException e) {
                                ca = new ClassAccess(expr,
                                                     null,
                                                     STATICCLASSACCESS,
                                                     dollarToken.sourceEnd,
                                                     dollarToken.endLine,
                                                     dollarToken.endColumn);
                                fireParseError("identifier expected","identifier",e.currentToken);
        }
        break;
      case CLASS:
      case FUNCTION:
      case VAR:
      case IF:
      case ELSEIF:
      case ELSE:
      case BREAK:
      case _DEFAULT:
      case NEW:
      case CLONE:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case IDENTIFIER:
                                Expression arguments = null;
                                Token methodIdentifier;
        try {
          methodIdentifier = methodIdentifier();
                                        expr2 =  new ConstantIdentifier(methodIdentifier);
          if (jj_2_5(2147483647)) {
                                                ArgumentList args;
            args = arguments();
                                                arguments = new FunctionCall(expr, true, expr2, args);
          } else {
            ;
          }
                                        expr2.setType(new Type(Type.OBJECT_INT,expr2.toString()));
                                        if (arguments == null)
                                                arguments = expr2;
                                        ca = new ClassAccess(expr,
                                                             arguments,
                                                             STATICCLASSACCESS,
                                                             arguments.getSourceEnd(),
                                                             arguments.getEndLine(),
                                                             arguments.getEndColumn());
        } catch (ParseException e) {
                                ca = new ClassAccess(expr,
                                                     null,
                                                     STATICCLASSACCESS,
                                                     staticClassAccess.sourceEnd,
                                                     staticClassAccess.endLine,
                                                     staticClassAccess.endColumn);
                                fireParseError("identifier expected","identifier",e.currentToken);
        }
        break;
      default:
        jj_la1[119] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
                ca = new ClassAccess(expr,
                                     null,
                                     STATICCLASSACCESS,
                                     staticClassAccess.sourceEnd,
                                     staticClassAccess.endLine,
                                     staticClassAccess.endColumn);
                fireParseError("field or method expected","identifier",e.currentToken);
    }
                {if (true) return ca;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ classAccess() method
  final public ClassAccess classAccess(Expression prefix) throws ParseException {
        Token lbrace, rbrace, token;
        Token classAccess;
        Expression expression;
    classAccess = jj_consume_token(CLASSACCESS);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        //{{{ ->{expression}
                                 lbrace = jj_consume_token(LBRACE);
        expression = Expression();
        rbrace = jj_consume_token(RBRACE);
                                 expression = new Variable(expression,
                                                           lbrace.sourceStart,
                                                           rbrace.sourceEnd,
                                                           lbrace.beginLine,
                                                           rbrace.endLine,
                                                           lbrace.beginColumn,
                                                           rbrace.endColumn);
                                 setTypeFromScope((Variable) expression);
        break;
      case CLASS:
      case FUNCTION:
      case VAR:
      case IF:
      case ELSEIF:
      case ELSE:
      case BREAK:
      case _DEFAULT:
      case NEW:
      case CLONE:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case IDENTIFIER:
                                Expression arguments = null;
                                Token methodIdentifier;
        try {
          methodIdentifier = methodIdentifier();
                                        expression =  new ConstantIdentifier(methodIdentifier);
          if (jj_2_6(2147483647)) {
                                                ArgumentList args;
            args = arguments();
                                                expression = new FunctionCall(prefix, false, expression, args);
          } else {
            ;
          }
                                        expression.setType(new Type(Type.OBJECT_INT,prefix.toString()));
        } catch (ParseException e) {
                                expression = new ClassAccess(prefix,
                                     null,
                                     CLASSACCESS,
                                     classAccess.sourceEnd,
                                     classAccess.endLine,
                                     classAccess.endColumn);
                                fireParseError("identifier expected","identifier",e.currentToken);
        }
        break;
      case PUBLIC:
      case PROTECTED:
      case PRIVATE:
      case FINAL:
      case LIST:
      case STATIC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LIST:
          token = jj_consume_token(LIST);
          break;
        case PROTECTED:
          token = jj_consume_token(PROTECTED);
          break;
        case PUBLIC:
          token = jj_consume_token(PUBLIC);
          break;
        case PRIVATE:
          token = jj_consume_token(PRIVATE);
          break;
        case STATIC:
          token = jj_consume_token(STATIC);
          break;
        case FINAL:
          token = jj_consume_token(FINAL);
          break;
        default:
          jj_la1[120] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                 expression = new ConstantIdentifier(token);
        break;
      case DOLLAR:
        expression = Variable();
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
                fireParseError("expression expected", "expression", e.currentToken);
                expression = new DummyExpression(e.currentToken);
    }
                {if (true) return new ClassAccess(prefix,
                                       expression,
                                       CLASSACCESS,
                                       expression.getSourceEnd(),
                                       expression.getEndLine(),
                                       expression.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ arrayDeclarator(Expression prefix)
  final public ArrayDeclarator arrayDeclarator(Expression prefix) throws ParseException {
        Token open;
        Token close = null;
        Expression expression = null;
        int sourceEnd,endLine,endColumn;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      open = jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case PRINT:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        expression = Expression();
        break;
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      try {
        close = jj_consume_token(RBRACKET);
      } catch (ParseException e) {
                        fireParseError("']' expected", "]", e.currentToken);
      }
      break;
    case LBRACE:
      open = jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case PRINT:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        expression = Expression();
        break;
      default:
        jj_la1[123] = jj_gen;
        ;
      }
      try {
        close = jj_consume_token(RBRACE);
      } catch (ParseException e) {
                        fireParseError("'}' expected", "}", e.currentToken);
      }
      break;
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (close == null)
                {
                        if (expression == null)
                        {
                                sourceEnd = open.sourceEnd;
                                endLine   = open.endLine;
                                endColumn = open.endColumn;
                        }
                        else
                        {
                                sourceEnd = expression.getSourceEnd();
                                endLine   = expression.getEndLine();
                                endColumn = expression.getEndColumn();
                        }
                }
                else
                {
                        sourceEnd = open.sourceEnd;
                        endLine   = open.endLine;
                        endColumn = open.endColumn;
                }
                {if (true) return new ArrayDeclarator(prefix,
                                           expression,
                                           sourceEnd,
                                           endLine,
                                           endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ LITERAL

//{{{ Literal()
  final public Literal Literal() throws ParseException {
        Token token;
        StringLiteral stringLiteral;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      token = jj_consume_token(INTEGER_LITERAL);
                                           {if (true) return new NumberLiteral(Type.INTEGER,token);}
      break;
    case FLOATING_POINT_LITERAL:
      token = jj_consume_token(FLOATING_POINT_LITERAL);
                                             {if (true) return new NumberLiteral(Type.INTEGER,token);}
      break;
    case STRING_LITERAL:
      token = jj_consume_token(STRING_LITERAL);
                                             {if (true) return new StringLiteral(token);}
      break;
    case TRUE:
      token = jj_consume_token(TRUE);
                                             {if (true) return new TrueLiteral(token);}
      break;
    case FALSE:
      token = jj_consume_token(FALSE);
                                             {if (true) return new FalseLiteral(token);}
      break;
    case NULL:
      token = jj_consume_token(NULL);
                                             {if (true) return new NullLiteral(token);}
      break;
    case HEREDOCSTARTTOKEN:
      stringLiteral = heredoc();
                                             {if (true) return stringLiteral;}
      break;
    case DOUBLEQUOTE:
      stringLiteral = evaluableString();
                                             {if (true) return stringLiteral;}
      break;
    default:
      jj_la1[125] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ heredoc()
  final public StringLiteral heredoc() throws ParseException {
        Token heredocStart;
        Token startToken;
        Token endToken;
        String endImage;
        String startImage;
    heredocStart = jj_consume_token(HEREDOCSTARTTOKEN);
    try {
      startToken = jj_consume_token(IDENTIFIER);
                        startImage = startToken.image;
                        if(heredocStart.sourceEnd != startToken.sourceStart)
                        {
                                //{{{ Parse error
                                fireParseError(new PHPParseErrorEvent(ERROR,
                                        path,
                                        "unexpected spaces",
                                        "",
                                        "",
                                        heredocStart.sourceEnd+1,
                                        startToken.sourceStart-1,
                                        startToken.beginLine,
                                        startToken.endLine,
                                        heredocStart.endColumn+1,
                                        startToken.beginColumn-1)); //}}}
                        }
    } catch (ParseException e) {
                //{{{ Parse error
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "identifier expected",
                        "identifier",
                        e.currentToken.image,
                        errorStart,
                        errorEnd,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1)); //}}}
                {if (true) return new StringLiteral("",
                        jj_input_stream.getBeginOffset(),
                        jj_input_stream.getBeginOffset()+1,
                        jj_input_stream.getBeginLine(),
                        jj_input_stream.getEndLine(),
                        jj_input_stream.getBeginColumn(),
                        jj_input_stream.getEndColumn());}
    }
                while (true)
                {
                        endToken = getNextToken();
                        if (endToken.kind == EOF)
                        {
                                fireParseError("unexpected EOF","",endToken);
                                break;
                        }

                        if (endToken.beginLine == startToken.beginLine)
                        {
                                fireParseError("unexpected token","identifier",endToken);
                                continue;
                        }
                        if (endToken.beginColumn != 1)
                                continue;
                        endImage = (endToken.image.charAt(endToken.image.length()-1) == ';') ? endToken.image.substring(0,endToken.image.length()-2) : endToken.image;
                        if (endImage.equals(startImage))
                        {
                                break;
                        }
                }
                token_source.SwitchTo(PHPPARSING);
                //  return new StringLiteral(jj_input_stream.getCurrentBuffer().substring(startToken.sourceEnd+1,endToken.sourceStart-1),
                {if (true) return new StringLiteral("",
                        startToken.sourceEnd+1,
                        endToken.sourceStart-1,
                        startToken.beginLine,
                        endToken.endLine,
                        startToken.beginColumn,
                        endToken.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ evaluableString()
  final public StringLiteral evaluableString() throws ParseException {
        List<Expression> list = new ArrayList<Expression>();
        Token start,end;
        Expression expr;
        Token identifier;
        boolean hasDollar = false;
    start = jj_consume_token(DOUBLEQUOTE);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOLLARBRACE:
      case DOLLARS:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[126] = jj_gen;
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        identifier = jj_consume_token(IDENTIFIER);
                        if (hasDollar)
                        {
                                hasDollar = false;
                                expr = new Variable(identifier);
                                list.add(expr);
                        }
        break;
      case DOLLARBRACE:
        jj_consume_token(DOLLARBRACE);
                        hasDollar = true;
        break;
      case DOLLARS:
        jj_consume_token(DOLLARS);
                        hasDollar = true;
        break;
      default:
        jj_la1[127] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOUBLEQUOTE:
      end = jj_consume_token(DOUBLEQUOTE);
      break;
    case DOUBLEQUOTE2:
      end = jj_consume_token(DOUBLEQUOTE2);
      break;
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        token_source.SwitchTo(PHPPARSING);
                        Expression[] expressions = new Expression[list.size()];
                        list.toArray(expressions);
                        {if (true) return new StringLiteral("",
                                                 start.sourceStart,
                                                 end.sourceEnd,
                                                 start.beginLine,
                                                 end.endLine,
                                                 start.beginColumn,
                                                 end.endColumn,
                                                 expressions);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ arguments()
  final public ArgumentList arguments() throws ParseException {
        Expression[] args = null;
        Token rparen,lparen;
    lparen = jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FUNCTION:
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      args = ArgumentList();
      break;
    default:
      jj_la1[129] = jj_gen;
      ;
    }
    try {
      rparen = jj_consume_token(RPAREN);
                        {if (true) return new ArgumentList(args,
                                lparen.sourceStart,
                                rparen.sourceEnd,
                                lparen.beginLine,
                                rparen.endLine,
                                lparen.beginColumn,
                                rparen.endColumn);}
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "')' expected",
                        ")",
                        e.currentToken.image,
                        errorStart,
                        errorEnd,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.beginColumn,
                        e.currentToken.endColumn));
    }
                int sourceEnd, line, column;
                if (args == null || args.length == 0)
                {
                        sourceEnd = lparen.sourceEnd+1;
                        line = lparen.beginLine;
                        column = lparen.beginColumn;
                }
                else
                {
                        sourceEnd = args[args.length-1].getSourceEnd();
                        line = args[args.length-1].getBeginLine();
                        column = args[args.length-1].getBeginColumn();
                }

                {if (true) return new ArgumentList(args,
                        lparen.sourceStart,
                        sourceEnd,
                        lparen.beginLine,
                        line,
                        lparen.beginColumn,
                        column);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ArgumentList()
/**
 * An argument list is a list of arguments separated by comma :
 * argumentDeclaration() (, argumentDeclaration)*
 * @return an array of arguments
 */
  final public Expression[] ArgumentList() throws ParseException {
        Expression arg;
        List<Expression> list = new ArrayList<Expression>();
    arg = _argument();
                list.add(arg);
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[130] = jj_gen;
        break label_36;
      }
      jj_consume_token(COMMA);
      try {
        arg = _argument();
                                list.add(arg);
      } catch (ParseException e) {
                        fireParseError("expression expected", "expression", e.currentToken);
      }
    }
                Expression[] arguments = new Expression[list.size()];
                list.toArray(arguments);
                {if (true) return arguments;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ _argument() method
  final public Expression _argument() throws ParseException {
        Expression arg;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      arg = Expression();
      break;
    case FUNCTION:
      arg = closureDeclaration();
      break;
    default:
      jj_la1[131] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return arg;}
    throw new Error("Missing return statement in function");
  }

  //}}}


//{{{ StatementNoBreak()
/**
 * A Statement without break.
 * @return a statement
 */
  final public Statement StatementNoBreak() throws ParseException {
        Statement statement;
    if (jj_2_7(2)) {
      statement = expressionStatement();
    } else if (jj_2_8(2)) {
      statement = labeledStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GOTO:
        statement = gotoStatement();
        break;
      case LBRACE:
        statement = Block();
        break;
      case SEMICOLON:
        statement = EmptyStatement();
        break;
      case SWITCH:
        statement = SwitchStatement();
        break;
      case IF:
        statement = ifStatement();
        break;
      case WHILE:
        statement = WhileStatement();
        break;
      case DO:
        statement = DoStatement();
        break;
      case FOR:
        statement = ForStatement();
        break;
      case FOREACH:
        statement = ForeachStatement();
        break;
      case CONTINUE:
        statement = ContinueStatement();
        break;
      case RETURN:
        statement = ReturnStatement();
        break;
      case ECHO:
        statement = EchoStatement();
        break;
      case STATIC:
        statement = StaticStatement();
        break;
      case GLOBAL:
        statement = GlobalStatement();
        break;
      case TRY:
        statement = tryStatement();
        break;
      case THROW:
        statement = throwStatement();
        break;
      case DEFINE:
        statement = defineStatement();
                        currentSegment.add((Outlineable)statement);
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ TRY

//{{{ throwStatement()
  final public ThrowStatement throwStatement() throws ParseException {
        Token throwToken;
        Expression expr;
        Token semicolonToken;
        int sourceEnd,endLine,endColumn;
    throwToken = jj_consume_token(THROW);
    expr = Expression();
    try {
      semicolonToken = jj_consume_token(SEMICOLON);
                        sourceEnd = semicolonToken.sourceEnd;
                        endLine   = semicolonToken.endLine;
                        endColumn = semicolonToken.endColumn;
    } catch (ParseException e) {
                sourceEnd = e.currentToken.sourceEnd;
                endLine   = e.currentToken.endLine;
                endColumn = e.currentToken.endColumn;
                fireParseError("catch expected", "catch", e.currentToken);
    }
                {if (true) return new ThrowStatement(expr,
                        throwToken.sourceStart,
                        sourceEnd,
                        throwToken.beginLine,
                        endLine,
                        throwToken.beginColumn,
                        endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ tryStatement()
  final public TryStatement tryStatement() throws ParseException {
        Token tryToken;
        Block block;
        Catch catchClause;
        List<Catch> catches = new ArrayList<Catch>(5);
    tryToken = jj_consume_token(TRY);
    block = Block();
    catchClause = catchClause();
                catches.add(catchClause);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
        ;
        break;
      default:
        jj_la1[133] = jj_gen;
        break label_37;
      }
      catchClause = catchClause();
                        catches.add(catchClause);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINALLY:
      jj_consume_token(FINALLY);
                    Block();
      break;
    default:
      jj_la1[134] = jj_gen;
      ;
    }
                {if (true) return new TryStatement(block,
                        catches,
                        tryToken.sourceStart,
                        catchClause.getSourceEnd(),
                        tryToken.beginLine,
                        catchClause.getEndLine(),
                        tryToken.beginColumn,
                        catchClause.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

 //}}}

//{{{ catchClause()
  final public Catch catchClause() throws ParseException {
        Token catchToken;
        Token catchedException;
        Token dollarToken;
        Token identifierToken;
        Block block;
        int start,beginLine,beginColumn;
        int startVar,beginLineVar,beginColumnVar;
        int endVar,endLineVar,endColumnVar;
        String identifierString = SYNTAX_ERROR_CHAR;
        String catchedString = null;
    try {
      catchToken = jj_consume_token(CATCH);
                        start       = catchToken.sourceStart;
                        beginLine   = catchToken.beginLine;
                        beginColumn = catchToken.beginColumn;
    } catch (ParseException e) {
                start       = e.currentToken.sourceStart;
                beginLine   = e.currentToken.beginLine;
                beginColumn = e.currentToken.beginColumn;
                fireParseError("catch expected", "catch", e.currentToken);
    }
    try {
      jj_consume_token(LPAREN);
    } catch (ParseException e) {
                fireParseError("'(' expected", "(", e.currentToken);
    }
    try {
      catchedException = namespaceIdentifier();
                        catchedString = catchedException.image;
    } catch (ParseException e) {
                fireParseError("identifier expected", "identifier", e.currentToken);
    }
    try {
      dollarToken = jj_consume_token(DOLLAR);
                        startVar       = dollarToken.sourceStart;
                        beginLineVar   = dollarToken.beginLine;
                        beginColumnVar = dollarToken.beginColumn;
    } catch (ParseException e) {
                startVar       = e.currentToken.sourceStart;
                beginLineVar   = e.currentToken.beginLine;
                beginColumnVar = e.currentToken.beginColumn;
                fireParseError("$ expected", "$", e.currentToken);
    }
    try {
      identifierToken = jj_consume_token(IDENTIFIER);
                        identifierString = identifierToken.image;
                        endVar       = identifierToken.sourceStart;
                        endLineVar   = identifierToken.beginLine;
                        endColumnVar = identifierToken.beginColumn;
    } catch (ParseException e) {
                endVar       = e.currentToken.sourceEnd;
                endLineVar   = e.currentToken.endLine;
                endColumnVar = e.currentToken.endColumn;
                fireParseError("identifier expected", "identifier", e.currentToken);
    }
    try {
      jj_consume_token(RPAREN);
    } catch (ParseException e) {
                fireParseError("')' expected", ")", e.currentToken);
    }
    block = Block();
                {if (true) return new Catch(catchedString,
                        new Variable(identifierString,
                                startVar,
                                endVar,
                                beginLineVar,
                                endLineVar,
                                beginColumnVar,
                                endColumnVar),
                        block,
                        start,
                        block.getSourceEnd(),
                        beginLine,
                        block.getEndLine(),
                        beginColumn,
                        block.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ expressionStatement()
/**
 * A statement expression.
 * expression ;
 * @return an expression
 */
  final public Statement expressionStatement() throws ParseException {
        Statement statement;
        Token token;
    try {
      statement = Expression();
    } catch (ParseException e) {
                token = error_skipto(SEMICOLON);
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "expression expected",
                        "expression",
                        e.currentToken.image,
                        e.currentToken.sourceEnd,
                        token.sourceEnd,
                        e.currentToken.beginLine,
                        token.endLine,
                        e.currentToken.endColumn,
                        token.beginColumn));
                {if (true) return new EmptyStatement(e.currentToken.sourceStart,
                        token.sourceEnd,
                        e.currentToken.beginLine,
                        token.endLine,
                        e.currentToken.beginColumn,
                        token.endColumn);}
    }
    try {
      token = jj_consume_token(SEMICOLON);
                        statement.setSourceEnd(token.sourceEnd);
    } catch (ParseException e) {
                if (e.currentToken.next.kind != PHPEND)
                {
                        fireParseError("';' expected", ";", e.currentToken);
                }
    }
                {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ constantStatement()
  final public List<Const> constantStatement() throws ParseException {
        Token constToken;
        Token identifierToken;
        Expression identifier;
        Expression value = null;
        List<Const> constList = new ArrayList<Const>();
        Const constant;
    constToken = jj_consume_token(CONST);
    constant = _const();
                constList.add(constant);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[135] = jj_gen;
        break label_38;
      }
      jj_consume_token(COMMA);
      try {
        constant = _const();
                                constList.add(constant);
      } catch (ParseException e) {
                        fireParseError("const expected", "const", e.currentToken);
      }
    }
    try {
      jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                error_skipto(SEMICOLON);
                fireParseError("; expected", ";", e.currentToken);
    }
                {if (true) return constList;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ _const()
  final public Const _const() throws ParseException {
        Token identifierToken;
        Expression identifier;
        Expression value = null;
    try {
      identifierToken = jj_consume_token(IDENTIFIER);
                        identifier = new ConstantIdentifier(identifierToken);
    } catch (ParseException e) {
                identifier = new StringLiteral(SYNTAX_ERROR_CHAR,
                        e.currentToken.sourceStart,e.currentToken.sourceEnd,
                                               e.currentToken.beginLine,
                                               e.currentToken.endLine,
                                               e.currentToken.endColumn,
                                               e.currentToken.endColumn+1);
    }
    try {
      jj_consume_token(ASSIGN);
    } catch (ParseException e) {
                error_skipto(ASSIGN);
                fireParseError("= expected", "=", e.currentToken);
    }
    try {
      value = Literal();
    } catch (ParseException e) {
                fireParseError("value expected", "value", e.currentToken);
                value = new StringLiteral(SYNTAX_ERROR_CHAR,
                        e.currentToken.sourceStart,e.currentToken.sourceEnd,
                                               e.currentToken.beginLine,
                                               e.currentToken.endLine,
                                               e.currentToken.endColumn,
                                               e.currentToken.endColumn+1);
    }
                {if (true) return new Const(currentSegment,
                                  identifier,
                                  value,
                                  identifier.getSourceStart(),
                                  value.getSourceEnd(),
                                  identifier.getBeginLine(),
                                  value.getEndLine(),
                                  identifier.getBeginColumn(),
                                  value.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}


//{{{ defineStatement()
  final public Define defineStatement() throws ParseException {
        Expression defineName;
        Expression defineValue;
        Token defineToken;
        Token token;
        int pos;
    defineToken = jj_consume_token(DEFINE);
                                pos = defineToken.sourceEnd+1;
    try {
      token = jj_consume_token(LPAREN);
                 pos = token.sourceEnd+1;
    } catch (ParseException e) {
                fireParseError("'(' expected", "(", e.currentToken);
    }
    try {
      defineName = Expression();
                        pos = defineName.getSourceEnd()+1;
    } catch (ParseException e) {
                fireParseError("expression expected", "expression", e.currentToken);
                defineName = new StringLiteral(SYNTAX_ERROR_CHAR,pos,pos,
                                               e.currentToken.beginLine,
                                               e.currentToken.endLine,
                                               e.currentToken.endColumn,
                                               e.currentToken.endColumn+1);
    }
    try {
      jj_consume_token(COMMA);
                        pos = defineName.getSourceEnd()+1;
    } catch (ParseException e) {
                fireParseError("',' expected", ",",e.currentToken);
    }
    try {
      defineValue = Expression();
                        pos = defineValue.getSourceEnd()+1;
    } catch (ParseException e) {
                fireParseError("expression expected", "expression", e.currentToken);
                defineValue = new StringLiteral(SYNTAX_ERROR_CHAR,pos,pos,
                                                e.currentToken.beginLine,
                                                e.currentToken.endLine,
                                                e.currentToken.endColumn,
                                                e.currentToken.endColumn+1);
    }
    try {
      token = jj_consume_token(RPAREN);
                 pos = token.sourceEnd+1;
    } catch (ParseException e) {
                fireParseError("')' expected", ")", e.currentToken);
    }
                {if (true) return new Define(currentSegment,
                                  defineName,
                                  defineValue,
                                  defineToken.sourceStart,
                                  pos,
                                  defineToken.beginLine,
                                  defineToken.endLine,
                                  defineToken.beginColumn,
                                  defineToken.endColumn);}
    throw new Error("Missing return statement in function");
  }

 //}}}

//{{{ Statement() method
/**
 * A Normal statement.
 */
  final public Statement Statement() throws ParseException {
        Statement statement;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      statement = StatementNoBreak();
      break;
    case BREAK:
      statement = BreakStatement();
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (statement != null)
                {
                        statement.getModifiedVariable(tempList);
                        scope.addVariablesList(tempList);
                        tempList.clear();
                }
                {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  //}}}


//{{{ htmlBlock() method
/**
 * An html block inside a php syntax.
 */
  final public HTMLBlock htmlBlock() throws ParseException {
        int startIndex = nodePtr;
        AstNode[] blockNodes;
        int nbNodes;
        Token phpEnd;
    phpEnd = jj_consume_token(PHPEND);
                htmlStart       = phpEnd.sourceEnd;
                htmlLineStart   = phpEnd.endLine;
                htmlColumnStart = phpEnd.endColumn;
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPECHOSTART:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_39;
      }
      phpEchoBlock();
    }
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPSTARTLONG:
        jj_consume_token(PHPSTARTLONG);
        break;
      case PHPSTARTSHORT:
        jj_consume_token(PHPSTARTSHORT);
        break;
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        createNewHTMLCode();
    } catch (ParseException e) {
                fireParseError("'<?php' expected","<?php",e.currentToken);
    }
                nbNodes = nodePtr - startIndex;
                if (nbNodes == 0)
                {
                        {if (true) return null;}
                }
                blockNodes = new AstNode[nbNodes];
                System.arraycopy(nodes,startIndex+1,blockNodes,0,nbNodes);
                nodePtr = startIndex;
                HTMLBlock block = new HTMLBlock(blockNodes);
                {if (true) return block;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ IncludeExpression()
/**
 * An include statement. It's "include" an expression;
 */
  final public InclusionExpression IncludeExpression() throws ParseException {
        Expression expr;
        InclusionExpression inclusionExpression;
        Token token;
        int end,line,column;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REQUIRE:
      token = jj_consume_token(REQUIRE);
      break;
    case REQUIRE_ONCE:
      token = jj_consume_token(REQUIRE_ONCE);
      break;
    case INCLUDE:
      token = jj_consume_token(INCLUDE);
      break;
    case INCLUDE_ONCE:
      token = jj_consume_token(INCLUDE_ONCE);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                end = token.sourceEnd;
                line = token.beginLine;
                column = token.beginColumn;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case SUPER:
      case THIS:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case BIT_AND:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
        expr = primaryExpression();
        break;
      case NULL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
        expr = Literal();
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        expr = Expression();
        try {
          jj_consume_token(RPAREN);
        } catch (ParseException e) {
                        //{{{ Parse Error
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                                              path,
                                                              "')'n expected",
                                                              ")",
                                                              e.currentToken.image,
                                                              expr.getSourceEnd(),
                                                              expr.getSourceEnd()+1,
                                                              e.currentToken.beginLine,
                                                              e.currentToken.endLine,
                                                              e.currentToken.endColumn,
                                                              e.currentToken.endColumn+1)); //}}}

        }
        break;
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        end    = expr.getSourceEnd();
                        line   = expr.getBeginLine();
                        column = expr.getBeginColumn();
    } catch (ParseException e) {
                if (errorMessage != null)
                        {if (true) throw e;}

                expr = new ConstantIdentifier(SYNTAX_ERROR_CHAR,
                                              token.sourceEnd,
                                              token.sourceEnd+1,
                                              token.endLine,
                                              token.endLine,
                                              token.endColumn,
                                              token.endColumn+1);
                //{{{ Parse Error
                fireParseError(new PHPParseErrorEvent(ERROR,
                                                      path,
                                                      "expression expected",
                                                      "expression",
                                                      e.currentToken.image,
                                                      e.currentToken.next.sourceStart,
                                                      e.currentToken.next.sourceEnd,
                                                      e.currentToken.beginLine,
                                                      e.currentToken.endLine,
                                                      e.currentToken.endColumn,
                                                      e.currentToken.endColumn+1)); //}}}

    }
                inclusionExpression = new InclusionExpression(currentSegment,
                                                              token.kind,
                                                              expr,
                                                              token.sourceStart,
                                                              end,
                                                              token.beginLine,
                                                              line,
                                                              token.beginColumn,
                                                              column);
                currentSegment.add(inclusionExpression);
                {if (true) return inclusionExpression;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ PrintExpression()
  final public PrintExpression PrintExpression() throws ParseException {
        Expression expr;
        Token printToken;
    printToken = jj_consume_token(PRINT);
    expr = Expression();
                {if (true) return new PrintExpression(expr,printToken.sourceStart,
                        expr.getSourceEnd(),printToken.beginLine,
                        expr.getEndLine(),printToken.beginColumn,
                        expr.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ listExpression() method
  final public ListExpression listExpression() throws ParseException {
        AbstractVariable expr = null;
        Collection<AbstractVariable> list = new ArrayList<AbstractVariable>();
        int pos;
        int line;
        int column;
        Token listToken;
        Token rParen;
        Token token;
    listToken = jj_consume_token(LIST);
                            pos = listToken.sourceEnd;line=listToken.beginLine;column=listToken.beginColumn;
    try {
      token = jj_consume_token(LPAREN);
                        pos = token.sourceEnd;
                        line = token.beginLine;
                        column = token.beginColumn;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "'(' expected",
                        "(",
                        e.currentToken.image,
                        listToken.sourceEnd,
                        listToken.sourceEnd+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      expr = VariableDeclaratorId();
                        list.add(expr);
                        pos = expr.getSourceEnd();
                        line = expr.getBeginLine();
                        column = expr.getBeginColumn();
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
                if (expr == null)
                {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                                      path,
                                                     "expected at least one variable",
                                                      "$",
                                                      null,
                                                      jj_input_stream.getBeginOffset(),
                                                      jj_input_stream.getEndOffset(),
                                                      jj_input_stream.getBeginLine(),
                                                      jj_input_stream.getEndLine(),
                                                      jj_input_stream.getBeginColumn(),
                                                      jj_input_stream.getEndColumn()));
                }
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[142] = jj_gen;
        break label_40;
      }
      try {
        token = jj_consume_token(COMMA);
                                pos = token.sourceEnd;
                                line=token.beginLine;
                                column=token.beginColumn;
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "',' expected",
                                ",",
                                e.currentToken.image,
                                pos,
                                pos+1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOLLAR:
        expr = VariableDeclaratorId();
                                list.add(expr);
                                pos = expr.getSourceEnd();
                                line = expr.getBeginLine();
                                column = expr.getBeginColumn();
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
    }
    try {
      rParen = jj_consume_token(RPAREN);
                        pos = rParen.sourceEnd;
                        line = rParen.beginLine;
                        column = rParen.beginColumn;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "')' expected",
                        ")",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
                AbstractVariable[] vars = new AbstractVariable[list.size()];
                list.toArray(vars);
                {if (true) return new ListExpression(vars,
                        listToken.sourceStart,
                        pos,
                        listToken.beginLine,
                        line,
                        listToken.beginColumn,
                        column);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ STATEMENTS

//{{{ EchoStatement()
/**
 * An echo statement.
 * echo anyexpression (, otherexpression)*
 */
  final public EchoStatement EchoStatement() throws ParseException {
        List<Expression> expressions = new ArrayList<Expression>();
        Expression expr;
        Token echoToken;
        Token semicolonToken = null;
    echoToken = jj_consume_token(ECHO);
    //{{{ expression
            expr = Expression();
                if (expr != null)
                        expressions.add(expr);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[144] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      expr = Expression();
                        if (expr != null)
                                expressions.add(expr);
    }
    try {
      semicolonToken = jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                if (e.currentToken.next.kind != 4)
                {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "';' expected",
                                ";",
                                e.currentToken.image,
                                e.currentToken.sourceEnd,
                                e.currentToken.sourceEnd,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn));
                }
    }
                Expression[] exprs = new Expression[expressions.size()];
                expressions.toArray(exprs);

                //{{{ missing ;
                if (semicolonToken == null)
                {

                        int end,endLine,endColumn;
                        if (exprs.length != 0)
                        {
                                Expression lastExpression = exprs[exprs.length-1];
                                end = lastExpression.getSourceEnd();
                                endLine = lastExpression.getEndLine();
                                endColumn = lastExpression.getEndColumn();
                        }
                        else
                        {
                                end = echoToken.sourceEnd;
                                endLine = echoToken.endLine;
                                endColumn = echoToken.endColumn;
                        }
                        {if (true) return new EchoStatement(exprs,
                                echoToken.sourceStart,
                                end,
                                echoToken.beginLine,
                                endLine,
                                echoToken.beginColumn,
                                endColumn);}
                } //}}}

                {if (true) return new EchoStatement(exprs,
                        echoToken.sourceStart,
                        semicolonToken.sourceEnd,
                        echoToken.beginLine,
                        semicolonToken.endLine,
                        echoToken.beginColumn,
                        semicolonToken.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ GlobalStatement()
  final public GlobalStatement GlobalStatement() throws ParseException {
        Variable expr;
        List<Variable> vars = new ArrayList<Variable>();
        GlobalStatement global;
        Token globalToken;
        Token semicolonToken;
        int pos,line,column;
    globalToken = jj_consume_token(GLOBAL);
    expr = Variable();
                vars.add(expr);
                pos = expr.getSourceEnd()+1;
                line = expr.getEndLine();
                column = expr.getEndColumn();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      expr = Variable();
                        vars.add(expr);
                        pos = expr.getSourceEnd()+1;
                        line=expr.getEndLine();
                        column=expr.getEndColumn();
    }
    try {
      semicolonToken = jj_consume_token(SEMICOLON);
                        pos = semicolonToken.sourceEnd+1;
                        line = semicolonToken.endLine;
                        column = semicolonToken.endColumn;
    } catch (ParseException e) {
                fireParseError("';' expected", ";", e.currentToken);
    }
                Variable[] variables = new Variable[vars.size()];
                vars.toArray(variables);
                global = new GlobalStatement(currentSegment,
                        variables,
                        globalToken.sourceStart,
                        pos,
                        globalToken.beginLine,
                        line,
                        globalToken.beginColumn,
                        column);
                currentSegment.add(global);
                //global.analyzeCode(this);
                {if (true) return global;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ StaticStatement()
  final public StaticStatement StaticStatement() throws ParseException {
        List<VariableDeclaration> vars = new ArrayList<VariableDeclaration>();
        VariableDeclaration expr;
        Token token, token2;
        int pos,line,column;
    token = jj_consume_token(STATIC);
    expr = VariableDeclarator();
                vars.add(expr);
                pos = expr.getSourceEnd()+1;
                line=expr.getEndLine();
                column=expr.getEndColumn();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[146] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
      expr = VariableDeclarator();
                        vars.add(expr);
                        pos = expr.getSourceEnd()+1;
                        line=expr.getEndLine();
                        column=expr.getEndColumn();
    }
    try {
      token2 = jj_consume_token(SEMICOLON);
                 pos = token2.sourceEnd+1;line=token2.endLine;column=token2.endColumn;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "';' expected",
                        ";",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
                VariableDeclaration[] variables = new VariableDeclaration[vars.size()];
                vars.toArray(variables);
                {if (true) return new StaticStatement(variables,
                        token.sourceStart,
                        pos,
                        token.beginLine,
                        line,
                        token.beginColumn,
                        column);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ labelIdentifier()
  final public ConstantIdentifier labelIdentifier() throws ParseException {
        Token label;
    label = jj_consume_token(IDENTIFIER);
                {if (true) return new ConstantIdentifier(label);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ gotoStatement() method
  final public GotoStatement gotoStatement() throws ParseException {
        Token gotoToken;
        ConstantIdentifier label = null;
        Token semicolon = null;
        int pos,line,column;
    //{{{ <GOTO>
            gotoToken = jj_consume_token(GOTO);
                pos = gotoToken.sourceEnd;
                line = gotoToken.endLine;
                column = gotoToken.endColumn;
    try {
      label = labelIdentifier();
                        pos = label.getSourceEnd();
                        line = label.getEndLine();
                        column = label.getEndColumn();
    } catch (ParseException e) {
                fireParseError("label expected", "label",e.currentToken.next);
                semicolon = error_skipto(SEMICOLON);
                {
                        if (semicolon.kind == SEMICOLON)
                        {
                                pos = gotoToken.sourceEnd;
                                line = gotoToken.endLine;
                                column = gotoToken.endColumn;
                                {if (true) return new GotoStatement(gotoToken, label, pos,line,column);}
                        }
                }
    }
    try {
      semicolon = jj_consume_token(SEMICOLON);
                        pos = gotoToken.sourceEnd;
                        line = gotoToken.endLine;
                        column = gotoToken.endColumn;
    } catch (ParseException e) {
                fireParseError("';' expected", ";",e.currentToken);
    }
                {if (true) return new GotoStatement(gotoToken, label, pos,line,column);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ labeledStatement() method
  final public LabeledStatement labeledStatement() throws ParseException {
        ConstantIdentifier label;
        Statement statement = null;
    label = labelIdentifier();
    try {
                        Token colonToken;
      colonToken = jj_consume_token(COLON);
                        {if (true) return new LabeledStatement(label, colonToken.sourceEnd,
                                colonToken.endLine, colonToken.endColumn);}
    } catch (ParseException e) {
                fireParseError("':' expected", ":",e.currentToken);
                {
                        {if (true) return new LabeledStatement(label,
                                e.currentToken.sourceEnd,
                                e.currentToken.endLine,
                                e.currentToken.endColumn);}
                }
    }
    throw new Error("Missing return statement in function");
  }

//}}}

//{{{ Block()
/**
 * A Block is
 * {
 * statements
 * }.
 * @return a block
 */
  final public Block Block() throws ParseException {
        List<Statement> list = new ArrayList<Statement>();
        Statement statement;
        Token lbrace;
        Token rbrace;
        int pos,endLine,endColumn;
        int start, beginLine, beginColumn;
    try {
      lbrace = jj_consume_token(LBRACE);
                        pos         = lbrace.sourceEnd+1;
                        start       = lbrace.sourceStart;
                        beginLine   = lbrace.beginLine;
                        beginColumn = lbrace.beginColumn;
                        endLine     = lbrace.endLine;
                        endColumn   = lbrace.endColumn;
    } catch (ParseException e) {
                pos         = token.sourceEnd+1;
                start       = pos;
                beginLine   = token.endLine;
                beginColumn = token.endColumn;
                endLine     = token.endLine;
                endColumn   = token.endColumn;
                fireParseError("'{' expected","{",e.currentToken);
    }
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPEND:
      case ABSTRACT:
      case INTERFACE:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_44;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case INTERFACE:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        //{{{ BlockStatement()
                statement = BlockStatement();
                if (statement != null)
                {
                        list.add(statement);
                        pos         = statement.getSourceEnd()+1;
                        endLine     = statement.getEndLine();
                        endColumn   = statement.getEndColumn();
                }
        break;
      case PHPEND:
        //{{{ htmlBlock()
                statement = htmlBlock();
                if (statement != null)
                {
                        list.add(statement);
                        pos       = statement.getSourceEnd()+1;
                        endLine   = statement.getEndLine();
                        endColumn = statement.getEndColumn();
                }
                else
                {
                        pos       = token.sourceEnd+1;
                        endLine   = token.endLine;
                        endColumn = token.endColumn;
                }
        break;
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    try {
      rbrace = jj_consume_token(RBRACE);
                        pos       = rbrace.sourceEnd+1;
                        endLine   = rbrace.endLine;
                        endColumn = rbrace.endColumn;
    } catch (ParseException e) {
                fireParseError("'}' expected", "}", e.currentToken);
    }
                Statement[] statements = new Statement[list.size()];
                list.toArray(statements);
                {if (true) return new Block(statements,
                                 start,
                                 pos,
                                 beginLine,
                                 endLine,
                                 beginColumn,
                                 endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ BlockStatement() method
  final public Statement BlockStatement() throws ParseException {
        Statement statement = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      try {
        statement = Statement();
                        if (phpDocument == currentSegment)
                                pushOnAstNodes(statement);
      } catch (ParseException e) {
                Token semicolumn = error_skipto(SEMICOLON);
                Token nextToken = e.currentToken.next;
                if (nextToken == semicolumn)
                {
                        //{{{ Parse Error
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "statement expected",
                                "statement",
                                nextToken.image,
                                nextToken.sourceEnd,
                                semicolumn.sourceStart,
                                nextToken.endLine,
                                semicolumn.beginLine,
                                nextToken.endColumn,
                                semicolumn.beginColumn)); //}}}
                }
                else
                {
                        fireParseError("statement expected","statement",nextToken);
                }
      }
      break;
    case ABSTRACT:
    case FINAL:
    case CLASS:
      statement = classDeclaration();
      break;
    case INTERFACE:
      statement = interfaceDeclaration();
      break;
    case FUNCTION:
      statement = methodDeclaration(CONST_FUNCTION,null);
                if (phpDocument == currentSegment) pushOnAstNodes(statement);
                currentSegment.add((MethodDeclaration) statement);
                //((MethodDeclaration) statement).analyzeCode(this);

      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ BlockStatementNoBreak()
/**
 * A Block statement that will not contain any 'break'
 */
  final public Statement BlockStatementNoBreak() throws ParseException {
        Statement statement;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      statement = StatementNoBreak();
      break;
    case ABSTRACT:
    case FINAL:
    case CLASS:
      statement = classDeclaration();
      break;
    case FUNCTION:
      statement = methodDeclaration(CONST_FUNCTION,null);
                        currentSegment.add((MethodDeclaration) statement);
                        //((MethodDeclaration) statement).analyzeCode(this);

      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ LocalVariableDeclaration()
/**
 * used only by ForInit()
 */
  final public Expression[] LocalVariableDeclaration() throws ParseException {
        List<Expression> list = new ArrayList<Expression>();
        Expression var;
    var = Expression();
                list.add(var);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[151] = jj_gen;
        break label_45;
      }
      jj_consume_token(COMMA);
      var = Expression();
                                            list.add(var);
    }
                Expression[] vars = new Expression[list.size()];
                list.toArray(vars);
                {if (true) return vars;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ EmptyStatement()
/**
 * An empty statement.
 * It will generate an INFO marker
 *
 * @return an empty statement
 */
  final public EmptyStatement EmptyStatement() throws ParseException {
        Token token;
    token = jj_consume_token(SEMICOLON);
                /*    fireParseMessage(new PHPParseMessageEvent(INFO,
		path,
		"unneeded ';'",
		token.sourceStart,
		token.sourceEnd,
		token.beginLine,
		token.endLine,
		token.endColumn,
		token.endColumn+1));   */
                {if (true) return new EmptyStatement(token.sourceStart,
                        token.sourceEnd,
                        token.beginLine,
                        token.endLine,
                        token.beginColumn,
                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ SWITCH
//{{{ SwitchStatement()
  final public SwitchStatement SwitchStatement() throws ParseException {
        Expression variable;
        AbstractCase[] cases;
        Token switchToken,lparenToken,rparenToken;
        int pos;
    switchToken = jj_consume_token(SWITCH);
                                pos = switchToken.sourceEnd+1;
    try {
      lparenToken = jj_consume_token(LPAREN);
                        pos = lparenToken.sourceEnd+1;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "'(' expected",
                        "(",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
    try {
      variable = Expression();
                        pos = variable.getSourceEnd()+1;
    } catch (ParseException e) {
                if (errorMessage != null)
                        {if (true) throw e;}

                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "expression expected",
                        "expression",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
                variable = new ConstantIdentifier(SYNTAX_ERROR_CHAR,
                        pos,
                        pos,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1);
    }
    try {
      rparenToken = jj_consume_token(RPAREN);
                                        pos = rparenToken.sourceEnd+1;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "')' expected",
                        ")",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      cases = switchStatementBrace();
      break;
    case COLON:
      cases = switchStatementColon(switchToken.sourceStart, switchToken.sourceEnd);
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return new SwitchStatement(variable,
                        cases,
                        switchToken.sourceStart,
                        token.sourceEnd,
                        switchToken.beginLine,
                        token.endLine,
                        switchToken.beginColumn,
                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ switchStatementBrace()
  final public AbstractCase[] switchStatementBrace() throws ParseException {
        AbstractCase cas;
        List<AbstractCase> cases = new ArrayList<AbstractCase>();
        Token token;
        int pos;
    token = jj_consume_token(LBRACE);
                pos = token.sourceEnd;
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case _DEFAULT:
        ;
        break;
      default:
        jj_la1[153] = jj_gen;
        break label_46;
      }
      cas = switchLabel0();
                        cases.add(cas);
                        pos = cas.getSourceEnd();
    }
    try {
      token = jj_consume_token(RBRACE);
                 pos = token.sourceEnd;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "'}' expected",
                        "}",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
                AbstractCase[] abcase = new AbstractCase[cases.size()];
                cases.toArray(abcase);
                {if (true) return abcase;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ switchStatementColon(int start, int end)
/**
 * A Switch statement with : ... endswitch;
 * @param start the begin offset of the switch
 * @param end the end offset of the switch
 */
  final public AbstractCase[] switchStatementColon(int start, int end) throws ParseException {
        AbstractCase cas;
        List<AbstractCase> cases = new ArrayList<AbstractCase>();
        Token token;
        int pos;
    token = jj_consume_token(COLON);
                         pos = token.sourceEnd;
                fireParseMessage(new PHPParseMessageEvent(INFO,
                        WarningMessageClass.switchEndSwitch,
                        path,
                        "Ugly syntax detected, you should switch () {...} instead of switch (): ... enswitch;",
                        start,
                        end,
                        token.beginLine,
                        token.endLine,
                        token.beginColumn,
                        token.endColumn));
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case _DEFAULT:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_47;
      }
      cas = switchLabel0();
                        cases.add(cas);
                        pos = cas.getSourceEnd();
    }
    try {
      token = jj_consume_token(ENDSWITCH);
                                     pos = token.sourceEnd;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "'endswitch' expected",
                        "endswitch",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
    try {
      token = jj_consume_token(SEMICOLON);
                                     pos = token.sourceEnd;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "';' expected",
                        ";",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
                AbstractCase[] abcase = new AbstractCase[cases.size()];
                cases.toArray(abcase);
                {if (true) return abcase;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ switchLabel0()
  final public AbstractCase switchLabel0() throws ParseException {
        Expression expr;
        Statement statement;
        List<Statement> stmts = new ArrayList<Statement>();
        int start = token.next.sourceStart;
    expr = SwitchLabel();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPEND:
      case ABSTRACT:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[155] = jj_gen;
        break label_48;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case TRY:
      case THROW:
      case CLASS:
      case FUNCTION:
      case IF:
      case ARRAY:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        statement = BlockStatementNoBreak();
                                                     stmts.add(statement);
        break;
      case PHPEND:
        statement = htmlBlock();
                                                     if (statement != null) {stmts.add(statement);}
        break;
      case BREAK:
        statement = BreakStatement();
                                                     stmts.add(statement);
        break;
      default:
        jj_la1[156] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                int listSize = stmts.size();
                Statement[] stmtsArray = new Statement[listSize];
                stmts.toArray(stmtsArray);
                if (expr == null)
                {//it's a default
                        int end = this.token.next.sourceStart;
                        {if (true) return new DefaultCase(stmtsArray,
                                start,
                                end,
                                this.token.next.beginLine,
                                this.token.next.endLine,
                                this.token.next.beginColumn,
                                this.token.next.endColumn);}
                }
                if (listSize == 0)
                {
                        {if (true) return new Case(expr,
                                stmtsArray,
                                expr.getSourceStart(),
                                expr.getSourceEnd(),
                                expr.getBeginLine(),
                                expr.getEndLine(),
                                expr.getBeginColumn(),
                                expr.getEndColumn());}
                }
                else
                {
                        {if (true) return new Case(expr,
                                stmtsArray,
                                expr.getSourceStart(),
                                stmtsArray[listSize-1].getSourceEnd(),
                                expr.getBeginLine(),
                                stmtsArray[listSize-1].getEndLine(),
                                expr.getBeginColumn(),
                                stmtsArray[listSize-1].getEndColumn());}
                }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ SwitchLabel()
/**
 * A SwitchLabel.
 * case Expression() :
 * default :
 * @return the if it was a case and null if not
 */
  final public Expression SwitchLabel() throws ParseException {
        Expression expr;
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
      token = jj_consume_token(CASE);
      try {
        expr = Expression();
      } catch (ParseException e) {
                //todo ameliorer ca
                if (errorMessage != null) {if (true) throw e;}
                errorMessage = "expression expected after 'case' keyword";
                errorStart = token.sourceEnd;
                errorEnd   = token.sourceEnd +1;
                {if (true) throw e;}
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          jj_consume_token(COLON);
          break;
        case SEMICOLON:
          token = jj_consume_token(SEMICOLON);
                                fireParseMessage(new PHPParseMessageEvent(INFO,
                                        WarningMessageClass.caseSemicolon,
                                        path,
                                        "a ; was found in a case statement. You should use :",
                                        token));
          break;
        default:
          jj_la1[157] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
                //{{{ fireParseError
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "':' expected",
                        ":",
                        e.currentToken.image,
                        expr.getSourceEnd(),
                        expr.getSourceEnd()+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1)); //}}}

      }
                {if (true) return expr;}
      break;
    case _DEFAULT:
      token = jj_consume_token(_DEFAULT);
      try {
        jj_consume_token(COLON);
      } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "':' expected",
                        ":",
                        e.currentToken.image,
                        token.sourceEnd,
                        token.sourceEnd+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
      }
                {if (true) return null;}
      break;
    default:
      jj_la1[158] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ BreakStatement() method
  final public Break BreakStatement() throws ParseException {
        Expression expression = null;
        Token token, token2;
        int pos;
    token = jj_consume_token(BREAK);
                         pos = token.sourceEnd+1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expression = Expression();
                        pos = expression.getSourceEnd()+1;
      break;
    default:
      jj_la1[159] = jj_gen;
      ;
    }
    try {
      token2 = jj_consume_token(SEMICOLON);
                 pos = token2.sourceEnd;
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "';' expected",
                        ";",
                        e.currentToken.image,
                        pos,
                        pos+1,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn+1));
    }
                {if (true) return new Break(expression, token.sourceStart, pos,
                        token.beginLine,token.endLine,token.beginColumn,
                        token.endColumn);}
    throw new Error("Missing return statement in function");
  }

//}}}

//{{{ condition() method
  final public Expression condition(String keyword) throws ParseException {
  Expression condition;
    try {
      jj_consume_token(LPAREN);
    } catch (ParseException e) {
    fireParseError(new PHPParseErrorEvent(ERROR,
                                          path,
                                          "'(' expected",
                                          "(",
                                          e.currentToken.image,
                                          token.sourceEnd,
                                          token.sourceEnd+1,
                                          e.currentToken.beginLine,
                                          e.currentToken.endLine,
                                          e.currentToken.endColumn,
                                          e.currentToken.endColumn+1));
    }
    condition = Expression();
    try {
      jj_consume_token(RPAREN);
    } catch (ParseException e) {
    fireParseError(new PHPParseErrorEvent(ERROR,
                                          path,
                                          "')' expected",
                                          ")",
                                          e.currentToken.image,
                                          condition.getSourceEnd(),
                                          condition.getSourceEnd()+1,
                                          e.currentToken.beginLine,
                                          e.currentToken.endLine,
                                          e.currentToken.endColumn,
                                          e.currentToken.endColumn+1));
    }
                {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ IF
//{{{ ifStatement method
  final public IfStatement ifStatement() throws ParseException {
  Expression condition;
  IfStatement ifStatement;
  Token ifToken;
    ifToken = jj_consume_token(IF);
    condition = condition("if");
    ifStatement = ifStatementAction(condition,ifToken);
    {if (true) return ifStatement;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ statementList()
  final public List<Statement> statementList() throws ParseException {
        List<Statement> list = new ArrayList<Statement>();
        Statement statement;
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PHPEND:
      case TRY:
      case THROW:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[160] = jj_gen;
        break label_49;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRY:
      case THROW:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        statement = Statement();
                        list.add(statement);
        break;
      case PHPEND:
        statement = htmlBlock();
                        if (statement != null)
                                list.add(statement);
        break;
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ifStatementAction() method
  final public IfStatement ifStatementAction(Expression condition, Token ifToken) throws ParseException {
        Statement statement;
        Statement stmt;
        Statement[] statementsArray;
        ElseIf elseifStatement;
        Else elseStatement = null;
        List<Statement> stmts;
        List<ElseIf> elseIfList = new ArrayList<ElseIf>();
        ElseIf[] elseIfs;
        Token colonToken, elseToken;
        int sourceEnd = 0;
        int endColumn = 0;
        int endLine   = 0;
        Token semiColonToken;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      colonToken = jj_consume_token(COLON);
      stmts = statementList();
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ELSEIF:
          ;
          break;
        default:
          jj_la1[162] = jj_gen;
          break label_50;
        }
        elseifStatement = elseIfStatementColon();
                        elseIfList.add(elseifStatement);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        elseStatement = elseStatementColon();
        break;
      default:
        jj_la1[163] = jj_gen;
        ;
      }
                fireParseMessage(new PHPParseMessageEvent(INFO,
                        WarningMessageClass.ifEndIf,
                        path,
                        "Ugly syntax detected, you should if () {...} instead of if (): ... endif;",
                        colonToken));
      try {
        jj_consume_token(ENDIF);
      } catch (ParseException e) {
                errorMessage = "'endif' expected";
                errorStart = e.currentToken.sourceStart;
                errorEnd   = e.currentToken.sourceEnd;
                {if (true) throw e;}
      }
      try {
        semiColonToken = jj_consume_token(SEMICOLON);
                        sourceEnd = semiColonToken.sourceStart;
                        endLine   = semiColonToken.beginLine;
                        endColumn = semiColonToken.beginColumn;
      } catch (ParseException e) {
                errorMessage = "';' expected after 'endif' keyword";
                errorStart = e.currentToken.sourceStart;
                errorEnd   = e.currentToken.sourceEnd;
                {if (true) throw e;}
      }
                elseIfs = new ElseIf[elseIfList.size()];
                elseIfList.toArray(elseIfs);
                if (stmts.size() == 1)
                {
                        {if (true) return new IfStatement(condition,
                                stmts.get(0),
                                elseIfs,
                                        elseStatement,
                                        ifToken.sourceStart,
                                sourceEnd,
                                ifToken.beginLine,
                                endLine,
                                ifToken.beginColumn,
                                endColumn);}
                }
                else
                {
                        statementsArray = new Statement[stmts.size()];
                        stmts.toArray(statementsArray);
                        {if (true) return new IfStatement(condition,
                                new Block(statementsArray,
                                        colonToken.sourceEnd,
                                        sourceEnd,
                                        colonToken.endLine,
                                        endLine,
                                        colonToken.endColumn,
                                        endColumn),
                                elseIfs,
                                        elseStatement,
                                        ifToken.sourceStart,
                                sourceEnd,
                                ifToken.beginLine,
                                endLine,
                                ifToken.beginColumn,
                                endColumn);}
                }
      break;
    case PHPEND:
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRY:
      case THROW:
      case IF:
      case ARRAY:
      case BREAK:
      case LIST:
      case PRINT:
      case ECHO:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case GLOBAL:
      case STATIC:
      case CONTINUE:
      case DO:
      case FOR:
      case NEW:
      case CLONE:
      case RETURN:
      case SWITCH:
      case WHILE:
      case FOREACH:
      case DEFINE:
      case GOTO:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case LBRACE:
        stmt = Statement();
        break;
      case PHPEND:
        stmt = htmlBlock();
        break;
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ELSEIF:
          ;
          break;
        default:
          jj_la1[165] = jj_gen;
          break label_51;
        }
        elseifStatement = elseIfStatement();
                                                                  elseIfList.add(elseifStatement);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        elseToken = jj_consume_token(ELSE);
        try {
          statement = Statement();
                 elseStatement = new Else(statement,
                                elseToken.sourceStart,
                                        statement.getSourceEnd(),
                                elseToken.beginLine,
                                        statement.getEndLine(),
                                elseToken.beginColumn,
                statement.getEndColumn());
        } catch (ParseException e) {
                if (errorMessage != null)
                {
                        {if (true) throw e;}
                }
                errorMessage = "unexpected token '"+e.currentToken.next.image+"', a statement was expected";
                errorStart = e.currentToken.sourceStart;
                errorEnd   = e.currentToken.sourceEnd;
                {if (true) throw e;}
        }
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
                elseIfs = new ElseIf[elseIfList.size()];
                elseIfList.toArray(elseIfs);
                {if (true) return new IfStatement(condition,
                        stmt,
                        elseIfs,
                                elseStatement,
                                ifToken.sourceStart,
                        sourceEnd,
                        ifToken.beginLine,
                        endLine,
                        ifToken.beginColumn,
                        endColumn);}
      break;
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ elseIfStatementColon() method
  final public ElseIf elseIfStatementColon() throws ParseException {
        Expression condition;
        List<Statement> list;
        Token elseifToken;
    elseifToken = jj_consume_token(ELSEIF);
    condition = condition("elseif");
    jj_consume_token(COLON);
    list = statementList();
                int sizeList = list.size();
                Statement[] stmtsArray = new Statement[sizeList];
                list.toArray(stmtsArray);
                {if (true) return new ElseIf(condition,
                        stmtsArray,
                        elseifToken.sourceStart,
                                stmtsArray[sizeList-1].getSourceEnd(),
                        elseifToken.beginLine,
                                stmtsArray[sizeList-1].getEndLine(),
                        elseifToken.beginColumn,
                        stmtsArray[sizeList-1].getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ elseStatementColon()
  final public Else elseStatementColon() throws ParseException {
        List<Statement> list;
        Token elseToken;
        Token colonToken;
    elseToken = jj_consume_token(ELSE);
    colonToken = jj_consume_token(COLON);
    list = statementList();
                int sizeList = list.size();
                Statement[] stmtsArray = new Statement[sizeList];
                if (sizeList == 0)
                {
                        {if (true) return new Else(stmtsArray,
                                        elseToken.sourceStart,
                                        colonToken.sourceEnd,
                                        elseToken.beginLine,
                                        colonToken.endLine,
                                        elseToken.beginColumn,
                                        colonToken.endColumn);}
                }

                list.toArray(stmtsArray);
                {if (true) return new Else(stmtsArray,
                        elseToken.sourceStart,
                                stmtsArray[sizeList-1].getSourceEnd(),
                        elseToken.beginLine,
                                stmtsArray[sizeList-1].getEndLine(),
                        elseToken.beginColumn,
                                stmtsArray[sizeList-1].getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ elseIfStatement() method
  final public ElseIf elseIfStatement() throws ParseException {
        Expression condition;
        Token elseifToken;
        Statement[] statement = new Statement[1];
    elseifToken = jj_consume_token(ELSEIF);
    condition = condition("elseif");
    statement[0] = Statement();
                {if (true) return new ElseIf(condition,
                        statement,
                        elseifToken.sourceStart,
                                statement[0].getSourceEnd(),
                        elseifToken.beginLine,
                                statement[0].getEndLine(),
                        elseifToken.beginColumn,
                                statement[0].getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ WHILE
//{{{ WhileStatement()
  final public WhileStatement WhileStatement() throws ParseException {
  Expression condition;
  Statement action;
  Token whileToken;
    whileToken = jj_consume_token(WHILE);
    condition = condition("while");
    action = WhileStatementAction(whileToken);
      {if (true) return new WhileStatement(condition,
                               action,
                               whileToken.sourceStart,
                               action.getSourceEnd(),
                               whileToken.beginLine,
                               action.getEndLine(),
                               whileToken.beginColumn,
                               action.getEndColumn());}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ WhileStatementAction(Token whileToken)
  final public Statement WhileStatementAction(Token whileToken) throws ParseException {
        Statement statement;
        List<Statement> stmts;
        Token colonToken;
        int end;
        int endLine;
        int endColumn;
        Token semicolonToken;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      colonToken = jj_consume_token(COLON);
      stmts = statementList();
                fireParseMessage(new PHPParseMessageEvent(INFO,
                        WarningMessageClass.whileEndWhile,
                        path,
                        "Ugly syntax detected, you should while () {...} instead of while (): ... endwhile;",
                        colonToken));
      try {
        jj_consume_token(ENDWHILE);
      } catch (ParseException e) {
                errorMessage = "'endwhile' expected";
                errorStart = e.currentToken.sourceStart;
                errorEnd   = e.currentToken.sourceEnd;
                {if (true) throw e;}
      }
      try {
        semicolonToken = jj_consume_token(SEMICOLON);
                        end       = semicolonToken.sourceEnd;
                        endLine   = semicolonToken.beginLine;
                        endColumn = semicolonToken.beginColumn;
                        Statement[] stmtsArray = new Statement[stmts.size()];
                        stmts.toArray(stmtsArray);
                        {if (true) return new Block(stmtsArray,
                                whileToken.sourceStart,
                                end,
                                whileToken.beginLine,
                                endLine,
                                whileToken.beginColumn,
                                endColumn);}
      } catch (ParseException e) {
                errorMessage = "';' expected after 'endwhile' keyword";
                errorStart = e.currentToken.sourceStart;
                errorEnd   = e.currentToken.sourceEnd;
                {if (true) throw e;}
      }
      break;
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      statement = Statement();
                {if (true) return statement;}
      break;
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//}}}

//{{{ DoStatement()
  final public DoStatement DoStatement() throws ParseException {
  Statement action;
  Expression condition;
  Token token;
  Token token2 = null;
    token = jj_consume_token(DO);
    action = Statement();
    jj_consume_token(WHILE);
    condition = condition("while");
    try {
      token2 = jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
    fireParseError(new PHPParseErrorEvent(ERROR,
                                          path,
                                          "';' expected",
                                          ";",
                                          e.currentToken.image,
                                          condition.getSourceEnd(),
                                          condition.getSourceEnd()+1,
                                          e.currentToken.beginLine,
                                          e.currentToken.endLine,
                                          e.currentToken.endColumn,
                                          e.currentToken.endColumn+1));
    }
    if (token2 == null) {
      {if (true) return new DoStatement(condition,
                             action,
                             token.sourceStart,
                             condition.getSourceEnd(),
                             token.beginLine,
                             condition.getEndLine(),
                             token.beginColumn,
                             condition.getEndColumn());}
    }
    {if (true) return new DoStatement(condition,
                           action,
                           token.sourceStart,
                           token2.sourceEnd,
                           token.beginLine,
                           token2.endLine,
                           token.beginColumn,
                           token2.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ForeachStatement()
  final public ForeachStatement ForeachStatement() throws ParseException {
        Statement statement = null;
        Expression expression = null;
        ArrayVariableDeclaration variable = null;
        Token foreachToken;
        Token lparenToken;
        Token asToken;
        Token rparenToken;
        int pos,endLine,endColumn;
        Token tokenEndForeach, tokenColon, tokenSemicolon;
        List<Statement> list;
    foreachToken = jj_consume_token(FOREACH);
    try {
      lparenToken = jj_consume_token(LPAREN);
                        pos       = lparenToken.sourceEnd+1;
                        endLine   = lparenToken.endLine;
                        endColumn = lparenToken.endColumn;
    } catch (ParseException e) {
                fireParseError("'(' expected", "(", e.currentToken);
                {
                        pos       = foreachToken.sourceEnd+1;
                        endLine   = foreachToken.endLine;
                        endColumn = foreachToken.endColumn;
                }
    }
    try {
      expression = Expression();
                        pos       = expression.getSourceEnd()+1;
                        endLine   = expression.getEndLine();
                        endColumn = expression.getEndColumn();
    } catch (ParseException e) {
                fireParseError("variable expected", "variable", e.currentToken);
    }
    try {
      asToken = jj_consume_token(AS);
                        pos       = asToken.sourceEnd+1;
                        endLine   = asToken.endLine;
                        endColumn = asToken.endColumn;
    } catch (ParseException e) {
                fireParseError("'as' expected", "as", e.currentToken);
    }
    try {
      variable = ArrayVariable();
                        pos       = variable.getSourceEnd()+1;
                        endLine   = variable.getEndLine();
                        endColumn = variable.getEndColumn();
    } catch (ParseException e) {
                if (errorMessage != null) {if (true) throw e;}
                fireParseError("variable expected", "variable", e.currentToken);
    }
    try {
      rparenToken = jj_consume_token(RPAREN);
                        pos       = rparenToken.sourceEnd+1;
                        endLine   = rparenToken.endLine;
                        endColumn = rparenToken.endColumn;
    } catch (ParseException e) {
                fireParseError("')' expected", ")", e.currentToken);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      try {
        statement = Statement();
                                pos       = statement.getSourceEnd()+1;
                                endLine   = statement.getEndLine();
                                endColumn = statement.getEndColumn();
      } catch (ParseException e) {
                        if (errorMessage != null) {if (true) throw e;}
                        fireParseError("statement expected", "statement", e.currentToken);
      }
                        {if (true) return new ForeachStatement(expression,
                                variable,
                                statement,
                                foreachToken.sourceStart,
                                pos,
                                foreachToken.beginLine,
                                endLine,
                                foreachToken.beginColumn,
                                endColumn);}
      break;
    case COLON:
      //{{{ : statement endforeach;
                      tokenColon = jj_consume_token(COLON);
                        pos = tokenColon.sourceEnd+1;
      list = statementList();
                        fireParseMessage(new PHPParseMessageEvent(INFO,
                                WarningMessageClass.foreachEndForeach,
                                path,
                                "Ugly syntax detected, you should foreach () {...} instead of foreach (): ... endforeach;",
                                tokenColon));
      try {
        tokenEndForeach = jj_consume_token(ENDFOREACH);
                                pos = tokenEndForeach.sourceEnd+1;
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "'endforeach' expected",
                                "endforeach",
                                e.currentToken.image,
                                pos,
                                pos+1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
      try {
        tokenSemicolon = jj_consume_token(SEMICOLON);
                                pos = tokenSemicolon.sourceEnd+1;
      } catch (ParseException e) {
                        fireParseError("';' expected", ";", e.currentToken);
      }
                        if (list.isEmpty())
                        {
                                {if (true) return new ForeachStatement(expression,
                                        variable,
                                        null,
                                        foreachToken.sourceStart,
                                        pos,
                                        foreachToken.beginLine,
                                        endLine,
                                        foreachToken.beginColumn,
                                        endColumn);}
                        }
                        else
                        {
                                Statement[] stmtsArray = new Statement[list.size()];
                                list.toArray(stmtsArray);
                                {if (true) return new ForeachStatement(expression,
                                        variable,
                                        new Block(stmtsArray,
                                                stmtsArray[0].getSourceStart(),
                                                stmtsArray[stmtsArray.length-1].getSourceEnd(),
                                                stmtsArray[0].getBeginLine(),
                                                stmtsArray[stmtsArray.length-1].getEndLine(),
                                                stmtsArray[0].getBeginColumn(),
                                                stmtsArray[stmtsArray.length-1].getEndColumn()),
                                        foreachToken.sourceStart,
                                        pos,
                                        foreachToken.beginLine,
                                        endLine,
                                        foreachToken.beginColumn,
                                        endColumn);}
                        }
      break;
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ FOR
//{{{ ForStatement()
/**
 * a for declaration.
 * @return a node representing the for statement
 */
  final public ForStatement ForStatement() throws ParseException {
        Token forToken,tokenEndFor,token2,tokenColon;
        int pos;
        Expression[] initializations = null;
        Expression condition = null;
        Expression[] increments = null;
        Statement action;
        List<Statement> list;
        int end;
        int endLine;
        int endColumn;
    forToken = jj_consume_token(FOR);
    try {
      jj_consume_token(LPAREN);
    } catch (ParseException e) {
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "'(' expected",
                        "(",
                        e.currentToken.image,
                        forToken.sourceEnd,
                        forToken.sourceEnd,
                        e.currentToken.beginLine,
                        e.currentToken.endLine,
                        e.currentToken.endColumn,
                        e.currentToken.endColumn));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      initializations = ForInit();
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      condition = Expression();
      break;
    default:
      jj_la1[171] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      increments = StatementExpressionList();
      break;
    default:
      jj_la1[172] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRY:
    case THROW:
    case IF:
    case ARRAY:
    case BREAK:
    case LIST:
    case PRINT:
    case ECHO:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case GLOBAL:
    case STATIC:
    case CONTINUE:
    case DO:
    case FOR:
    case NEW:
    case CLONE:
    case RETURN:
    case SWITCH:
    case WHILE:
    case FOREACH:
    case DEFINE:
    case GOTO:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
    case SEMICOLON:
    case LBRACE:
      action = Statement();
                        {if (true) return new ForStatement(initializations,
                                condition,
                                increments,
                                action,
                                forToken.sourceStart,
                                action.getSourceEnd(),
                                forToken.beginLine,
                                action.getEndLine(),
                                forToken.beginColumn,
                                action.getEndColumn());}
      break;
    case COLON:
      tokenColon = jj_consume_token(COLON);
                        pos = tokenColon.sourceEnd+1;
      list = statementList();
                        fireParseMessage(new PHPParseMessageEvent(INFO,
                                WarningMessageClass.forEndFor,
                                path,
                                "Ugly syntax detected, you should for () {...} instead of for (): ... endfor;",
                                tokenColon));
      try {
        tokenEndFor = jj_consume_token(ENDFOR);
                                pos = tokenEndFor.sourceEnd+1;
      } catch (ParseException e) {
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "'endfor' expected",
                                "endfor",
                                e.currentToken.image,
                                pos,
                                pos,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn));
      }
      try {
        token2 = jj_consume_token(SEMICOLON);
                                pos = token2.sourceEnd+1;
                                end       = token2.sourceEnd;
                                endLine   = token2.endLine;
                                endColumn = token2.endColumn;
      } catch (ParseException e) {
                        end       = e.currentToken.sourceEnd;
                        endLine   = e.currentToken.endLine;
                        endColumn = e.currentToken.endColumn;
                        fireParseError(new PHPParseErrorEvent(ERROR,
                                path,
                                "';' expected",
                                ";",
                                e.currentToken.image,
                                pos,
                                pos+1,
                                e.currentToken.beginLine,
                                e.currentToken.endLine,
                                e.currentToken.endColumn,
                                e.currentToken.endColumn+1));
      }
                        Statement[] stmtsArray = new Statement[list.size()];
                        list.toArray(stmtsArray);
                        {if (true) return new ForStatement(initializations,
                                condition,
                                increments,
                                new Block(stmtsArray,
                                        stmtsArray[0].getSourceStart(),
                                        stmtsArray[stmtsArray.length-1].getSourceEnd(),
                                        stmtsArray[0].getBeginLine(),
                                        stmtsArray[stmtsArray.length-1].getEndLine(),
                                        stmtsArray[0].getBeginColumn(),
                                        stmtsArray[stmtsArray.length-1].getEndColumn()),
                                forToken.sourceStart,
                                end,
                                forToken.beginLine,
                                endLine,
                                forToken.beginColumn,
                                endColumn);}
      break;
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ForInit()
  final public Expression[] ForInit() throws ParseException {
        Expression[] exprs;
    if (jj_2_9(2147483647)) {
      exprs = LocalVariableDeclaration();
         {if (true) return exprs;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case LIST:
      case PRINT:
      case INCLUDE:
      case REQUIRE:
      case INCLUDE_ONCE:
      case REQUIRE_ONCE:
      case STATIC:
      case NEW:
      case CLONE:
      case DEFINE:
      case NULL:
      case SUPER:
      case THIS:
      case TRUE:
      case FALSE:
      case STRING:
      case OBJECT:
      case BOOL:
      case BOOLEAN:
      case REAL:
      case DOUBLE:
      case FLOAT:
      case INT:
      case INTEGER:
      case AT:
      case BANG:
      case TILDE:
      case PLUS_PLUS:
      case MINUS_MINUS:
      case PLUS:
      case MINUS:
      case BIT_AND:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case DOUBLEQUOTE:
      case HEREDOCSTARTTOKEN:
      case DOLLAR:
      case IDENTIFIER:
      case NAMESPACE_IDENTIFIER:
      case LPAREN:
        exprs = StatementExpressionList();
         {if (true) return exprs;}
        break;
      default:
        jj_la1[174] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  //}}}
//}}}

//{{{ StatementExpressionList()
  final public Expression[] StatementExpressionList() throws ParseException {
        List<Expression> list = new ArrayList<Expression>();
        Expression expr;
    expr = Expression();
                list.add(expr);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[175] = jj_gen;
        break label_52;
      }
      jj_consume_token(COMMA);
      Expression();
                        list.add(expr);
    }
                Expression[] exprsArray = new Expression[list.size()];
                list.toArray(exprsArray);
                {if (true) return exprsArray;}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ContinueStatement()
  final public Continue ContinueStatement() throws ParseException {
        Expression expr = null;
        Token continueToken;
        Token semicolonToken = null;
    continueToken = jj_consume_token(CONTINUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = Expression();
      break;
    default:
      jj_la1[176] = jj_gen;
      ;
    }
    try {
      semicolonToken = jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
                fireParseError("';' expected", ";", e.currentToken);
    }
                if (semicolonToken == null)
                {
                        if (expr == null)
                        {
                                {if (true) return new Continue(expr,
                                        continueToken.sourceStart,
                                        continueToken.sourceEnd,
                                        continueToken.beginLine,
                                        continueToken.endLine,
                                        continueToken.beginColumn,
                                        continueToken.endColumn);}
                        }
                        {if (true) return new Continue(expr,continueToken.sourceStart,
                                expr.getSourceEnd(),continueToken.beginLine,
                                expr.getEndLine(),continueToken.beginColumn,
                                expr.getEndColumn());}
                }
                {if (true) return new Continue(expr,continueToken.sourceStart,
                        semicolonToken.sourceEnd,continueToken.beginLine,
                        semicolonToken.endLine,continueToken.beginColumn,
                        semicolonToken.endColumn);}
    throw new Error("Missing return statement in function");
  }

  //}}}

//{{{ ReturnStatement()
/**
 * A return statement.
 * It's return [expression];
 * @return a ReturnStatement
 */
  final public ReturnStatement ReturnStatement() throws ParseException {
        Statement expr = null;
        Token returnToken;
        Token semicolonToken;
        int end       = 0;
        int endLine   = 0;
        int endColumn = 0;
    returnToken = jj_consume_token(RETURN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case LIST:
    case PRINT:
    case INCLUDE:
    case REQUIRE:
    case INCLUDE_ONCE:
    case REQUIRE_ONCE:
    case STATIC:
    case NEW:
    case CLONE:
    case DEFINE:
    case NULL:
    case SUPER:
    case THIS:
    case TRUE:
    case FALSE:
    case STRING:
    case OBJECT:
    case BOOL:
    case BOOLEAN:
    case REAL:
    case DOUBLE:
    case FLOAT:
    case INT:
    case INTEGER:
    case AT:
    case BANG:
    case TILDE:
    case PLUS_PLUS:
    case MINUS_MINUS:
    case PLUS:
    case MINUS:
    case BIT_AND:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case DOUBLEQUOTE:
    case HEREDOCSTARTTOKEN:
    case DOLLAR:
    case IDENTIFIER:
    case NAMESPACE_IDENTIFIER:
    case LPAREN:
      expr = Expression();
                        end       = expr.getSourceEnd();
                        endLine   = expr.getEndLine();
                        endColumn = expr.getEndColumn();
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
    try {
      semicolonToken = jj_consume_token(SEMICOLON);
                        end       = semicolonToken.sourceEnd;
                        endLine   = semicolonToken.endLine;
                        endColumn = semicolonToken.endColumn;
    } catch (ParseException e) {
                if (end == 0)
                {
                        end       = e.currentToken.sourceEnd;
                        endLine   = e.currentToken.endLine;
                        endColumn = e.currentToken.endColumn;
                }
                //{{{ fireParseError
                fireParseError(new PHPParseErrorEvent(ERROR,
                        path,
                        "';' expected",
                        ";",
                        e.currentToken.image,
                        end,
                        e.currentToken.sourceEnd,
                        endLine,
                        e.currentToken.endLine,
                        endColumn,
                        e.currentToken.endColumn)); //}}}

    }
                {if (true) return new ReturnStatement(expr,
                        returnToken.sourceStart,
                        end,
                        returnToken.beginLine,
                        endLine,
                        returnToken.beginColumn,
                        endColumn);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_3R_344() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_scan_token(BANG)) return true;
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_412() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_308() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(PHPEND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_214()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) return true;
    }
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(BANG)) return true;
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_scan_token(ELSEIF)) return true;
    if (jj_3R_311()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(HEREDOCSTARTTOKEN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_253() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_3R_247()) return true;
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) return true;
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_121()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_354()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) return true;
    }
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_3R_247()) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(BIT_AND)) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_3R_388()) return true;
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3R_370()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_371()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_372()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_198() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_174()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_198()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_241()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_242()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(DEFINE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    }
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_160() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_189()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_3R_227()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_228()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(DOLLAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_209()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_3R_387()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_3R_386()) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_368()) jj_scanpos = xsp;
    if (jj_scan_token(ENDIF)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) return true;
    }
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_151()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    }
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_151()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_172()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_218()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_219()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_75()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_192()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_193()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_376() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_376()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_375()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(CONST)) return true;
    if (jj_3R_305()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_306()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(CLASSACCESS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) return true;
    }
    }
    }
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_311()) return true;
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_351() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) return true;
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_3R_203()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_204()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(GOTO)) return true;
    if (jj_3R_75()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(DOLLAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) {
    jj_scanpos = xsp;
    if (jj_3R_401()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(STATIC)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_337()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_151()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(INSTANCEOF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(PUBLIC)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_69()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_277() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) return true;
    }
    return false;
  }

  private boolean jj_3R_237() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    }
    return false;
  }

  private boolean jj_3R_251() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_391()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_324()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_scan_token(STATICCLASSACCESS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) return true;
    }
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    if (jj_scan_token(ENDFOR)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_scan_token(STATIC)) return true;
    if (jj_3R_324()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_325()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_3R_391()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_392()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_220()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_250()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_3R_351()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_237()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) return true;
    }
    }
    }
    }
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_scan_token(VAR)) return true;
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) return true;
    }
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_3R_190()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_191()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(ARRAY)) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_3R_393()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_394()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_scan_token(GLOBAL)) return true;
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_326()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_358() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_379()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_187()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_238() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(109)) jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_3R_411()) return true;
    }
    return false;
  }

  private boolean jj_3R_398() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_355()) return true;
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_121()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_356()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) return true;
    }
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(CLONE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    }
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_301() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(BIT_XOR)) return true;
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_3R_327()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_scan_token(FINALLY)) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_177()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_180()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_scan_token(TRY)) return true;
    if (jj_3R_183()) return true;
    if (jj_3R_327()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_328()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_393() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) return true;
    }
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    if (jj_scan_token(ENDFOREACH)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_399() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) {
    jj_scanpos = xsp;
    if (jj_3R_409()) {
    jj_scanpos = xsp;
    if (jj_3R_410()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(USE)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_3R_398()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_399()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_181()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) jj_scanpos = xsp;
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_377() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_3R_169()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_175()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(ECHO)) return true;
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_323()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_3R_393()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_362() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_380()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(NEW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_130()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_295()) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_294()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_126()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_138()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_293()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_3R_292()) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_385()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) return true;
    }
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_334() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_360()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_238()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) return true;
    }
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) return true;
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_366()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDSWITCH)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_245() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_125()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_54()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_scan_token(FOREACH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_54()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    }
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_3R_385()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_120()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_365()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_101()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_112()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_178()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_179()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_69()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(ARRAYASSIGN)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_3R_346()) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_275()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    }
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(LIST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_108()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_3R_142()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_254()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_231() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) return true;
    }
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_222()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_3R_311()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(PRINT)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_276()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_405() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_scan_token(PHPECHOSTART)) return true;
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(146)) jj_scanpos = xsp;
    if (jj_scan_token(PHPEND)) return true;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_3R_81()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_405()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_229() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(BANG)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) return true;
    }
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(DOLLARS)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_353()) return true;
    if (jj_scan_token(ENDWHILE)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_313() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) return true;
    }
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(DOLLARBRACE)) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_55()) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_55()) return true;
    if (jj_3R_56()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_69()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(DOUBLEQUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_82()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) return true;
    }
    return false;
  }

  private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    }
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3R_384()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_220()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_300()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_3R_311()) return true;
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_scan_token(ELSEIF)) return true;
    if (jj_3R_311()) return true;
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_76()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_137()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public PHPParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[178];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x6000001e,0x6,0x6,0x6000001e,0x0,0x60000000,0x60000000,0x60000000,0x60000000,0x60000000,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x4000000,0x4000000,0x4000000,0x4000000,0x0,0x0,0x20000000,0x0,0x0,0x80000000,0x3c000000,0x3c000000,0x1c000000,0x20000000,0x1c000000,0x20000000,0x3c000000,0x1c000000,0x20000000,0x1c000000,0x20000000,0x1c000000,0x20000000,0x3c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c000000,0x1c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000010,0x60000010,0x60000000,0x20000000,0x0,0x0,0x0,0x0,0x20000010,0x20000010,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x10,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0xd6ffe5eb,0x0,0x0,0xd6ffe5eb,0x0,0xd6ffe5eb,0xd6ffe5eb,0xd6ffe56b,0xd6ffe56b,0xd6ffe56b,0xd6ffe56b,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x2800040,0x800000,0x0,0x800000,0x800000,0x2800040,0x0,0x1,0x21,0x20000000,0x0,0x0,0x2800241,0x2800241,0x800000,0x1,0x800000,0x41,0x2800241,0x800000,0x1,0x800000,0x1,0x800000,0x41,0x2800241,0x0,0x88005e60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x88005e60,0x88007e60,0x0,0x80bda000,0x0,0x0,0x100,0x0,0x0,0x88005e60,0x0,0x0,0x2000,0x2000,0x2000,0x0,0x0,0x80bda000,0x80bca040,0x80bca000,0x80bca000,0x0,0x80bda000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x88005e60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80bca000,0x80bca000,0x80bca000,0x0,0x80bca000,0x2000,0x0,0x0,0x80bca000,0x800000,0x0,0x0,0x80800000,0x0,0x0,0x0,0x88005e60,0x0,0x0,0x0,0x88005e60,0x808001,0x8880de61,0x80bda000,0x80bda000,0x0,0x0,0x0,0x0,0x0,0x80bda040,0x0,0x80bda040,0x54c2040a,0x4,0x10,0x0,0xd4ffe40a,0x0,0x0,0x3c0000,0x80bca000,0x0,0x0,0x0,0x0,0x0,0x0,0xd4ffe46b,0xd4ffe46b,0xd4ffe46b,0xd4ffa46b,0x0,0x0,0x9000000,0x9000000,0xd4ffe46b,0xd4ffe46b,0x0,0x9000000,0x80bda000,0xd4ffe40a,0xd4ffe40a,0x800,0x1000,0xd4ffe40a,0x800,0x1000,0xd4ffe40a,0xd4ffe40a,0xd4ffe40a,0x80bda000,0x80bda000,0x80bda000,0xd4ffe40a,0x80bda000,0x0,0x80bda000,0x80bda000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0xffdfc20f,0x0,0x0,0xffdfc20f,0x0,0xffdfc20f,0xffdfc20f,0xffdfc20f,0xffdfc20f,0xffdfc20f,0xffdfc20f,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fdfc001,0x0,0x0,0x0,0x0,0x1800,0x0,0x0,0x0,0x1800,0x7fdfc001,0x7fdfc001,0x2000,0xffdf4001,0x0,0x0,0x0,0x0,0x10000,0x7fdfc001,0x7fc64000,0x0,0x0,0x0,0x0,0x0,0x7fc00000,0xffdf4001,0xffdf4001,0xffdf4001,0xffc64001,0x0,0xffdf4001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fdfc001,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffdf4001,0xffdf4001,0x7fdf4001,0x0,0x7fdf4001,0x7fc00000,0x0,0x0,0x7fc64001,0x7fc64000,0x1800,0x1800,0x7fc64000,0x0,0x0,0x0,0x7fdfc001,0x0,0x0,0x1800,0x7fdfc001,0x0,0x7fdfc001,0xffdf4001,0xffdf4001,0x0,0x190000,0x0,0x0,0x0,0xffdf4001,0x0,0xffdf4001,0xc20e,0x0,0x0,0x0,0xffdfc20f,0x0,0x0,0x0,0x7fdf4001,0x0,0x0,0x0,0x0,0x0,0x0,0xffdfc20f,0xffdfc20f,0xffdfc20f,0xffdfc20f,0x0,0x0,0x0,0x0,0xffdfc20f,0xffdfc20f,0x0,0x0,0xffdf4001,0xffdfc20f,0xffdfc20f,0x0,0x0,0xffdfc20f,0x0,0x0,0xffdfc20f,0xffdfc20f,0xffdfc20f,0xffdf4001,0xffdf4001,0xffdf4001,0xffdfc20f,0xffdf4001,0x0,0xffdf4001,0xffdf4001,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x288023c3,0x0,0x0,0x288023c3,0x0,0x288023c3,0x288023c3,0x288023c3,0x288023c3,0x288023c3,0x288023c3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300,0x8800000,0x0,0x0,0x300,0x0,0x288023c3,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x2000,0x0,0x288023c3,0x288023c3,0x288023c3,0x2003,0x0,0x288023cb,0x4,0x300010,0x300010,0x400020,0x400020,0x0,0x4000,0x8000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000,0xe0000,0x300,0x300,0x10c00,0x10c00,0x288023c3,0x288023c1,0x288023c0,0xc0,0x28802000,0x0,0xc0,0xc0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x288023c3,0x288023c3,0x0,0x28800000,0x0,0x0,0x0,0x288023c3,0x0,0x288023c3,0x0,0x0,0x0,0x0,0x288023c3,0x0,0x0,0x0,0x28802000,0x0,0x0,0x0,0x0,0x0,0x0,0x288023c3,0x288023c3,0x288023c3,0x288023c3,0x0,0x8,0x0,0x0,0x288023c3,0x288023c3,0x8,0x0,0x288023c3,0x288023c3,0x288023c3,0x0,0x0,0x288023c3,0x0,0x0,0x288023cb,0x288023cb,0x288023cb,0x288023c3,0x288023c3,0x288023c3,0x288023cb,0x288023c3,0x0,0x288023c3,0x288023c3,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x242471,0x0,0x0,0x242471,0x40000,0x242471,0x242471,0x242471,0x242471,0x242471,0x242471,0x240000,0x200000,0x0,0x80000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x80000,0x0,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x80000,0x200040,0x80000000,0x200040,0x80000000,0x80000000,0x210000,0x200060,0x0,0x0,0x210000,0x60,0x60,0x0,0x2471,0x80000,0x240000,0x0,0x0,0x40,0x40,0x440,0x80000,0x460,0x440,0x440,0x0,0x0,0x2471,0x2471,0x2471,0x460,0x80000000,0x2471,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x79000000,0x79000000,0x460,0x0,0x6c00000,0x6c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x2471,0x2471,0x2471,0x0,0x2471,0x0,0x0,0x0,0x460,0x460,0x212000,0x212000,0x460,0x400,0x440,0x440,0x460,0x2000,0x2020,0x210000,0x60,0x0,0x200060,0x2471,0x2471,0x210000,0x11,0x46,0x46,0x9,0x2471,0x80000,0x2471,0x240000,0x0,0x0,0x80000,0x242471,0x0,0x0,0x0,0x2471,0x20,0x80000,0x20,0x80000,0x80000,0x80000,0x242471,0x242471,0x242471,0x242471,0x80000,0x200000,0x0,0x0,0x242471,0x242471,0x40000,0x0,0x2471,0x242471,0x242471,0x0,0x0,0x242471,0x0,0x0,0x242471,0x242471,0x242471,0x2471,0x2471,0x2471,0x242471,0x2471,0x80000,0x2471,0x2471,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[9];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public PHPParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PHPParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PHPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PHPParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PHPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PHPParser(PHPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PHPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[173];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 178; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 173; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 9; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

          //}}}
}
