/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;
import sessions.Session;
import sessions.SessionPropertyPane;

public class DefaultSessionPropertyPane
extends SessionPropertyPane
implements ActionListener {
    private JTextField tBasedir;
    private JButton bBrowse;
    private JComboBox cMode;

    public DefaultSessionPropertyPane(Session session) {
        super(session);
    }

    public String getIdentifier() {
        return "plugin.sessions.sessionproperties.default";
    }

    public String getLabel() {
        return jEdit.getProperty((String)"sessions.sessionproperties.default.label");
    }

    public void _init() {
        JPanel dirPanel = new JPanel();
        this.tBasedir = new JTextField(this.session.getProperty("basedir", ""), 20);
        dirPanel.add(this.tBasedir);
        this.bBrowse = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        dirPanel.add(this.bBrowse);
        this.bBrowse.setMargin(new Insets(0, 0, 0, 0));
        this.bBrowse.addActionListener(this);
        this.addComponent(dirPanel);
        this.cMode = new JComboBox<String>(this.getModeNames());
        this.cMode.setEditable(false);
        this.cMode.setSelectedItem(this.session.getProperty("mode", jEdit.getProperty((String)"buffer.defaultMode")));
        this.addComponent("sessions.sessionproperties.default.mode", (Component)this.cMode);
    }

    public void _save() {
        this.session.setProperty("basedir", this.tBasedir.getText());
        this.session.setProperty("mode", this.cMode.getSelectedItem() != null ? this.cMode.getSelectedItem().toString() : jEdit.getProperty((String)"buffer.defaultMode"));
    }

    private String[] getModeNames() {
        Mode[] modes = jEdit.getModes();
        String[] modeNames = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            modeNames[i] = modes[i].getName();
        }
        return modeNames;
    }

    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            this.tBasedir.setText(chooser.getSelectedFile().getPath());
        }
    }
}

