/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import org.gjt.sp.util.Log;
import sessions.Session;

class ParseUtilities {
    ParseUtilities() {
    }

    public static int toInt(String in, int defaultValue) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            Log.log((int)9, Session.class, (Object)("not an integer: " + in + "; using defaultValue " + defaultValue + "; error was: " + e));
            return defaultValue;
        }
    }

    public static long toLong(String in, long defaultValue) {
        try {
            return Long.parseLong(in);
        }
        catch (NumberFormatException e) {
            Log.log((int)9, Session.class, (Object)("not a long: " + in + "; using defaultValue " + defaultValue + "; error was: " + e));
            return defaultValue;
        }
    }

    public static boolean toBoolean(String in, boolean defaultValue) {
        try {
            return ParseUtilities.parseBoolean(in);
        }
        catch (IllegalArgumentException e) {
            Log.log((int)9, Session.class, (Object)("not a boolean: " + in + "; using defaultValue " + defaultValue + "; error was: " + e));
            return defaultValue;
        }
    }

    public static float toFloat(String in, float defaultValue) {
        try {
            return ParseUtilities.parseFloat(in);
        }
        catch (NumberFormatException e) {
            Log.log((int)9, Session.class, (Object)("not a float: " + in + "; using defaultValue " + defaultValue + "; error was: " + e));
            return defaultValue;
        }
    }

    public static double toDouble(String in, double defaultValue) {
        try {
            return ParseUtilities.parseDouble(in);
        }
        catch (NumberFormatException e) {
            Log.log((int)9, Session.class, (Object)("not a double: " + in + "; using defaultValue " + defaultValue + "; error was: " + e));
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String s) throws IllegalArgumentException {
        if ((s = s.trim()).equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Boolean must be 'true' or 'false'; found '" + s + "'");
    }

    public static float parseFloat(String s) throws NumberFormatException {
        if ((s = s.trim()).equals("NaN")) {
            return Float.NaN;
        }
        if (s.equals("Infinity")) {
            return Float.POSITIVE_INFINITY;
        }
        if (s.equals("-Infinity")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.valueOf(s).floatValue();
    }

    public static double parseDouble(String s) throws NumberFormatException {
        if ((s = s.trim()).equals("NaN")) {
            return Double.NaN;
        }
        if (s.equals("Infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (s.equals("-Infinity")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.valueOf(s);
    }

    public static String encodeXML(String in) {
        StringBuffer out = new StringBuffer(in.length());
        block9: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block9;
                }
                case '<': {
                    out.append("&lt;");
                    continue block9;
                }
                case '>': {
                    out.append("&gt;");
                    continue block9;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block9;
                }
                case '\\': {
                    if (i + 1 == in.length()) {
                        out.append("\\\\");
                        ++i;
                        continue block9;
                    }
                    c = in.charAt(i + 1);
                    if (c == '\\') {
                        out.append("\\\\\\\\");
                        ++i;
                        continue block9;
                    }
                    if (c == 'u') {
                        out.append("\\\\u");
                        ++i;
                        continue block9;
                    }
                    if (c <= '\u001f' || c >= '\u0080' && c <= '\u009f') {
                        out.append("\\\\");
                        continue block9;
                    }
                    out.append("\\");
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    out.append(c);
                    continue block9;
                }
                default: {
                    if (c <= '\u001f' || c >= '\u0080') {
                        out.append("\\u");
                        out.append(Integer.toHexString(c + 65536).substring(1));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String decodeXML(String in) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        try {
            for (i = 0; i < in.length(); ++i) {
                char c = in.charAt(i);
                if (c == '&') {
                    if (in.startsWith("amp;", ++i)) {
                        out.append('&');
                        i += 3;
                        continue;
                    }
                    if (in.startsWith("lt;", i)) {
                        out.append('<');
                        i += 2;
                        continue;
                    }
                    if (in.startsWith("gt;", i)) {
                        out.append('>');
                        i += 2;
                        continue;
                    }
                    if (in.startsWith("apos;", i)) {
                        out.append('\'');
                        i += 4;
                        continue;
                    }
                    if (!in.startsWith("quot;", i)) continue;
                    out.append('\"');
                    i += 4;
                    continue;
                }
                if (c == '\\') {
                    if (in.charAt(++i) == 'u') {
                        out.append((char)Integer.parseInt(in.substring(++i, i + 4), 16));
                        i += 3;
                        continue;
                    }
                    if (in.charAt(i) == '\\') {
                        out.append('\\');
                        continue;
                    }
                    out.append('\\');
                    --i;
                    continue;
                }
                out.append(c);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.log((int)9, Session.class, (Object)("Seems to be an incomplete escaped entity or \\unnnn: " + in.substring(i)));
        }
        catch (IndexOutOfBoundsException e) {
            Log.log((int)9, Session.class, (Object)("Seems to be an incomplete escaped entity: " + in.substring(in.lastIndexOf(38))));
        }
        catch (NumberFormatException e) {
            Log.log((int)9, Session.class, (Object)("Seems to be a faulty \\unnnn escaped control char: " + in.substring(i)));
        }
        return out.toString();
    }
}

