/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import sessions.Session;
import sessions.SessionManager;

public class SaveDialog
extends EnhancedDialog {
    private View view;
    private JList openedBufferList;
    private JList closedBufferList;
    private DefaultListModel openedBufferModel;
    private DefaultListModel closedBufferModel;
    private JButton bt_ok;
    private JButton bt_dontsave;
    private JButton bt_cancel;
    private boolean ok = true;

    public SaveDialog(View view) {
        super((Frame)view, jEdit.getProperty((String)"session.savedialog.title"), true);
        this.view = view;
        boolean somethingHasChanged = false;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel pn_label = new JPanel(new GridLayout(2, 1));
        JLabel label = new JLabel(jEdit.getProperty((String)"session.savedialog.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        pn_label.add(label);
        JLabel lb_question = new JLabel(jEdit.getProperty((String)"session.savedialog.question"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        pn_label.add(lb_question);
        content.add("North", pn_label);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel openedPanel = new JPanel(new BorderLayout());
        JPanel closedPanel = new JPanel(new BorderLayout());
        this.openedBufferModel = new DefaultListModel();
        this.openedBufferList = new JList(this.openedBufferModel);
        this.openedBufferList.setVisibleRowCount(7);
        this.openedBufferList.setEnabled(false);
        this.closedBufferModel = new DefaultListModel();
        this.closedBufferList = new JList(this.closedBufferModel);
        this.closedBufferList.setVisibleRowCount(7);
        this.closedBufferList.setEnabled(false);
        openedPanel.add("North", new JLabel(jEdit.getProperty((String)"session.savedialog.added")));
        closedPanel.add("North", new JLabel(jEdit.getProperty((String)"session.savedialog.removed")));
        Session currentSession = SessionManager.getInstance().getCurrentSessionInstance();
        Buffer[] buffers = jEdit.getBuffers();
        Vector<String> newFiles = new Vector<String>(buffers.length);
        for (int i = 0; i < buffers.length; ++i) {
            Buffer buffer = buffers[i];
            if (!currentSession.hasFile(buffer.getPath())) {
                this.openedBufferModel.addElement(buffer.getPath());
                somethingHasChanged = true;
            }
            newFiles.add(buffer.getPath());
        }
        Enumeration oldFiles = currentSession.getAllFilenames();
        while (oldFiles.hasMoreElements()) {
            String oneFilename = (String)oldFiles.nextElement();
            if (newFiles.contains(oneFilename)) continue;
            this.closedBufferModel.addElement(oneFilename);
            somethingHasChanged = true;
        }
        openedPanel.add("Center", new JScrollPane(this.openedBufferList));
        closedPanel.add("Center", new JScrollPane(this.closedBufferList));
        centerPanel.add("North", openedPanel);
        centerPanel.add("Center", new JLabel(" "));
        centerPanel.add("South", closedPanel);
        content.add("Center", centerPanel);
        ActionHandler actionListener = new ActionHandler();
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.bt_ok = new JButton(jEdit.getProperty((String)"session.savedialog.save"));
        buttons.add(this.bt_ok);
        this.bt_ok.addActionListener(actionListener);
        buttons.add(Box.createGlue());
        this.bt_dontsave = new JButton(jEdit.getProperty((String)"session.savedialog.dontsave"));
        buttons.add(this.bt_dontsave);
        this.bt_dontsave.addActionListener(actionListener);
        buttons.add(Box.createGlue());
        this.bt_cancel = new JButton(jEdit.getProperty((String)"session.savedialog.cancel"));
        buttons.add(this.bt_cancel);
        this.bt_cancel.addActionListener(actionListener);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        GUIUtilities.requestFocus((Window)((Object)this), (Component)this.openedBufferList);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        if (somethingHasChanged) {
            this.setVisible(true);
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    public void ok() {
        SessionManager.getInstance().saveCurrentSession(this.view, true);
        this.ok = true;
        this.dispose();
    }

    public void dontsave() {
        this.ok = true;
        this.dispose();
    }

    public void cancel() {
        this.ok = false;
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SaveDialog.this.bt_ok) {
                SaveDialog.this.ok();
            } else if (source == SaveDialog.this.bt_dontsave) {
                SaveDialog.this.dontsave();
            } else if (source == SaveDialog.this.bt_cancel) {
                SaveDialog.this.cancel();
            }
        }
    }
}

