/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import sessions.ParseUtilities;
import sessions.SessionFile;
import sessions.SessionManager;
import sessions.SessionPropertyChanged;
import sessions.SessionPropertyRemoved;

public class Session
implements Cloneable {
    public static final String BASE_DIRECTORY = "basedir";
    public static final String DEFAULT_MODE = "mode";
    private String name;
    private String filename;
    private String currentFile;
    private Hashtable properties;
    private Hashtable sessionFiles;

    public Session(String string) {
        this.setName(string);
        this.sessionFiles = new Hashtable();
        this.properties = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.filename = SessionManager.createSessionFileName(string);
    }

    public boolean rename(String string) {
        String string2 = this.name;
        File file = new File(this.filename);
        File file2 = new File(SessionManager.createSessionFileName(string));
        if (!file.renameTo(file2)) {
            return false;
        }
        this.setName(string);
        try {
            this.saveXML();
        }
        catch (IOException iOException) {
            this.setName(string2);
            return false;
        }
        return true;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return this.name;
    }

    public void setCurrentFile(String string) {
        if (this.hasFile(string)) {
            this.currentFile = string;
        } else {
            Log.log((int)1, (Object)this, (Object)("setCurrentFile: session " + this.name + ": doesn't contain file " + string + " - use addFile() first."));
        }
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public String getProperty(String string) {
        Object v = this.properties.get(string);
        return v == null ? null : v.toString();
    }

    public void setProperty(String string, String string2) {
        if (string2 != null) {
            String string3 = this.properties.put(string, string2);
            EditBus.send((EBMessage)new SessionPropertyChanged(SessionManager.getInstance(), this, string, string3 != null ? string3.toString() : null, string2));
        } else {
            this.removeProperty(string);
        }
    }

    public int getIntProperty(String string, int n) {
        return ParseUtilities.toInt(this.getProperty(string), n);
    }

    public long getLongProperty(String string, long l) {
        return ParseUtilities.toLong(this.getProperty(string), l);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        return ParseUtilities.toBoolean(this.getProperty(string), bl);
    }

    public float getFloatProperty(String string, float f) {
        return ParseUtilities.toFloat(this.getProperty(string), f);
    }

    public double getDoubleProperty(String string, double d) {
        return ParseUtilities.toDouble(this.getProperty(string), d);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 != null ? string3 : string2;
    }

    public void setIntProperty(String string, int n) {
        this.setProperty(string, String.valueOf(n));
    }

    public void setLongProperty(String string, long l) {
        this.setProperty(string, String.valueOf(l));
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, String.valueOf(bl));
    }

    public void setFloatProperty(String string, float f) {
        this.setProperty(string, String.valueOf(f));
    }

    public void setDoubleProperty(String string, double d) {
        this.setProperty(string, String.valueOf(d));
    }

    public void removeProperty(String string) {
        if (this.properties.containsKey(string)) {
            Object v = this.properties.remove(string);
            EditBus.send((EBMessage)new SessionPropertyRemoved(SessionManager.getInstance(), this, string, v != null ? v.toString() : null));
        }
    }

    public boolean hasFile(String string) {
        return this.sessionFiles.containsKey(string);
    }

    public Enumeration getAllFiles() {
        return this.sessionFiles.elements();
    }

    public Enumeration getAllFilenames() {
        return this.sessionFiles.keys();
    }

    public boolean open(View view) {
        return this.open(view, true);
    }

    public boolean open(View view, boolean bl) {
        Log.log((int)1, (Object)this, (Object)("open: name=" + this.name));
        try {
            this.loadXML();
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)this, (Object)iOException);
            SessionManager.showErrorLater(view, "ioerror", new Object[]{iOException.getMessage()});
            return false;
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)this, (Object)exception);
            SessionManager.showErrorLater(view, "sessions.manager.error.load", new Object[]{this.name, exception.getMessage()});
            return false;
        }
        if (bl) {
            SessionFile sessionFile;
            Iterator iterator = this.sessionFiles.values().iterator();
            while (iterator.hasNext()) {
                sessionFile = (SessionFile)iterator.next();
                Hashtable hashtable = sessionFile.getBufferProperties();
                jEdit.openFile((View)view, null, (String)ParseUtilities.decodeXML(sessionFile.getPath()), (boolean)false, (Hashtable)hashtable);
            }
            if (this.currentFile != null && (sessionFile = jEdit.getBuffer((String)this.currentFile)) != null) {
                view.setBuffer((Buffer)sessionFile);
            }
        }
        return true;
    }

    public boolean save(View view) {
        Log.log((int)1, (Object)this, (Object)("save: name=" + this.name));
        if (view != null) {
            view.getEditPane().saveCaretInfo();
        }
        this.sessionFiles.clear();
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            if (buffer.isUntitled()) continue;
            this.addFile(buffer.getPath(), buffer.getStringProperty("encoding"));
        }
        if (view != null) {
            this.currentFile = view.getBuffer().getPath();
        }
        try {
            this.saveXML();
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)this, (Object)iOException);
            SessionManager.showErrorLater(view, "ioerror", new Object[]{iOException.getMessage()});
            return false;
        }
        return true;
    }

    public boolean hasFileListChanged() {
        Object object;
        Vector<String> vector = new Vector<String>();
        for (object = jEdit.getFirstBuffer(); object != null; object = object.getNext()) {
            if (object.isUntitled()) continue;
            vector.addElement(object.getPath());
        }
        object = new Vector(this.sessionFiles.values());
        return !((Vector)object).equals(vector);
    }

    public void addFile(String string) {
        if (this.hasFile(string)) {
            Log.log((int)1, (Object)this, (Object)("addFile: session " + this.name + ": already contains file " + string + " - not added."));
        } else {
            this.addFile(string, jEdit.getProperty((String)"buffer.encoding", (String)System.getProperty("file.encoding")));
        }
    }

    public void addFile(String string, String string2) {
        if (this.hasFile(string)) {
            Log.log((int)1, (Object)this, (Object)("addFile: session " + this.name + ": already contains file " + string + " - not added."));
        } else {
            this.sessionFiles.put(string, new SessionFile(string, string2));
        }
    }

    public void clear() {
        this.sessionFiles.clear();
        this.properties.clear();
        this.currentFile = null;
    }

    public Object clone() {
        return this.getClone();
    }

    public Session getClone() {
        Session session = new Session(this.name);
        session.sessionFiles = (Hashtable)this.sessionFiles.clone();
        session.properties = (Hashtable)this.properties.clone();
        return session;
    }

    public void loadXML() throws Exception {
        Log.log((int)1, (Object)this, (Object)("loadXML: name=" + this.name + " filename=" + this.filename));
        this.clear();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filename));
        XmlParser xmlParser = new XmlParser();
        xmlParser.setHandler((XmlHandler)new SessionXmlHandler(xmlParser));
        xmlParser.parse(null, null, (Reader)bufferedReader);
    }

    public void saveXML() throws IOException {
        Log.log((int)1, (Object)this, (Object)("saveXML: name=" + this.name + " filename=" + this.filename));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.filename));
        bufferedWriter.write("<?xml version=\"1.0\"?>");
        bufferedWriter.newLine();
        bufferedWriter.write("<!DOCTYPE SESSION SYSTEM \"session.dtd\">");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("<SESSION name=\"");
        bufferedWriter.write(this.name);
        bufferedWriter.write("\">");
        bufferedWriter.newLine();
        bufferedWriter.write("  <FILES>");
        bufferedWriter.newLine();
        this.saveFiles(bufferedWriter);
        bufferedWriter.write("  </FILES>");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  <PROPERTIES>");
        bufferedWriter.newLine();
        this.saveProperties(bufferedWriter);
        bufferedWriter.write("  </PROPERTIES>");
        bufferedWriter.newLine();
        bufferedWriter.write("</SESSION>");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    private void saveFiles(BufferedWriter bufferedWriter) throws IOException {
        Enumeration enumeration = this.sessionFiles.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer;
            SessionFile sessionFile = (SessionFile)enumeration.nextElement();
            String string = sessionFile.getPath().replace('\\', '/');
            bufferedWriter.write("      <FILE filename=\"");
            bufferedWriter.write(ParseUtilities.encodeXML(string));
            bufferedWriter.write(34);
            if (string.equals(this.getCurrentFile())) {
                bufferedWriter.write(" isCurrent=\"true\"");
            }
            if ((buffer = jEdit.getBuffer((String)string)) != null) {
                String string2 = buffer.getStringProperty("encoding");
                if (string2 != null && string2.length() > 0) {
                    bufferedWriter.write(" encoding=\"" + string2 + "\"");
                }
                Integer n = new Integer(buffer.getIntegerProperty("Buffer__caret", 0));
                bufferedWriter.write(" carat=\"" + n.toString() + "\"");
            }
            bufferedWriter.write("/>");
            bufferedWriter.newLine();
        }
    }

    private void saveProperties(BufferedWriter bufferedWriter) throws IOException {
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this.getProperty(string);
            Log.log((int)1, (Object)this, (Object)("Writing PROP: " + string));
            bufferedWriter.write("      <PROP key=\"");
            bufferedWriter.write(ParseUtilities.encodeXML(string));
            bufferedWriter.write(34);
            if (string2 != null) {
                bufferedWriter.write(" value=\"");
                bufferedWriter.write(ParseUtilities.encodeXML(string2));
                bufferedWriter.write(34);
            }
            bufferedWriter.write("/>");
            bufferedWriter.newLine();
        }
    }

    private class SessionXmlHandler
    extends HandlerBase {
        private XmlParser parser;
        private String currentName;
        private String currentFilePath;
        private String currentFileEncoding;
        private Integer currentFileCarat;
        private String currentPropKey;
        private String currentPropValue;
        private boolean currentIsCurrent;

        SessionXmlHandler(XmlParser xmlParser) {
            this.parser = xmlParser;
        }

        public void doctypeDecl(String string, String string2, String string3) throws XmlException {
            if (string.equalsIgnoreCase("SESSION")) {
                return;
            }
            throw new XmlException("DOCTYPE must be SESSION", "SESSION", this.parser.getLineNumber(), this.parser.getColumnNumber());
        }

        public Object resolveEntity(String string, String string2) throws IOException {
            if (string2.equals("session.dtd")) {
                return new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("session.dtd")));
            }
            return null;
        }

        public void attribute(String string, String string2, boolean bl) throws XmlException {
            if ("name".equals(string)) {
                this.currentName = string2;
            } else if ("filename".equals(string)) {
                this.currentFilePath = string2;
            } else if ("isCurrent".equals(string)) {
                this.currentIsCurrent = string2 == null ? false : Boolean.valueOf(string2);
            } else if ("encoding".equals(string)) {
                this.currentFileEncoding = string2;
            } else if ("carat".equals(string)) {
                Integer n = null;
                try {
                    n = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = new Integer(0);
                }
                this.currentFileCarat = n;
            } else if ("key".equals(string)) {
                this.currentPropKey = string2;
            } else if ("value".equals(string)) {
                this.currentPropValue = string2;
            } else {
                throw new XmlException("unknown attribute: " + string, "SESSION", this.parser.getLineNumber(), this.parser.getColumnNumber());
            }
        }

        public void endElement(String string) {
            if (string == null) {
                return;
            }
            if ("SESSION".equals(string)) {
                if (!this.currentName.equals(Session.this.name)) {
                    Log.log((int)7, (Object)((Object)this), (Object)jEdit.getProperty((String)"sessions.manager.warning.load.ambigious.message", (Object[])new Object[]{Session.this.name, this.currentName}));
                    Session.this.name = this.currentName;
                }
            } else if ("FILE".equals(string)) {
                Session.this.addFile(this.currentFilePath, this.currentFileEncoding);
                if (this.currentIsCurrent) {
                    Session.this.setCurrentFile(this.currentFilePath);
                }
                this.currentFilePath = null;
                this.currentFileEncoding = null;
                this.currentFileCarat = null;
            } else if ("PROP".equals(string)) {
                Session.this.properties.put(this.currentPropKey, this.currentPropValue);
            }
        }
    }
}

