/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.util.Log;
import sessions.Session;
import sessions.SessionManager;

public class SessionFileConverter
implements Runnable {
    private String sessionsDir = SessionManager.getSessionsDir();

    SessionFileConverter() {
    }

    public void run() {
        String[] files = this.getOldSessionFiles();
        if (files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            this.convert(files[i]);
        }
    }

    private String[] getOldSessionFiles() {
        return new File(this.sessionsDir).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".session");
            }
        });
    }

    private void convert(String filename) {
        Log.log((int)1, (Object)this, (Object)("converting to new session file format: " + filename));
        String absoluteFilename = MiscUtilities.constructPath((String)this.sessionsDir, (String)filename);
        String name = filename.substring(0, filename.length() - 8);
        Session session = new Session(name);
        try {
            String line;
            File absoluteFile = new File(absoluteFilename);
            BufferedReader in = new BufferedReader(new FileReader(absoluteFile));
            while ((line = in.readLine()) != null) {
                this.readOldSessionLine(line, session);
            }
            in.close();
            session.saveXML();
            absoluteFile.delete();
        }
        catch (IOException io) {
            Log.log((int)9, (Object)this, (Object)("IOException during session convert: " + io));
        }
    }

    private void readOldSessionLine(String line, Session session) {
        if (line.startsWith("path:")) {
            line = line.substring(5);
        }
        boolean isCurrent = false;
        StringTokenizer st = new StringTokenizer(line, "\t");
        String path = st.nextToken();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals("current")) continue;
            isCurrent = true;
        }
        if (path != null) {
            session.addFile(path);
            if (isCurrent) {
                session.setCurrentFile(path);
            }
        }
    }
}

