/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Vector;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.Log;
import sessions.SaveDialog;
import sessions.Session;
import sessions.SessionChanged;
import sessions.SessionChanging;
import sessions.SessionFileConverter;
import sessions.SessionListChanged;
import sessions.SessionManagerDialog;
import sessions.SessionPropertiesDialog;
import sessions.SessionPropertiesShowing;

public class SessionManager
implements EBComponent {
    public static final String SESSION_PROPERTY = "sessions.currentSession";
    private Session currentSession = new Session(jEdit.getProperty((String)"sessions.currentSession", (String)"default"));
    private static SessionManager instance;
    private String titleBarSessionName;
    private String defaultViewTitle;

    public static SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    private SessionManager() {
        File dir = new File(SessionManager.getSessionsDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        new SessionFileConverter().run();
        File defaultSessionFile = new File(SessionManager.createSessionFileName("default"));
        if (!defaultSessionFile.exists()) {
            new Session("default").save(null);
        }
        this.defaultViewTitle = jEdit.getProperty((String)"view.title", (String)jEdit.getProperty((String)"sessions.titlebar.default"));
        this.titleBarSessionName = new String();
    }

    public void setCurrentSession(View view, String newSessionName) {
        if (newSessionName.equals(this.currentSession.getName())) {
            return;
        }
        Log.log((int)1, (Object)this, (Object)("setCurrentSession: currentSession=" + this.currentSession.getName() + " newSessionName=" + newSessionName));
        File currentSessionFile = new File(this.currentSession.getFilename());
        if (currentSessionFile.exists() && !this.autosaveCurrentSession(view)) {
            return;
        }
        if (jEdit.getBooleanProperty((String)"sessions.switcher.closeAll", (boolean)true) && !jEdit.closeAllBuffers((View)view)) {
            return;
        }
        String oldSessionName = this.currentSession.getName();
        EditBus.send((EBMessage)new SessionChanging(this, oldSessionName, newSessionName));
        this.currentSession = new Session(newSessionName);
        this.saveCurrentSessionProperty();
        this.currentSession.open(view);
        EditBus.send((EBMessage)new SessionChanged(this, oldSessionName, newSessionName, this.currentSession));
        this.changeFSBToBaseDirectory(view);
        this.setSessionNameInTitleBar();
    }

    public String getCurrentSession() {
        return this.currentSession.getName();
    }

    public Session getCurrentSessionInstance() {
        return this.currentSession;
    }

    public void saveCurrentSession(View view) {
        this.saveCurrentSession(view, false);
    }

    public boolean autosaveCurrentSession(View view) {
        if (this.currentSession.hasFileListChanged() && jEdit.getBooleanProperty((String)"sessions.switcher.autoSave", (boolean)true)) {
            if (jEdit.getBooleanProperty((String)"sessions.switcher.askSave", (boolean)false)) {
                boolean ok = new SaveDialog(view).isOK();
                if (!ok) {
                    return false;
                }
            } else {
                Log.log((int)1, (Object)this, (Object)"autosaving current session...");
                this.saveCurrentSession(view, true);
            }
        }
        return true;
    }

    public void saveCurrentSession(View view, boolean silently) {
        this.currentSession.save(view);
        this.saveCurrentSessionProperty();
        if (!silently) {
            GUIUtilities.message((Component)view, (String)"sessions.switcher.save.saved", (Object[])new Object[]{this.currentSession});
        }
        Log.log((int)1, (Object)this, (Object)("session saved: " + this.currentSession.getName()));
    }

    public void saveCurrentSessionAs(View view) {
        int answer;
        String newName = SessionManager.inputSessionName((Component)view, this.currentSession.getName());
        if (newName == null) {
            return;
        }
        File file = new File(SessionManager.createSessionFileName(newName));
        if (file.exists() && (answer = GUIUtilities.confirm((Component)view, (String)"sessions.switcher.saveAs.exists", (Object[])new Object[]{newName}, (int)0, (int)2)) != 0) {
            return;
        }
        Session newSession = this.currentSession.getClone();
        newSession.setName(newName);
        newSession.save(view);
        EditBus.send((EBMessage)new SessionChanging(this, this.currentSession.getName(), newName));
        String oldSessionName = this.currentSession.getName();
        this.currentSession = newSession;
        this.saveCurrentSessionProperty();
        EditBus.send((EBMessage)new SessionListChanged(this));
        EditBus.send((EBMessage)new SessionChanged(this, oldSessionName, newName, this.currentSession));
        this.setSessionNameInTitleBar();
    }

    public void reloadCurrentSession(View view) {
        Log.log((int)1, (Object)this, (Object)("reloadCurrentSession: currentSession=" + this.currentSession));
        if (!jEdit.closeAllBuffers((View)view)) {
            return;
        }
        this.currentSession.open(view);
    }

    public void changeFSBToBaseDirectory(View view) {
        if (jEdit.getBooleanProperty((String)"sessions.switcher.changeFSBDirectory", (boolean)false) && !"".equals(this.currentSession.getProperty("basedir")) && view.getDockableWindowManager().isDockableWindowVisible("vfs.browser")) {
            VFSBrowser.browseDirectory((View)view, (String)this.currentSession.getProperty("basedir"));
        }
    }

    public void showSessionManagerDialog(View view) {
        SessionManagerDialog dlg = new SessionManagerDialog(view, this.currentSession.getName());
        String newSession = dlg.getSelectedSession();
        if (dlg.isListModified()) {
            EditBus.send((EBMessage)new SessionListChanged(this));
            if (newSession == null) {
                String name = this.currentSession.getName();
                EditBus.send((EBMessage)new SessionChanging(this, name, name));
                EditBus.send((EBMessage)new SessionChanged(this, name, name, this.currentSession));
            }
        }
        if (newSession != null) {
            this.setCurrentSession(view, newSession);
        }
    }

    public void showSessionPropertiesDialog(View view) {
        SessionPropertiesShowing message = new SessionPropertiesShowing(this, this.currentSession);
        EditBus.send((EBMessage)message);
        new SessionPropertiesDialog(view, this.currentSession.getName(), message.getRootGroup());
    }

    public static String[] getSessionNames() {
        String[] files = new File(SessionManager.getSessionsDir()).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        Arrays.sort(files, new MiscUtilities.StringICaseCompare());
        Vector<String> v = new Vector<String>();
        boolean foundDefault = false;
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].substring(0, files[i].length() - 4);
            if (name.equalsIgnoreCase("default")) {
                v.insertElementAt(name, 0);
                foundDefault = true;
                continue;
            }
            v.addElement(name);
        }
        if (!foundDefault) {
            v.insertElementAt("default", 0);
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public void handleMessage(EBMessage msg) {
    }

    public static String createSessionFileName(String session) {
        String filename = MiscUtilities.constructPath((String)SessionManager.getSessionsDir(), (String)session);
        if (!filename.toLowerCase().endsWith(".xml")) {
            filename = filename + ".xml";
        }
        return filename;
    }

    public static String getSessionsDir() {
        return MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"sessions");
    }

    public static String inputSessionName(Component relativeTo, String defaultName) {
        String name = defaultName;
        do {
            if ((name = GUIUtilities.input((Component)relativeTo, (String)"sessions.switcher.saveAs.input", (Object)name)) == null) continue;
            if ((name = name.trim()).length() == 0) {
                GUIUtilities.error((Component)relativeTo, (String)"sessions.switcher.saveAs.error.empty", null);
            }
            if (name.indexOf(47) < 0 && name.indexOf(92) < 0 && name.indexOf(59) < 0 && name.indexOf(58) < 0) continue;
            GUIUtilities.error((Component)relativeTo, (String)"sessions.switcher.saveAs.error.illegalChars", (Object[])new Object[]{"/  \\  ;  :"});
            name = "";
        } while (name != null && name.length() == 0);
        return name;
    }

    public static final void showErrorLater(final View view, final String messageProperty, final Object[] args) {
        VFSManager.runInAWTThread((Runnable)new Runnable(){

            public void run() {
                GUIUtilities.error((Component)view, (String)messageProperty, (Object[])args);
            }
        });
    }

    void saveCurrentSessionProperty() {
        Log.log((int)1, (Object)this, (Object)("saveCurrentSessionProperty: currentSession=" + this.currentSession.getName()));
        jEdit.setProperty((String)SESSION_PROPERTY, (String)this.currentSession.getName());
        jEdit.saveSettings();
    }

    public void setSessionNameInTitleBar() {
        if (this.currentSession != null && jEdit.getBooleanProperty((String)"sessions.switcher.showSessionNameInTitleBar", (boolean)true)) {
            this.titleBarSessionName = jEdit.getBooleanProperty((String)"sessions.switcher.showSessionPrefixInTitleBar", (boolean)true) ? this.defaultViewTitle + jEdit.getProperty((String)"sessions.titlebar.startbracket") + jEdit.getProperty((String)"sessions.titlebar.prefix") + this.currentSession.getName() + jEdit.getProperty((String)"sessions.titlebar.endbracket") : this.defaultViewTitle + jEdit.getProperty((String)"sessions.titlebar.startbracket") + this.currentSession.getName() + jEdit.getProperty((String)"sessions.titlebar.endbracket");
            jEdit.setTemporaryProperty((String)"view.title", (String)this.titleBarSessionName);
            this.refreshTitleBar();
        }
    }

    public void restoreTitleBarText() {
        jEdit.setTemporaryProperty((String)"view.title", (String)this.defaultViewTitle);
    }

    public void refreshTitleBar() {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditBus.send((EBMessage)new BufferUpdate(views[i].getBuffer(), views[i], BufferUpdate.LOADED));
        }
    }
}

