/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import sessions.Session;
import sessions.SessionManager;

class SessionManagerDialog
extends EnhancedDialog
implements ActionListener,
ListSelectionListener {
    private JList lSessions;
    private JButton bRename;
    private JButton bDelete;
    private JButton bChangeTo;
    private JButton bClose;
    private String selectedSession;
    private String currentSession;
    private boolean listModified;

    public SessionManagerDialog(View view, final String currentSession) {
        super((Frame)view, jEdit.getProperty((String)"sessions.manager.title"), true);
        this.currentSession = currentSession;
        SessionManager.getInstance();
        this.lSessions = new JList<String>(SessionManager.getSessionNames());
        this.lSessions.setSelectionMode(0);
        this.lSessions.addListSelectionListener(this);
        this.lSessions.addMouseListener(new MouseHandler());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SessionManagerDialog.this.lSessions.setSelectedValue(currentSession, true);
            }
        });
        int numSessions = this.lSessions.getModel().getSize();
        if (numSessions > 25) {
            numSessions = 25;
        }
        this.lSessions.setVisibleRowCount(numSessions);
        JScrollPane scrSessions = new JScrollPane(this.lSessions);
        this.bRename = new JButton(jEdit.getProperty((String)"sessions.manager.rename"));
        this.bRename.addActionListener(this);
        this.bDelete = new JButton(jEdit.getProperty((String)"sessions.manager.delete"));
        this.bDelete.addActionListener(this);
        this.bChangeTo = new JButton(jEdit.getProperty((String)"sessions.manager.changeTo"));
        this.bChangeTo.setDefaultCapable(true);
        this.bChangeTo.addActionListener(this);
        this.bClose = new JButton(jEdit.getProperty((String)"sessions.manager.close"));
        this.bClose.addActionListener(this);
        Insets inset10 = new Insets(10, 10, 10, 10);
        Insets insetButton = new Insets(10, 0, 0, 10);
        Insets insetLast = new Insets(10, 0, 10, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addComponent(scrSessions, 1, 3, 1.0, 1.0, 10, 1, inset10);
        this.addComponent(this.bRename, 0, 1, 0.0, 0.0, 11, 2, insetButton);
        this.addComponent(this.bDelete, 0, 1, 0.0, 0.0, 11, 2, insetButton);
        this.addComponent(this.bChangeTo, 0, 1, 0.0, 0.0, 11, 2, insetButton);
        this.addComponent(new JSeparator(), 0, 1, 1.0, 0.0, 10, 2, inset10);
        this.addComponent(new JPanel(), 1, 1, 1.0, 0.0, 10, 2, inset10);
        this.addComponent(this.bClose, 0, 1, 0.0, 0.0, 11, 2, insetLast);
        this.getRootPane().setDefaultButton(this.bChangeTo);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.setVisible(true);
    }

    public void ok() {
        if (this.lSessions.getSelectedValue() != null) {
            this.selectedSession = this.lSessions.getSelectedValue().toString();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public String getSelectedSession() {
        return this.selectedSession;
    }

    public boolean isListModified() {
        return this.listModified;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bClose) {
            this.cancel();
        } else if (evt.getSource() == this.bChangeTo) {
            this.ok();
        } else if (evt.getSource() == this.bRename) {
            this.rename();
        } else if (evt.getSource() == this.bDelete) {
            this.delete();
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        Object[] values = this.lSessions.getSelectedValues();
        if (values == null || values.length == 0) {
            this.bRename.setEnabled(false);
            this.bDelete.setEnabled(false);
            this.bChangeTo.setEnabled(false);
        } else {
            boolean isCurrentSession = values[0].toString().equals(this.currentSession);
            boolean isDefaultSession = values[0].toString().equalsIgnoreCase("default");
            this.bChangeTo.setEnabled(!isCurrentSession);
            this.bRename.setEnabled(!isDefaultSession);
            this.bDelete.setEnabled(!isDefaultSession);
        }
    }

    private void rename() {
        Session renameSession;
        String oldName = this.lSessions.getSelectedValue().toString();
        String newName = SessionManager.inputSessionName((Component)((Object)this), oldName);
        if (newName == null) {
            return;
        }
        if (oldName.equals(this.currentSession)) {
            renameSession = SessionManager.getInstance().getCurrentSessionInstance();
        } else {
            renameSession = new Session(oldName);
            try {
                renameSession.loadXML();
            }
            catch (Exception e) {
                GUIUtilities.error((Component)((Object)this), (String)"sessions.manager.error.rename", (Object[])new Object[]{oldName, newName});
                return;
            }
        }
        if (renameSession.rename(newName)) {
            this.setNewListModel();
            this.lSessions.setSelectedValue(newName, true);
            if (oldName.equals(this.currentSession)) {
                this.currentSession = newName;
            }
        } else {
            GUIUtilities.error((Component)((Object)this), (String)"sessions.manager.error.rename", (Object[])new Object[]{oldName, newName});
        }
    }

    private void delete() {
        String name = this.lSessions.getSelectedValue().toString();
        File file = new File(SessionManager.createSessionFileName(name));
        if (file.delete()) {
            if (name.equals(this.currentSession)) {
                this.currentSession = null;
            }
            this.setNewListModel();
            this.lSessions.setSelectedValue("default", true);
        } else {
            GUIUtilities.error((Component)((Object)this), (String)"sessions.manager.error.delete", (Object[])new Object[]{file});
        }
    }

    private void setNewListModel() {
        this.listModified = true;
        SessionManager.getInstance();
        final String[] listData = SessionManager.getSessionNames();
        this.lSessions.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.length;
            }

            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    private void addComponent(Component comp, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        GridBagLayout gridBag = (GridBagLayout)this.getContentPane().getLayout();
        gridBag.setConstraints(comp, constraints);
        this.getContentPane().add(comp);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                SessionManagerDialog.this.ok();
            }
        }
    }
}

