/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import sessions.SessionManager;
import sessions.SessionPropertiesChanged;
import sessions.SessionPropertyGroup;
import sessions.SessionPropertyPane;

public class SessionPropertiesDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private JTree paneTree;
    private JPanel cardPanel;
    private JLabel currentLabel;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    private SessionPropertyGroup rootGroup;

    SessionPropertiesDialog(View view, String sessionName, SessionPropertyGroup rootGroup) {
        super((Frame)view, jEdit.getProperty((String)"sessions.sessionproperties.title", (Object[])new Object[]{sessionName}), true);
        this.rootGroup = rootGroup;
        view.showWaitCursor();
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel stage = new JPanel(new BorderLayout());
        stage.setBorder(new EmptyBorder(0, 6, 0, 0));
        content.add((Component)stage, "Center");
        this.currentLabel = new JLabel();
        this.currentLabel.setHorizontalAlignment(2);
        this.currentLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        stage.add((Component)this.currentLabel, "North");
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        stage.add((Component)this.cardPanel, "Center");
        this.paneTree = new JTree(this.createTreeModel());
        this.paneTree.setCellRenderer(new CellRenderer());
        this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        content.add((Component)new JScrollPane(this.paneTree, 22, 30), "West");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(this);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(jEdit.getProperty((String)"common.apply"));
        this.apply.addActionListener(this);
        buttons.add(this.apply);
        buttons.add(Box.createGlue());
        content.add((Component)buttons, "South");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.paneTree.getModel().getRoot();
        DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)root.getFirstChild();
        TreePath path = new TreePath(firstChild.getPath());
        this.paneTree.setSelectionPath(path);
        view.hideWaitCursor();
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.show();
    }

    public void ok() {
        this.ok(true);
    }

    public void cancel() {
        this.dispose();
    }

    public void ok(boolean dispose) {
        this.rootGroup.save();
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        EditBus.send((EBMessage)new SessionPropertiesChanged(SessionManager.getInstance(), SessionManager.getInstance().getCurrentSessionInstance()));
        if (dispose) {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.apply) {
            this.ok(false);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = last.getUserObject();
        if (!(obj instanceof SessionPropertyPane)) {
            return;
        }
        SessionPropertyPane pane = (SessionPropertyPane)obj;
        pane.init();
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, pane.getIdentifier());
        this.currentLabel.setText(this.labelForPath(path));
        this.pack();
    }

    private String labelForPath(TreePath path) {
        int i;
        Object[] nodes = path.getPath();
        int lastIdx = nodes.length - 1;
        StringBuffer buf = new StringBuffer();
        String label = null;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block8: {
                block7: {
                    Object obj;
                    block6: {
                        obj = ((DefaultMutableTreeNode)nodes[i]).getUserObject();
                        if (!(obj instanceof SessionPropertyPane)) break block6;
                        label = ((SessionPropertyPane)obj).getLabel();
                        break block7;
                    }
                    if (!(obj instanceof SessionPropertyGroup)) break block8;
                    label = ((SessionPropertyGroup)obj).getLabel();
                }
                if (label != null) {
                    buf.append(label);
                }
                if (i != lastIdx) {
                    buf.append(": ");
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private TreeModel createTreeModel() {
        this.rootGroup.sort();
        return new DefaultTreeModel(this.createGroupNode(this.rootGroup));
    }

    private DefaultMutableTreeNode createGroupNode(SessionPropertyGroup group) {
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
        Enumeration myEnum = group.getChildren();
        while (myEnum.hasMoreElements()) {
            Object next = myEnum.nextElement();
            if (next instanceof SessionPropertyGroup) {
                groupNode.add(this.createGroupNode((SessionPropertyGroup)next));
                continue;
            }
            if (!(next instanceof SessionPropertyPane)) continue;
            SessionPropertyPane pane = (SessionPropertyPane)next;
            groupNode.add(new DefaultMutableTreeNode(pane, false));
            this.cardPanel.add((Component)pane, pane.getIdentifier());
        }
        return groupNode;
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        private CellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, hasFocus);
            this.setIcon(null);
            return this;
        }
    }
}

