/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import org.gjt.sp.util.Log;
import sessions.DefaultSessionPropertyPane;
import sessions.SessionPropertyPane;

public class SessionPropertyGroup {
    private String label;
    private Vector children;

    public SessionPropertyGroup(String label) {
        this.label = label;
        this.children = new Vector();
    }

    public String getLabel() {
        return this.label;
    }

    public void addGroup(SessionPropertyGroup group) {
        if (this.children.indexOf(group) == -1) {
            this.children.addElement(group);
        }
    }

    public void addPane(SessionPropertyPane pane) {
        if (this.children.indexOf(pane) == -1) {
            this.children.addElement(pane);
        }
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public void save() {
        Enumeration myEnum = this.getChildren();
        while (myEnum.hasMoreElements()) {
            Object elem = myEnum.nextElement();
            try {
                if (elem instanceof SessionPropertyPane) {
                    ((SessionPropertyPane)elem).save();
                    continue;
                }
                if (!(elem instanceof SessionPropertyGroup)) continue;
                ((SessionPropertyGroup)elem).save();
            }
            catch (Throwable t) {
                Log.log((int)9, elem, (Object)"Error saving session properties pane");
                Log.log((int)9, elem, (Object)t);
            }
        }
    }

    public final String toString() {
        return this.getLabel();
    }

    void sort() {
        Collections.sort(this.children, new PaneCompare());
    }

    private class PaneCompare
    implements Comparator {
        private PaneCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 instanceof DefaultSessionPropertyPane) {
                return Integer.MIN_VALUE;
            }
            if (obj2 instanceof DefaultSessionPropertyPane) {
                return Integer.MAX_VALUE;
            }
            return obj1.toString().compareTo(obj2.toString());
        }
    }
}

