/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.jEdit;
import sessions.Session;

public abstract class SessionPropertyPane
extends JPanel {
    protected Session session;
    protected GridBagLayout gridBag;
    protected int y;
    private boolean initialized;

    public SessionPropertyPane(Session session) {
        this.session = session;
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
    }

    public abstract String getIdentifier();

    public abstract String getLabel();

    public abstract void _init();

    public abstract void _save();

    public final String toString() {
        return this.getLabel();
    }

    protected void addComponent(Component leftComp, Component rightComp) {
        if (!(this.getLayout() instanceof GridBagLayout)) {
            throw new IllegalStateException("current layout manager is no GridBagLayout, current is: " + this.getLayout().getClass().getName());
        }
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.fill = 1;
        this.gridBag.setConstraints(leftComp, cons);
        this.add(leftComp);
        cons.gridx = 1;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(rightComp, cons);
        this.add(rightComp);
    }

    protected void addComponent(String labelProperty, Component comp) {
        String label = jEdit.getProperty((String)labelProperty);
        if (label == null) {
            label = labelProperty;
        }
        JLabel l = new JLabel(label, 4);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent(l, comp);
    }

    protected void addComponent(Component comp) {
        if (!(this.getLayout() instanceof GridBagLayout)) {
            throw new IllegalStateException("current layout manager is no GridBagLayout, current is: " + this.getLayout().getClass().getName());
        }
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    protected void addSeparator(String label) {
        if (!(this.getLayout() instanceof GridBagLayout)) {
            throw new IllegalStateException("current layout manager is no GridBagLayout, current is: " + this.getLayout().getClass().getName());
        }
        Box box = new Box(0);
        Box box2 = new Box(1);
        box2.add(Box.createGlue());
        box2.add(new JSeparator(0));
        box2.add(Box.createGlue());
        box.add(box2);
        JLabel l = new JLabel(" " + jEdit.getProperty((String)label) + " ");
        l.setMaximumSize(l.getPreferredSize());
        box.add(l);
        Box box3 = new Box(1);
        box3.add(Box.createGlue());
        box3.add(new JSeparator(0));
        box3.add(Box.createGlue());
        box.add(box3);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 1;
        cons.anchor = 17;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(box, cons);
        this.add(box);
    }

    void init() {
        if (!this.initialized) {
            this.initialized = true;
            this._init();
        }
    }

    void save() {
        if (this.initialized) {
            this._save();
        }
    }
}

