/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import sessions.SessionChanged;
import sessions.SessionListChanged;
import sessions.SessionManager;

public class SessionSwitcher
extends JToolBar
implements ActionListener,
ItemListener,
EBComponent {
    private View view;
    private JComboBox combo;
    private JButton save;
    private JButton saveAs;
    private JButton reload;
    private JButton props;
    private JButton prefs;
    private JLabel title;

    public SessionSwitcher(View view, boolean isInDefaultToolBar) {
        this.view = view;
        Insets nullInsets = new Insets(0, 0, 0, 0);
        SessionManager.getInstance();
        this.combo = new JComboBox<String>(SessionManager.getSessionNames());
        this.combo.setSelectedItem(SessionManager.getInstance().getCurrentSession());
        this.combo.setEditable(false);
        this.combo.addItemListener(this);
        this.save = new JButton(new ImageIcon(this.getClass().getResource("Save24.gif")));
        this.save.setMargin(nullInsets);
        this.save.setToolTipText(jEdit.getProperty((String)"sessions.switcher.save.tooltip"));
        this.save.setFocusPainted(false);
        this.save.addActionListener(this);
        this.saveAs = new JButton(new ImageIcon(this.getClass().getResource("SaveAs24.gif")));
        this.saveAs.setMargin(nullInsets);
        this.saveAs.setToolTipText(jEdit.getProperty((String)"sessions.switcher.saveAs.tooltip"));
        this.saveAs.setFocusPainted(false);
        this.saveAs.addActionListener(this);
        this.reload = new JButton(new ImageIcon(this.getClass().getResource("Redo24.gif")));
        this.reload.setMargin(nullInsets);
        this.reload.setToolTipText(jEdit.getProperty((String)"sessions.switcher.reload.tooltip"));
        this.reload.setFocusPainted(false);
        this.reload.addActionListener(this);
        this.props = new JButton(new ImageIcon(this.getClass().getResource("History24.gif")));
        this.props.setMargin(nullInsets);
        this.props.setToolTipText(jEdit.getProperty((String)"sessions.switcher.props.tooltip"));
        this.props.setFocusPainted(false);
        this.props.addActionListener(this);
        this.prefs = new JButton(new ImageIcon(this.getClass().getResource("Preferences24.gif")));
        this.prefs.setMargin(nullInsets);
        this.prefs.setToolTipText(jEdit.getProperty((String)"sessions.switcher.prefs.tooltip"));
        this.prefs.setFocusPainted(false);
        this.prefs.addActionListener(this);
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.addSeparator(new Dimension(5, 5));
        this.add(this.combo);
        this.addSeparator();
        this.add(this.save);
        this.add(this.saveAs);
        this.add(this.reload);
        this.add(this.prefs);
        if (!isInDefaultToolBar) {
            this.add(Box.createGlue());
        }
        this.updateTitle();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertiesChanged) {
            this.updateTitle();
        } else if (message instanceof SessionChanged) {
            this.handleSessionChanged((SessionChanged)message);
        } else if (message instanceof SessionListChanged) {
            this.handleSessionListChanged((SessionListChanged)message);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.save) {
            SessionManager.getInstance().saveCurrentSession(this.view);
        } else if (evt.getSource() == this.saveAs) {
            SessionManager.getInstance().saveCurrentSessionAs(this.view);
        } else if (evt.getSource() == this.reload) {
            SessionManager.getInstance().reloadCurrentSession(this.view);
        } else if (evt.getSource() == this.props) {
            SessionManager.getInstance().showSessionPropertiesDialog(this.view);
        } else if (evt.getSource() == this.prefs) {
            SessionManager.getInstance().showSessionManagerDialog(this.view);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1 || e.getItem() == null) {
            return;
        }
        String currentSession = SessionManager.getInstance().getCurrentSession();
        String selectedSession = e.getItem().toString();
        if (selectedSession.equals(currentSession)) {
            return;
        }
        SessionManager.getInstance().setCurrentSession(this.view, selectedSession);
        this.updateSessionComboBox();
    }

    private void handleSessionChanged(SessionChanged msg) {
        this.updateSessionComboBox();
    }

    private void updateSessionComboBox() {
        final String newSession = SessionManager.getInstance().getCurrentSession();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SessionSwitcher.this.combo.setSelectedItem(newSession);
            }
        });
    }

    private void handleSessionListChanged(SessionListChanged msg) {
        msg.getSessionManager();
        final String[] sessions = SessionManager.getSessionNames();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SessionSwitcher.this.combo.setModel(new DefaultComboBoxModel<String>(sessions));
            }
        });
    }

    private void updateTitle() {
        if (jEdit.getBooleanProperty((String)"sessions.switcher.showTitle", (boolean)true)) {
            this.addTitle();
        } else {
            this.removeTitle();
        }
    }

    private void addTitle() {
        if (this.title != null) {
            return;
        }
        this.title = new JLabel(jEdit.getProperty((String)"sessions.switcher.title"));
        this.add((Component)this.title, 0);
        this.revalidate();
    }

    private void removeTitle() {
        if (this.title == null) {
            return;
        }
        this.remove(this.title);
        this.revalidate();
        this.title = null;
    }
}

