/*
 * Decompiled with CFR 0.152.
 */
package sessions;

import java.awt.Component;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditorExitRequested;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.StandardUtilities;
import sessions.DefaultSessionPropertyPane;
import sessions.SessionManager;
import sessions.SessionPropertiesShowing;
import sessions.SessionSwitcher;

public class SessionsPlugin
extends EBPlugin {
    private Hashtable viewSessionSwitchers = new Hashtable();

    public void start() {
        boolean restore = jEdit.getBooleanProperty((String)"restore");
        boolean restore_cli = jEdit.getBooleanProperty((String)"restore.cli");
        boolean autosave = jEdit.getBooleanProperty((String)"sessions.switcher.autoSave", (boolean)true);
        if (!(restore && restore_cli || !autosave)) {
            SessionsPlugin.showInfoMessage("sessions.manager.info.restore_autosave");
        } else if (!restore) {
            SessionsPlugin.showInfoMessage("sessions.manager.info.restore");
        }
        SessionManager mgr = SessionManager.getInstance();
        mgr.getCurrentSessionInstance().open(jEdit.getActiveView(), false);
        mgr.setSessionNameInTitleBar();
        mgr.refreshTitleBar();
        if (jEdit.getBooleanProperty((String)"sessions.switcher.showToolBar", (boolean)false)) {
            View[] views = jEdit.getViews();
            for (int i = 0; i < views.length; ++i) {
                this.addSessionSwitcher(views[i]);
            }
        }
    }

    public void stop() {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            this.removeSessionSwitcher(views[i]);
        }
        SessionManager mgr = SessionManager.getInstance();
        mgr.restoreTitleBarText();
        mgr.refreshTitleBar();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof ViewUpdate) {
            ViewUpdate vu = (ViewUpdate)message;
            if (vu.getWhat() == ViewUpdate.CREATED) {
                if (jEdit.getBooleanProperty((String)"sessions.switcher.showToolBar", (boolean)false)) {
                    this.addSessionSwitcher(vu.getView());
                }
            } else if (vu.getWhat() == ViewUpdate.CLOSED) {
                this.viewSessionSwitchers.remove(vu.getView());
            }
        } else if (message instanceof EditorExitRequested) {
            this.handleEditorExit((EditorExitRequested)message);
        } else if (message instanceof PropertiesChanged) {
            this.handlePropertiesChanged();
        } else if (message instanceof SessionPropertiesShowing) {
            SessionPropertiesShowing smsg = (SessionPropertiesShowing)message;
            smsg.addPropertyPane(new DefaultSessionPropertyPane(smsg.getSession()));
        }
    }

    public static boolean isBufferListAvailable(View view) {
        EditPlugin bufferlist = jEdit.getPlugin((String)"bufferlist.BufferListPlugin");
        if (bufferlist == null) {
            return false;
        }
        String version = jEdit.getProperty((String)"plugin.bufferlist.BufferListPlugin.version");
        if (version == null || version.length() == 0 || StandardUtilities.compareStrings((String)version, (String)"0.8", (boolean)true) < 0) {
            return false;
        }
        return SessionsPlugin.getBufferList(view) != null;
    }

    private static JComponent getBufferList(View view) {
        DockableWindowManager mgr = view.getDockableWindowManager();
        return mgr.getDockable("bufferlist");
    }

    private void handleEditorExit(EditorExitRequested eemsg) {
        SessionManager mgr = SessionManager.getInstance();
        if (!mgr.autosaveCurrentSession(eemsg.getView())) {
            eemsg.cancelExit();
        }
    }

    private void handlePropertiesChanged() {
        boolean show = jEdit.getBooleanProperty((String)"sessions.switcher.showToolBar", (boolean)false);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            if (show) {
                this.addSessionSwitcher(view);
                continue;
            }
            this.removeSessionSwitcher(view);
        }
        SessionManager mgr = SessionManager.getInstance();
        if (jEdit.getBooleanProperty((String)"sessions.switcher.showSessionNameInTitleBar", (boolean)true)) {
            mgr.setSessionNameInTitleBar();
        } else {
            mgr.restoreTitleBarText();
        }
        mgr.refreshTitleBar();
    }

    private synchronized void addSessionSwitcher(final View view) {
        this.removeSessionSwitcher(view);
        final SessionSwitcher switcher = new SessionSwitcher(view, true);
        this.viewSessionSwitchers.put(view, switcher);
        if (jEdit.getBooleanProperty((String)"sessions.switcher.showJEditToolBar", (boolean)false)) {
            if (view.getToolBar() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        view.getToolBar().add(switcher);
                        view.getRootPane().revalidate();
                    }
                });
            }
        } else if (jEdit.getBooleanProperty((String)"sessions.switcher.showInsideBufferList", (boolean)false)) {
            final JComponent bufferlist = SessionsPlugin.getBufferList(view);
            if (bufferlist != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        bufferlist.add("North", switcher);
                        bufferlist.revalidate();
                    }
                });
            }
        } else {
            view.addToolBar((Component)switcher);
        }
    }

    private synchronized void removeSessionSwitcher(View view) {
        SessionSwitcher switcher = (SessionSwitcher)this.viewSessionSwitchers.get(view);
        if (switcher != null) {
            JComponent bufferlist;
            view.removeToolBar((Component)switcher);
            this.viewSessionSwitchers.remove(view);
            if (view.getToolBar() != null) {
                view.getToolBar().remove(switcher);
                view.getRootPane().revalidate();
            }
            if ((bufferlist = SessionsPlugin.getBufferList(view)) != null) {
                bufferlist.remove(switcher);
            }
        }
    }

    public static void showInfoMessage(String key) {
        if (!jEdit.getBooleanProperty((String)(key + ".notAgain"))) {
            String title = jEdit.getProperty((String)(key + ".title"));
            String msg = jEdit.getProperty((String)(key + ".message"));
            String msg2 = jEdit.getProperty((String)"sessions.manager.info.dontShowAgain");
            JCheckBox notAgain = new JCheckBox(msg2, false);
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(null, new Object[]{msg, notAgain}, title, 1);
            jEdit.setBooleanProperty((String)(key + ".notAgain"), (boolean)notAgain.isSelected());
        }
    }
}

