package favorites;

import java.io.*;
import java.util.*;
import javax.swing.tree.*;

import org.gjt.sp.jedit.*;

public class FileTreeNode implements TreeNode, Comparable,Cloneable {
  
  private String name;
  private String path;
  // private Vector children; // qm[h̔z
  // private HashMap hash; // m[h̃nbV
  private VectorHash children; // qm[hVectorHash
  private boolean leaf; // gtł邩
  private TreeNode parent; // em[h
  
  public static String TYPE_FILE = "File";
  public static String TYPE_DIRECTORY = "Directory";
  private String type; //ށFFileƂDirectoryƂ
  
  public FileTreeNode(String name, String path, String type) {
    children = new VectorHash();
    // hash = new HashMap();
    this.name = name;
    this.path = path.replace('\\','/');
    this.type = type;
    leaf = true;
  }
  
  public FileTreeNode(String name, String path) {
    this(name,path,TYPE_FILE);
  }
  
  public FileTreeNode(String name) {
    this(name, "");
    leaf = false;
  }
  
  public boolean renameGroup(FileTreeNode node, String newname){
    if (node.isLeaf()){
      return false;
    }
    
    if (children.containsKey(newname)){
      return false;
    }
    
    if (!children.containsKey(node.getKey())){
      return false;
    }
    int index = children.getIndex(node.getKey());
    children.remove(node.getKey());
    node.setName(newname);
    children.insert(node.getKey(),node,index);
    return true;
  }
  
  public boolean add(FileTreeNode node){
    if (children.containsKey(node.getKey())){
      return false;
    }
    
    node.setParent(this);
    int index = 0;
    for (index = 0; index < children.size(); index++){
      if (node.compareTo(children.get(index)) <= 0){
        break;
      }
    }
    
    children.insert(node.getKey(),node,index);
    return true;
  }
  
  public boolean add(Buffer buffer){
    return this.add(new FileTreeNode(buffer.getName(), buffer.getPath()));
  }
  
  public boolean addPathNode(String path){
    return this.add(new FileTreeNode("", path, TYPE_DIRECTORY));
  }
  
  public void delete(FileTreeNode node){
    if (node == null){
      return;
    }
    children.remove(node.getKey());
  }
  
  public void setParent(FileTreeNode node){
    this.parent = node;
  }
  
  //TreeNode\bh̎
  
  //qm[hɃANZX邽߂EnumerationԂ
  public Enumeration children() {
    return children.elements();
  }
  
  //qm[hɃANZXł邩ǂԂ
  public boolean getAllowsChildren() {
    return !leaf; 
  }
  
  //CfbNXԖڂ̎qm[hԂ
  public TreeNode getChildAt(int index) {
    return (TreeNode)children.get(index);
  }
  
  //qm[h̐Ԃ
  public int getChildCount() {
    return children.size();
  }
  
  //̎qm[hԖڂȂ̂Ԃ
  public int getIndex(TreeNode node) {
    if (!(node instanceof FileTreeNode)){
      return -1;
    }
    return children.getIndex(((FileTreeNode)node).getKey());
  }
  
  //qm[hԂ
  public TreeNode getChild(Object key) {
    return (TreeNode)children.get(key);
  }
  
  //em[hԂ
  public TreeNode getParent() {
    if(parent != null) {
      return parent;
    } else { 
      return null;
    }
  }
  
  //tł邩ǂԂ
  public boolean isLeaf() {
    return leaf;
  }
  
  public String toString(){
    if (isLeaf()){
      return name + " (" + path + ")";
    } else {
      return name;
    }
    
  }
  
  public String getKey(){
    if (isLeaf()){
      return path;
    } else {
      return name;
    }
  }
  
  public String getPath(){
    return path;
  }
  
  public String getName(){
    return name;
  }
  
  private void setName(String name){
    this.name = name;
  }
  
  public String getType(){
    return type;
  }
  
  public int compareTo(Object o){
    if (!(o instanceof FileTreeNode)){
      return 0;
    }
    FileTreeNode node = (FileTreeNode)o;
    if (isLeaf() && !node.isLeaf()){
      return 1;
    }
    
    if (!isLeaf() && node.isLeaf()){
      return -1;
    }
    
    if (TYPE_DIRECTORY.equals(getType()) && !TYPE_DIRECTORY.equals(node.getType())){
      return -1;
    }
    
    if (!TYPE_DIRECTORY.equals(getType()) && TYPE_DIRECTORY.equals(node.getType())){
      return 1;
    }
    
    // if (isLeaf()){
    // return getPath().compareToIgnoreCase(node.toString());
    // }
    
    // if (!isLeaf()){
    return toString().compareToIgnoreCase(node.toString());
    // }
    
    // return 0;
  }
  
  /**
  * FileTreeNode Rs[܂B
  * Rs[͎qz̕QƂ܂B
  * 
  *@return    VectorHash ̃Rs[
  */
  public Object clone(){
    FileTreeNode clone = null;
    try {
      clone = (FileTreeNode)super.clone();
      clone.children = (VectorHash)clone.children.clone();
    } catch (Exception e){
    }
    
    return clone;
  }
  
}
